/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.castle.client.model.generated.DeviceContextLocation;
import io.castle.client.model.generated.DeviceContextUserAgent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Context for the most recent activity")
public class DeviceContext {
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private String ip;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private DeviceContextLocation location;
    public static final String SERIALIZED_NAME_USER_AGENT = "user_agent";
    @SerializedName(value="user_agent")
    private DeviceContextUserAgent userAgent;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    private Map<String, Object> properties = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    @Nonnull
    @ApiModelProperty(example="211.96.77.55", required=true, value="The IPv4 or IPv6 address of the originating request. Must be a valid, public IP. Supports ipv4 and ipv6 ")
    public String getIp() {
        return this.ip;
    }

    public DeviceContext location(DeviceContextLocation location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DeviceContextLocation getLocation() {
        return this.location;
    }

    public void setLocation(DeviceContextLocation location) {
        this.location = location;
    }

    public DeviceContext userAgent(DeviceContextUserAgent userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DeviceContextUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(DeviceContextUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public DeviceContext properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public DeviceContext putPropertiesItem(String key, Object propertiesItem) {
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="User defined properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Nonnull
    @ApiModelProperty(example="desktop", required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceContext deviceContext = (DeviceContext)o;
        return Objects.equals(this.ip, deviceContext.ip) && Objects.equals(this.location, deviceContext.location) && Objects.equals(this.userAgent, deviceContext.userAgent) && Objects.equals(this.properties, deviceContext.properties) && Objects.equals((Object)this.type, (Object)deviceContext.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ip, this.location, this.userAgent, this.properties, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceContext {\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        DESKTOP("desktop"),
        MOBILE("mobile"),
        TABLET("tablet"),
        OTHER("other");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

