/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Location of matched device.")
public class DeviceContextLocation {
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private String countryCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_REGION_CODE = "region_code";
    @SerializedName(value="region_code")
    private String regionCode;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_LAT = "lat";
    @SerializedName(value="lat")
    private BigDecimal lat;
    public static final String SERIALIZED_NAME_LON = "lon";
    @SerializedName(value="lon")
    private BigDecimal lon;

    @Nonnull
    @ApiModelProperty(example="US", required=true, value="")
    public String getCountryCode() {
        return this.countryCode;
    }

    @Nonnull
    @ApiModelProperty(example="United States", required=true, value="")
    public String getCountry() {
        return this.country;
    }

    @Nonnull
    @ApiModelProperty(example="California", required=true, value="")
    public String getRegion() {
        return this.region;
    }

    @Nonnull
    @ApiModelProperty(example="CA", required=true, value="")
    public String getRegionCode() {
        return this.regionCode;
    }

    @Nonnull
    @ApiModelProperty(example="San Francisco", required=true, value="")
    public String getCity() {
        return this.city;
    }

    @Nonnull
    @ApiModelProperty(example="37.7749", required=true, value="")
    public BigDecimal getLat() {
        return this.lat;
    }

    @Nonnull
    @ApiModelProperty(example="122.4194", required=true, value="")
    public BigDecimal getLon() {
        return this.lon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceContextLocation deviceContextLocation = (DeviceContextLocation)o;
        return Objects.equals(this.countryCode, deviceContextLocation.countryCode) && Objects.equals(this.country, deviceContextLocation.country) && Objects.equals(this.region, deviceContextLocation.region) && Objects.equals(this.regionCode, deviceContextLocation.regionCode) && Objects.equals(this.city, deviceContextLocation.city) && Objects.equals(this.lat, deviceContextLocation.lat) && Objects.equals(this.lon, deviceContextLocation.lon);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.country, this.region, this.regionCode, this.city, this.lat, this.lon);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceContextLocation {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    regionCode: ").append(this.toIndentedString(this.regionCode)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    lat: ").append(this.toIndentedString(this.lat)).append("\n");
        sb.append("    lon: ").append(this.toIndentedString(this.lon)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

