/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.annotations.SerializedName;
import io.castle.client.model.generated.Address;
import io.castle.client.model.generated.MerchantCategory;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class Merchant {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private MerchantCategory category;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private Address address;

    public Merchant id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="a2c8e7ef-40da-42f2-9b7d-cd928e5f8279", value="Merchant Identifier")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Merchant name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United Airlines", value="Merchant Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Merchant category(MerchantCategory category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MerchantCategory getCategory() {
        return this.category;
    }

    public void setCategory(MerchantCategory category) {
        this.category = category;
    }

    public Merchant address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Merchant merchant = (Merchant)o;
        return Objects.equals(this.id, merchant.id) && Objects.equals(this.name, merchant.name) && Objects.equals(this.category, merchant.category) && Objects.equals(this.address, merchant.address);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.category, this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Merchant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

