/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The matching policy")
public class Policy {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REVISION_ID = "revision_id";
    @SerializedName(value="revision_id")
    private String revisionId;
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private ActionEnum action;

    public Policy name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Challenge risk >= 60", required=true, value="Name of the matching policy")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Policy id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2ee938c8-24c2-4c26-9d25-19511dd75029", required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Policy revisionId(String revisionId) {
        this.revisionId = revisionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="900b183a-9f6d-4579-8c47-9ddcccf637b4", required=true, value="")
    public String getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public Policy action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="challenge", required=true, value="")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.name, policy.name) && Objects.equals(this.id, policy.id) && Objects.equals(this.revisionId, policy.revisionId) && Objects.equals((Object)this.action, (Object)policy.action);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.id, this.revisionId, this.action});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Policy {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    revisionId: ").append(this.toIndentedString(this.revisionId)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionEnum {
        ALLOW("allow"),
        CHALLENGE("challenge"),
        DENY("deny");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ActionEnum> {
            public void write(JsonWriter jsonWriter, ActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionEnum.fromValue(value);
            }
        }
    }
}

