/*
 * Decompiled with CFR 0.152.
 */
package io.castle.client.model.generated;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.castle.client.model.generated.Address;
import io.castle.client.model.generated.Amount;
import io.castle.client.model.generated.Merchant;
import io.castle.client.model.generated.PaymentMethod;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Transaction {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_BASE_AMOUNT = "base_amount";
    @SerializedName(value="base_amount")
    private String baseAmount;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";
    @SerializedName(value="payment_method")
    private PaymentMethod paymentMethod;
    public static final String SERIALIZED_NAME_SHIPPING_ADDRESS = "shipping_address";
    @SerializedName(value="shipping_address")
    private Address shippingAddress;
    public static final String SERIALIZED_NAME_MERCHANT = "merchant";
    @SerializedName(value="merchant")
    private Merchant merchant;

    public Transaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Transaction id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="900b183a-9f6d-4579-8c47-9ddcccf637b4", required=true, value="Unique identifier for this transaction. Use this to link the flow of your transactions with different events and types ")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Transaction baseAmount(String baseAmount) {
        this.baseAmount = baseAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="499.99", value="Monetary amount of the transaction in your system's home currency, with two decimals")
    public String getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(String baseAmount) {
        this.baseAmount = baseAmount;
    }

    public Transaction amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transaction paymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Transaction shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Transaction merchant(Merchant merchant) {
        this.merchant = merchant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Merchant getMerchant() {
        return this.merchant;
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals((Object)this.type, (Object)transaction.type) && Objects.equals(this.id, transaction.id) && Objects.equals(this.baseAmount, transaction.baseAmount) && Objects.equals(this.amount, transaction.amount) && Objects.equals(this.paymentMethod, transaction.paymentMethod) && Objects.equals(this.shippingAddress, transaction.shippingAddress) && Objects.equals(this.merchant, transaction.merchant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.baseAmount, this.amount, this.paymentMethod, this.shippingAddress, this.merchant});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    baseAmount: ").append(this.toIndentedString(this.baseAmount)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    merchant: ").append(this.toIndentedString(this.merchant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PURCHASE("$purchase"),
        WITHDRAWAL("$withdrawal"),
        DEPOSIT("$deposit"),
        TRANSFER("$transfer"),
        REWARD("$reward"),
        SALE("$sale");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

