/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.codeql;

import com.google.inject.AbstractModule;
import io.codemodder.CodeChanger;
import io.codemodder.RuleSarif;
import io.codemodder.providers.sarif.codeql.ProvidedCodeQLScan;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public final class CodeQLModule
extends AbstractModule {
    private final List<Class<? extends CodeChanger>> codemodTypes;
    private final List<RuleSarif> allCodeqlRuleSarifs;

    CodeQLModule(List<Class<? extends CodeChanger>> codemodTypes, List<RuleSarif> sarifs) {
        this.codemodTypes = Objects.requireNonNull(codemodTypes);
        this.allCodeqlRuleSarifs = sarifs;
    }

    protected void configure() {
        Map<String, RuleSarif> map = this.allCodeqlRuleSarifs.stream().collect(Collectors.toUnmodifiableMap(RuleSarif::getRule, rs -> rs));
        for (Class<? extends CodeChanger> codemodType : this.codemodTypes) {
            Constructor<?>[] constructors = codemodType.getDeclaredConstructors();
            Optional<ProvidedCodeQLScan> annotation = Stream.of(constructors).filter(constructor -> constructor.getAnnotation(Inject.class) != null).flatMap(constructor -> Stream.of(constructor.getParameters())).map(parameter -> parameter.getAnnotation(ProvidedCodeQLScan.class)).filter(Objects::nonNull).findFirst();
            annotation.ifPresent(providedCodeQLScan -> this.bind(RuleSarif.class).annotatedWith((Annotation)providedCodeQLScan).toInstance((Object)map.getOrDefault(providedCodeQLScan.ruleId(), RuleSarif.EMPTY)));
        }
    }
}

