/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFAiMetadata;
import io.codemodder.codetf.CodeTFChange;
import io.codemodder.codetf.CodeTFValidator;
import io.codemodder.codetf.FixQuality;
import io.codemodder.codetf.FixedFinding;
import io.codemodder.codetf.Strategy;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class CodeTFChangesetEntry {
    private final String path;
    private final String diff;
    private final List<CodeTFChange> changes;
    private final CodeTFAiMetadata ai;
    private final Strategy strategy;
    private final boolean provisional;
    private final List<FixedFinding> fixedFindings;
    private final FixQuality fixQuality;

    @JsonCreator
    public CodeTFChangesetEntry(@JsonProperty(value="path") String path, @JsonProperty(value="diff") String diff, @JsonProperty(value="changes") List<CodeTFChange> changes, @JsonProperty(value="ai") CodeTFAiMetadata ai, @JsonProperty(value="strategy") Strategy strategy, @JsonProperty(value="provisional") boolean provisional, @JsonProperty(value="fixedFindings") List<FixedFinding> fixedFindings, @JsonProperty(value="fixQuality") FixQuality fixQuality) {
        this.path = CodeTFValidator.requireRelativePath(path);
        this.diff = CodeTFValidator.requireNonBlank(diff);
        this.changes = CodeTFValidator.toImmutableCopyOrEmptyOnNull(changes);
        this.ai = ai;
        this.strategy = strategy;
        this.provisional = provisional;
        this.fixedFindings = CodeTFValidator.toImmutableCopyOrEmptyOnNull(fixedFindings);
        this.fixQuality = fixQuality;
    }

    public CodeTFChangesetEntry(String path, String diff, List<CodeTFChange> changes) {
        this(path, diff, changes, null, null, false, null, null);
    }

    public String getPath() {
        return this.path;
    }

    public String getDiff() {
        return this.diff;
    }

    public List<CodeTFChange> getChanges() {
        return this.changes;
    }

    public CodeTFAiMetadata getAi() {
        return this.ai;
    }

    public boolean usesAi() {
        return this.ai != null;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public boolean isProvisional() {
        return this.provisional;
    }

    public FixQuality getFixQuality() {
        return this.fixQuality;
    }

    public List<FixedFinding> getFixedFindings() {
        return Stream.concat(this.fixedFindings.stream(), this.changes.stream().map(CodeTFChange::getFixedFindings).flatMap(Collection::stream)).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeTFChangesetEntry entry = (CodeTFChangesetEntry)o;
        return Objects.equals(this.path, entry.path) && Objects.equals(this.diff, entry.diff) && Objects.equals(this.changes, entry.changes) && Objects.equals(this.ai, entry.ai) && Objects.equals((Object)this.strategy, (Object)entry.strategy) && Objects.equals(this.provisional, entry.provisional);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.diff, this.changes, this.ai, this.strategy, this.provisional});
    }

    public String toString() {
        return "CodeTFChangesetEntry{path='" + this.path + "', diff='" + this.diff + "', changes=" + String.valueOf(this.changes) + "}";
    }
}

