/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class CodeTFValidator {
    CodeTFValidator() {
    }

    static String optionalString(String s) {
        if (s != null && s.isBlank()) {
            throw new IllegalArgumentException("string can't be blank");
        }
        return s;
    }

    static String requireNonBlank(String s) {
        if (s == null) {
            throw new IllegalArgumentException("string can't be null");
        }
        if (s.isBlank()) {
            throw new IllegalArgumentException("string can't be blank");
        }
        return s;
    }

    static String requireRelativePath(String path) {
        CodeTFValidator.requireNonBlank(path);
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("path must be relative");
        }
        return path;
    }

    static <K, V> Map<K, V> toImmutableCopyOrEmptyOnNull(Map<K, V> givenMap) {
        if (givenMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(givenMap);
    }

    static <T> List<T> toImmutableCopyOrEmptyOnNull(List<T> givenList) {
        if (givenList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(givenList);
    }

    static <T> Set<T> toImmutableCopyOrEmptyOnNull(Set<T> givenList) {
        if (givenList == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(givenList);
    }
}

