/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.v3.DiffSide;
import io.codemodder.codetf.v3.PackageAction;
import java.util.List;
import java.util.Map;

public final class Change {
    private final int lineNumber;
    private final String description;
    private final DiffSide diffSide;
    private final Map<String, Object> properties;
    private final List<PackageAction> packageActions;

    @JsonCreator
    public Change(@JsonProperty(value="lineNumber") int lineNumber, @JsonProperty(value="description") String description, @JsonProperty(value="diffSide") DiffSide diffSide, @JsonProperty(value="properties") Map<String, Object> properties, @JsonProperty(value="packageActions") List<PackageAction> packageActions) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("lineNumber must be greater than 0");
        }
        if (description != null && description.isEmpty()) {
            throw new IllegalArgumentException("description must not be empty");
        }
        this.lineNumber = lineNumber;
        this.description = description;
        this.diffSide = diffSide != null ? diffSide : DiffSide.RIGHT;
        this.properties = properties;
        this.packageActions = packageActions;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public DiffSide getDiffSide() {
        return this.diffSide;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<PackageAction> getPackageActions() {
        return this.packageActions;
    }
}

