/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.v3.FixResult;
import io.codemodder.codetf.v3.FixStatusType;
import io.codemodder.codetf.v3.Run;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class CodeTF {
    private final Run run;
    private final List<FixResult> results;

    @JsonCreator
    public CodeTF(@JsonProperty(value="run") Run run, @JsonProperty(value="results") List<FixResult> results) {
        this.run = Objects.requireNonNull(run, "run cannot be null");
        this.results = results != null ? Collections.unmodifiableList(results) : Collections.emptyList();
    }

    public Run getRun() {
        return this.run;
    }

    public List<FixResult> getResults() {
        return this.results;
    }

    public boolean hasCodeChanges() {
        return this.results.stream().filter(result -> result.getFixStatus().getStatus() == FixStatusType.FIXED).anyMatch(result -> !result.getChangeSets().isEmpty());
    }
}

