/*
 * Decompiled with CFR 0.152.
 */
package cronapi.cloud;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectRequest;
import cronapi.AppConfig;
import cronapi.Var;
import cronapi.cloud.CloudService;
import cronapi.cloud.FieldData;
import cronapi.cloud.FileObject;
import cronapi.util.Operations;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3Service
implements CloudService {
    private static final Logger log = LoggerFactory.getLogger(S3Service.class);
    private AmazonS3 client;
    private final List<FileObject> files;
    private FieldData fieldData;

    S3Service(FieldData fieldData, List<FileObject> files) {
        this.fieldData = fieldData;
        this.files = files;
    }

    private String decrypt(String value) {
        if (!StringUtils.isEmpty((CharSequence)value) && value.startsWith("$")) {
            value = value.substring(1);
            try {
                value = Operations.decrypt(Var.valueOf(value), Var.valueOf(AppConfig.guid())).getObjectAsString();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    private AmazonS3 getClient() {
        if (this.client == null) {
            String key = this.decrypt(this.fieldData.data.value());
            String secret = this.decrypt(this.fieldData.data.secret());
            BasicAWSCredentials credentials = new BasicAWSCredentials(key, secret);
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Regions.US_EAST_1)).withCredentials((AWSCredentialsProvider)credentialsProvider)).build();
        }
        return this.client;
    }

    @Override
    public void upload() {
        if (this.files == null || this.files.isEmpty()) {
            log.warn("File content not found to upload");
            return;
        }
        this.files.forEach(fileObject -> {
            try {
                PutObjectRequest request = new PutObjectRequest(this.fieldData.data.id(), AppConfig.guid() + fileObject.getFileName(), fileObject.getFileContent(), null);
                this.getClient().putObject(request);
                fileObject.setFileDirectUrl("https://s3.amazonaws.com/" + this.fieldData.data.id() + "/" + AppConfig.guid() + fileObject.getFileName());
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        });
    }

    @Override
    public void popule(Object target) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void delete() {
        throw new RuntimeException("Not Implemented");
    }
}

