/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.ClientCommand;
import cronapi.ErrorResponse;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.Utils;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.database.DatabaseQueryManager;
import cronapi.database.HistoryListener;
import cronapi.database.JPAUtil;
import cronapi.i18n.Messages;
import cronapi.odata.server.BlocklyQuery;
import cronapi.odata.server.JPQLParserUtil;
import cronapi.odata.server.ODataQueryInterface;
import cronapi.odata.server.WebServicesQuery;
import cronapi.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.ClientCallback;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.edm.provider.EdmEntityTypeImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.data.ReflectionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClass;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.jpql.HermesParser;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExtensionEntityListener
extends ODataJPAQueryExtensionEntityListener {
    private static final Logger log = LoggerFactory.getLogger(QueryExtensionEntityListener.class);
    private ODataQueryInterface GETBlocklyQuery;
    private String GETFunctionName;

    private void findInputParams(Expression expression, List<String> inputs) {
        if (expression instanceof InputParameter) {
            inputs.add(expression.toString());
        }
        if (expression.children() != null) {
            expression.children().forEach(e -> this.findInputParams((Expression)e, inputs));
        }
    }

    private String getBlocklyMethod(UriInfo uriInfo, JsonObject customQuery) {
        String restMethod = this.getRestMehtod(uriInfo);
        return this.getBlocklyMethod(customQuery, restMethod);
    }

    private String getBlocklyMethod(JsonObject customQuery, String restMethod) {
        if (QueryManager.isNull(customQuery.get("entityFullName"))) {
            String blocklyMethod = QueryManager.getBlocklyMethod(customQuery, restMethod);
            if (!QueryManager.isNull(customQuery.get("baseEntity")) && "default".equals(blocklyMethod)) {
                return null;
            }
            return blocklyMethod;
        }
        return null;
    }

    private String getRestMehtod(UriInfo uriInfo) {
        String restMethod = RestClient.getRestClient().getMethod();
        if ("GET".equals(restMethod) && (uriInfo.getFilter() != null || uriInfo.getKeyPredicates() != null && uriInfo.getKeyPredicates().size() > 0)) {
            restMethod = "FILTER";
        }
        if (uriInfo.isCount()) {
            restMethod = "COUNT";
        }
        return restMethod;
    }

    private boolean hasManyFields(String selection) {
        return selection.contains(",");
    }

    private boolean isSubField(String selection) {
        return StringUtils.isNotEmpty((CharSequence)selection) && !this.hasManyFields(selection) && selection.contains(".");
    }

    /*
     * WARNING - void declaration
     */
    public Query getBaseQuery(UriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        try {
            JsonObject customQuery = null;
            try {
                customQuery = QueryManager.getQuery(uriInfo.getTargetEntitySet().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            EdmEntityType entityType = uriInfo.getTargetEntitySet().getEntityType();
            boolean isJPQL = entityType.getName().equals("jpql");
            if (customQuery != null || isJPQL) {
                String blocklyMethod;
                if (!isJPQL) {
                    QueryManager.checkSecurity(customQuery, RestClient.getRestClient().getMethod());
                }
                boolean isBlockly = !isJPQL && QueryManager.isNull(customQuery.get("entityFullName")) && QueryManager.isNull(customQuery.get("endpoint"));
                boolean isRest = !isJPQL && QueryManager.isNull(customQuery.get("entityFullName")) && !QueryManager.isNull(customQuery.get("endpoint"));
                String restMethod = this.getRestMehtod(uriInfo);
                if (isBlockly && (blocklyMethod = this.getBlocklyMethod(uriInfo, customQuery)) == null) {
                    return null;
                }
                Query query = null;
                String whereExpression = null;
                String selectExpression = null;
                SelectStatement selectStatement = null;
                Object jpqlStatement = "";
                String mainAlias = null;
                String aliasForRawEntity = null;
                Object orderBy = null;
                LinkedList<String> inputs = new LinkedList<String>();
                String selection = null;
                boolean hasGroupBy = false;
                if (!isBlockly && !isRest) {
                    jpqlStatement = isJPQL ? RestClient.getRestClient().getParameter("jpql") : QueryManager.getJPQL(customQuery, false);
                    if (((EdmEntityTypeImplProv)entityType).getEntityType().getJpql() != null) {
                        jpqlStatement = ((EdmEntityTypeImplProv)entityType).getEntityType().getJpql();
                    }
                    JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlStatement, DefaultEclipseLinkJPQLGrammar.instance(), true);
                    this.findInputParams((Expression)jpqlExpression, inputs);
                    selectStatement = (SelectStatement)jpqlExpression.getQueryStatement();
                    selection = ((SelectClause)selectStatement.getSelectClause()).getSelectExpression().toActualText();
                    mainAlias = aliasForRawEntity = JPQLParserUtil.getMainAlias(jpqlExpression);
                    if (this.hasManyFields(selection)) {
                        mainAlias = null;
                    }
                    if (mainAlias == null && this.isSubField(selection)) {
                        mainAlias = selection;
                    }
                    if (uriInfo.rawEntity()) {
                        ReflectionUtils.setField(selectStatement, "selectClause", null);
                        if (uriInfo.rawEntity()) {
                            selectExpression = "SELECT " + aliasForRawEntity + " ";
                        }
                        jpqlStatement = selectStatement.toString();
                    }
                    if (selectStatement.hasOrderByClause()) {
                        orderBy = selectStatement.getOrderByClause().toString();
                        ReflectionUtils.setField(selectStatement, "orderByClause", null);
                        jpqlStatement = selectStatement.toString();
                    }
                    if (uriInfo.getOrderBy() != null) {
                        String orderExpression = ODataExpressionParser.parseToJPAOrderByExpression((OrderByExpression)uriInfo.getOrderBy(), (String)mainAlias);
                        orderBy = "ORDER BY " + orderExpression;
                    }
                }
                ODataExpressionParser.reInitializePositionalParameters();
                HashMap<String, Map> parameterizedExpressionMap = new HashMap<String, Map>();
                if (uriInfo.getFilter() != null) {
                    this.checkFilter(entityType, uriInfo.getFilter());
                    whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)uriInfo.getFilter(), mainAlias);
                    parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                    ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                    ODataExpressionParser.reInitializePositionalParameters();
                }
                if (uriInfo.getKeyPredicates().size() > 0) {
                    whereExpression = ODataExpressionParser.parseKeyPredicates((List)uriInfo.getKeyPredicates(), mainAlias);
                    parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                    ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                    ODataExpressionParser.reInitializePositionalParameters();
                }
                String having = null;
                String groupBy = null;
                if (whereExpression != null) {
                    String where = null;
                    if (selectStatement != null && selectStatement.hasWhereClause()) {
                        where = ((WhereClause)selectStatement.getWhereClause()).getConditionalExpression().toString();
                        ReflectionUtils.setField(selectStatement, "whereClause", null);
                        jpqlStatement = selectStatement.toString();
                    }
                    if (selectStatement != null && selectStatement.hasGroupByClause()) {
                        groupBy = ((GroupByClause)selectStatement.getGroupByClause()).toString();
                        ReflectionUtils.setField(selectStatement, "groupByClause", null);
                        jpqlStatement = selectStatement.toString();
                    }
                    if (selectStatement != null && selectStatement.hasHavingClause()) {
                        having = ((HavingClause)selectStatement.getHavingClause()).toString();
                        ReflectionUtils.setField(selectStatement, "havingClause", null);
                        jpqlStatement = selectStatement.toString();
                    }
                    jpqlStatement = where != null && uriInfo.composeWhere() ? (String)jpqlStatement + " WHERE (" + where + ") AND " + whereExpression : (String)jpqlStatement + " WHERE " + whereExpression;
                    if (having != null) {
                        jpqlStatement = (String)jpqlStatement + " " + having;
                    }
                    if (groupBy != null) {
                        jpqlStatement = (String)jpqlStatement + " " + groupBy;
                    }
                }
                if (orderBy != null) {
                    jpqlStatement = (String)jpqlStatement + " " + orderBy;
                }
                if (selectExpression != null) {
                    jpqlStatement = selectExpression + " " + (String)jpqlStatement;
                }
                Map parameterizedMap = ODataParameterizedWhereExpressionUtil.getParameterizedQueryMap();
                int maxParam = 0;
                if (parameterizedMap != null && parameterizedMap.size() > 0) {
                    for (Map.Entry parameterEntry : parameterizedMap.entrySet()) {
                        if (!((String)jpqlStatement).contains((CharSequence)parameterEntry.getKey())) continue;
                        Map map = (Map)parameterEntry.getValue();
                        for (Map.Entry param : map.entrySet()) {
                            if ((Integer)param.getKey() <= maxParam) continue;
                            maxParam = (Integer)param.getKey();
                        }
                    }
                }
                int i = maxParam;
                for (String string : inputs) {
                    jpqlStatement = ((String)jpqlStatement).replace(string, "?" + ++i);
                }
                if (!isBlockly && !isRest) {
                    query = em.createQuery((String)jpqlStatement);
                    JPAUtil.prepareQuery(query);
                } else {
                    void var27_36;
                    Object type = "select";
                    if (uriInfo.isCount()) {
                        type = "count";
                    }
                    String string = "rest";
                    if (isBlockly) {
                        String string2 = customQuery.getAsJsonObject("blockly").get("blocklyClass").getAsString() + ":" + customQuery.getAsJsonObject("blockly").get("blocklyMethod").getAsString();
                        query = new BlocklyQuery(customQuery, restMethod, (String)type, (String)jpqlStatement, uriInfo);
                    } else {
                        query = new WebServicesQuery(customQuery, restMethod, (String)type, (String)jpqlStatement, uriInfo);
                    }
                    if (uriInfo.isCount() && this.GETFunctionName != null && this.GETBlocklyQuery != null && this.GETFunctionName.equalsIgnoreCase((String)var27_36) && this.GETBlocklyQuery.getLastResult() != null && (this.GETBlocklyQuery.getLastResult().getObject() instanceof DataSource || isRest)) {
                        long total = this.GETBlocklyQuery.count();
                        ((ODataQueryInterface)query).setLastResult(Var.valueOf(total));
                        this.GETFunctionName = null;
                        this.GETBlocklyQuery = null;
                    }
                    if (restMethod.equalsIgnoreCase("GET") || restMethod.equalsIgnoreCase("FILTER")) {
                        this.GETFunctionName = var27_36;
                        this.GETBlocklyQuery = (ODataQueryInterface)query;
                    }
                }
                if (parameterizedMap != null && parameterizedMap.size() > 0) {
                    for (Map.Entry entry : parameterizedMap.entrySet()) {
                        if (!((String)jpqlStatement).contains((CharSequence)entry.getKey())) continue;
                        Map positionalParameters = (Map)entry.getValue();
                        for (Map.Entry entry2 : positionalParameters.entrySet()) {
                            if (entry2.getValue() instanceof Calendar || entry2.getValue() instanceof Timestamp) {
                                query.setParameter(((Integer)entry2.getKey()).intValue(), (Calendar)entry2.getValue(), TemporalType.TIMESTAMP);
                                continue;
                            }
                            if (entry2.getValue() instanceof Time) {
                                query.setParameter(((Integer)entry2.getKey()).intValue(), (Date)((Time)entry2.getValue()), TemporalType.TIME);
                                continue;
                            }
                            try {
                                query.setParameter(((Integer)entry2.getKey()).intValue(), entry2.getValue());
                            }
                            catch (Exception e) {
                                Class clazz = query.getParameter(((Integer)entry2.getKey()).intValue()).getParameterType();
                                if (clazz != null) {
                                    query.setParameter(((Integer)entry2.getKey()).intValue(), this.convert(entry2.getValue(), clazz));
                                    continue;
                                }
                                throw new RuntimeException(e);
                            }
                        }
                        parameterizedMap.remove(entry.getKey());
                        ODataParameterizedWhereExpressionUtil.setJPQLStatement(null);
                        break;
                    }
                }
                if (inputs.size() > 0) {
                    AbstractSession session = (AbstractSession)((EntityManagerImpl)em.getDelegate()).getActiveSession();
                    HermesParser hermesParser = new HermesParser();
                    DatabaseQuery queryParsed = hermesParser.buildQuery((CharSequence)jpqlStatement, session);
                    List argsTypes = queryParsed.getArgumentTypes();
                    List list = queryParsed.getArguments();
                    i = maxParam;
                    for (String param : inputs) {
                        String strValue = RestClient.getRestClient().getParameter(param.substring(1));
                        int idx = list.indexOf(String.valueOf(++i));
                        Class type = null;
                        if (idx == -1) continue;
                        type = (Class)argsTypes.get(idx);
                        if (strValue != null && !QueryManager.hasParameterValue(customQuery, param.substring(1))) {
                            Var requestParam = null;
                            requestParam = strValue.contains("@@") || type.getSimpleName().equals("Object") ? Var.valueOf(Var.deserialize(strValue)) : Var.valueOf(strValue);
                            if (param.indexOf("__") > 0) {
                                Class paramClass;
                                type = paramClass = Var.getType(param.substring(1));
                            }
                            query.setParameter(i, requestParam.getObject(type));
                            continue;
                        }
                        LinkedHashMap<String, Var> customValues = new LinkedHashMap<String, Var>();
                        customValues.put("entityName", Var.valueOf(uriInfo.getTargetEntitySet().getName()));
                        query.setParameter(i, QueryManager.getParameterValue(customQuery, param.substring(1), customValues).getObject(type));
                    }
                }
                if (uriInfo.isCount() && !isBlockly && !isRest) {
                    query = JPQLParserUtil.count((String)jpqlStatement, query, em);
                }
                return query;
            }
            if (entityType.getMapping() != null && ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType() != null) {
                Class clazz = ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType();
                QueryManager.checkSecurity(clazz, RestClient.getRestClient().getMethod());
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("The state field path")) {
                throw ErrorResponse.createException(new RuntimeException(Messages.getString("fieldpath")), RestClient.getRestClient().getMethod());
            }
            throw ErrorResponse.createException(e, RestClient.getRestClient().getMethod());
        }
        return null;
    }

    public Query getQuery(GetEntitySetUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        return this.getBaseQuery((UriInfo)uriInfo, em);
    }

    public Query getQuery(GetEntityCountUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        return this.getBaseQuery((UriInfo)uriInfo, em);
    }

    public Query getQuery(GetEntitySetCountUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        return this.getBaseQuery((UriInfo)uriInfo, em);
    }

    public Query getQuery(GetEntityUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        return this.getBaseQuery((UriInfo)uriInfo, em);
    }

    public Query getQuery(PutMergePatchUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        return this.getBaseQuery((UriInfo)uriInfo, em);
    }

    public Query getQuery(DeleteUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        return this.getBaseQuery((UriInfo)uriInfo, em);
    }

    public boolean authorizeProperty(EdmEntityType entityType, EdmProperty property) {
        return this.authorizeProperty(entityType, property, RestClient.getRestClient().getMethod());
    }

    public boolean authorizeProperty(EdmEntityType entityType, EdmProperty property, String method) {
        JsonObject query = null;
        try {
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null) {
                return QueryManager.isFieldAuthorized(query, property.getName(), method);
            }
            if (entityType.getMapping() != null && ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType() != null) {
                Class clazz = ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType();
                return QueryManager.isFieldAuthorized(clazz, property.getName(), method);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void checkOprAuthorization(UriInfo uriView) throws ODataJPARuntimeException {
        JsonObject query = null;
        try {
            EdmEntityType entityType = uriView.getTargetEntitySet().getEntityType();
            try {
                query = QueryManager.getQuery(uriView.getTargetEntitySet().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null) {
                QueryManager.checkSecurity(query, RestClient.getRestClient().getMethod());
            } else if (entityType.getMapping() != null && ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType() != null) {
                Class clazz = ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType();
                QueryManager.checkSecurity(clazz, RestClient.getRestClient().getMethod());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void checkAuthorization(PostUriInfo postView) throws ODataJPARuntimeException {
        this.checkOprAuthorization((UriInfo)postView);
    }

    public void checkAuthorization(PutMergePatchUriInfo putView) throws ODataJPARuntimeException {
        this.checkOprAuthorization((UriInfo)putView);
    }

    public void checkAuthorization(DeleteUriInfo deleteView) throws ODataJPARuntimeException {
        this.checkOprAuthorization((UriInfo)deleteView);
    }

    public void checkEntityGetAuthorization(EdmEntityType entityType) throws ODataJPARuntimeException {
        try {
            if (entityType.getMapping() != null && ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType() != null) {
                Class clazz = ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType();
                QueryManager.checkSecurity(clazz, RestClient.getRestClient().getMethod());
            }
        }
        catch (Exception e) {
            throw ErrorResponse.createException(e, RestClient.getRestClient().getMethod());
        }
    }

    private Map<String, Object> convertValues(Map<String, Object> defaults, EdmEntityType entityType) throws Exception {
        if (defaults != null) {
            for (String key : defaults.keySet()) {
                Class clazz = ((JPAEdmMappingImpl)((EdmSimplePropertyImplProv)entityType.getProperty(key)).getMapping()).getOriginaType();
                Object value = defaults.get(key);
                value = Var.valueOf(value).getObject(clazz);
                defaults.put(key, value);
            }
        }
        return defaults;
    }

    public Map<String, Object> getDefaultFieldValues(EdmEntityType entityType, Object data) throws ODataJPARuntimeException {
        JsonObject query = null;
        try {
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null && RestClient.getRestClient() != null && RestClient.getRestClient().getRequest() != null) {
                return this.convertValues(QueryManager.getDefaultValues(query, data), entityType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Map<String, Object> getCalcFieldValues(EdmEntityType entityType, Object data) throws ODataJPARuntimeException {
        JsonObject query = null;
        try {
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null && RestClient.getRestClient() != null && RestClient.getRestClient().getRequest() != null) {
                return this.convertValues(QueryManager.getCalcFieldValues(query, data), entityType);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void checkFilter(EdmEntityType entityType, FilterExpression filter) throws ODataJPARuntimeException {
        try {
            JsonObject query = null;
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinkedList<String> filters = new LinkedList<String>();
            this.visitExpression((CommonExpression)filter, filters);
            if (query != null) {
                QueryManager.checkFilterSecurity(query, filters);
            } else {
                Class clazz = ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType();
                QueryManager.checkEntityFilterSecurity(clazz, filters);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doCheckFilter(BinaryExpression expression, List<String> filters) {
        this.visitExpression(expression.getLeftOperand(), filters);
        this.visitExpression(expression.getRightOperand(), filters);
    }

    private void doCheckFilter(FilterExpression expression, List<String> filters) {
        this.visitExpression(expression.getExpression(), filters);
    }

    private void doCheckFilter(PropertyExpression expression, List<String> filters) {
        filters.add(expression.getPropertyName());
    }

    private void doCheckFilter(MethodExpression expression, List<String> filters) {
        for (CommonExpression e : expression.getParameters()) {
            this.visitExpression(e, filters);
        }
    }

    private void visitExpression(CommonExpression expression, List<String> filters) {
        if (expression instanceof BinaryExpression) {
            this.doCheckFilter((BinaryExpression)expression, filters);
        } else if (expression instanceof PropertyExpression) {
            this.doCheckFilter((PropertyExpression)expression, filters);
        } else if (expression instanceof FilterExpression) {
            this.doCheckFilter((FilterExpression)expression, filters);
        } else if (expression instanceof MethodExpression) {
            this.doCheckFilter((MethodExpression)expression, filters);
        }
    }

    public List<ClientCallback> getClientCallbacks() {
        LinkedList<ClientCallback> callbacks = null;
        for (ClientCommand command : RestClient.getRestClient().getCommands()) {
            if (callbacks == null) {
                callbacks = new LinkedList<ClientCallback>();
            }
            callbacks.add(command.toClientCallback());
        }
        return callbacks;
    }

    private void beforeAnyOperation(String type, final Object object) {
        try {
            DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
            if (logManager != null) {
                GsonBuilder builder = new GsonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

                    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                        return fieldAttributes.getDeclaringClass() != object.getClass() && fieldAttributes.getAnnotation(Id.class) == null;
                    }

                    public boolean shouldSkipClass(Class<?> aClass) {
                        return false;
                    }
                });
                builder.registerTypeAdapter(Date.class, (Object)HistoryListener.UTC_DATE_ADAPTER);
                Gson gson = builder.create();
                JsonElement objectJson = gson.toJsonTree(object);
                Var auditLog = new Var(new LinkedHashMap());
                auditLog.set("type", object.getClass().getName());
                auditLog.set("command", type);
                auditLog.set("category", "DataSource");
                auditLog.set("date", new Date());
                auditLog.set("objectData", objectJson.toString());
                if (RestClient.getRestClient() != null) {
                    auditLog.set("user", RestClient.getRestClient().getUser() != null ? RestClient.getRestClient().getUser().getUsername() : null);
                    auditLog.set("host", RestClient.getRestClient().getHost());
                    auditLog.set("agent", RestClient.getRestClient().getAgent());
                }
                auditLog.set("server", HistoryListener.CURRENT_IP);
                auditLog.set("application", AppConfig.guid());
                logManager.insert(auditLog, new Object[0]);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<EdmProperty> findOriginalKeys(EdmEntityType entityType) {
        LinkedList<EdmProperty> keys = new LinkedList<EdmProperty>();
        try {
            for (EdmProperty item : entityType.getKeyProperties()) {
                EdmSimplePropertyImplProv key = (EdmSimplePropertyImplProv)item;
                if (key.getComposite() != null) {
                    keys.addAll(key.getComposite());
                    continue;
                }
                keys.add(item);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return keys;
    }

    public Object execEvent(UriInfo infoView, EdmEntityType entityType, String type, Object data) {
        if (infoView != null) {
            try {
                JsonObject query = null;
                if (data != null) {
                    Utils.processCloudFields(data);
                }
                try {
                    query = QueryManager.getQuery(entityType.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (query != null) {
                    if (type.startsWith("before")) {
                        if (!QueryManager.isNull(query.get("audit")) && query.get("audit").getAsJsonPrimitive().getAsBoolean()) {
                            this.beforeAnyOperation(type.replace("before", "").toUpperCase(), data);
                        }
                        RestClient.getRestClient().setEntity(data);
                    }
                    LinkedList<Object> keys = new LinkedList<Object>();
                    if (data != null) {
                        try {
                            for (EdmProperty key : this.findOriginalKeys(entityType)) {
                                keys.add(ReflectionUtil.getter((Object)data, (String)key.getName()));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    RestClient.getRestClient().setKeys(keys);
                    Var result = QueryManager.executeEvent(query, data, type, keys, entityType.getName());
                    if (result != null) {
                        return result.getObject();
                    }
                }
                ((UriInfoImpl)infoView).setClientCallbacks(this.getClientCallbacks());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Object processNew(UriInfo infoView) {
        try {
            EdmEntitySet oDataEntitySet = infoView.getTargetEntitySet();
            EdmEntityType entityType = oDataEntitySet.getEntityType();
            JsonObject query = null;
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null) {
                Object jpaEntity = ((JPAEdmMappingImpl)entityType.getMapping()).getJPAType().newInstance();
                String jpqlStatement = QueryManager.getJPQL(query, false);
                JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)jpqlStatement, DefaultEclipseLinkJPQLGrammar.instance(), true);
                String mainAlias = JPQLParserUtil.getMainAlias(jpqlExpression);
                VirtualClass virtualClass = new VirtualClass();
                for (String name : entityType.getPropertyNames()) {
                    Field field;
                    String expression;
                    String[] parts;
                    EdmSimplePropertyImplProv type = (EdmSimplePropertyImplProv)entityType.getProperty(name);
                    if (type.getMapping() == null || type.getMapping().getInternalExpression() == null || (parts = (expression = type.getMapping().getInternalExpression()).split("\\.")).length != 2) continue;
                    String f = parts[1];
                    if (!parts[0].equals(mainAlias) || (field = ReflectionUtil.getField(jpaEntity, (String)f)) == null) continue;
                    field.setAccessible(true);
                    Object o = field.get(jpaEntity);
                    virtualClass.set(name, o);
                }
                return virtualClass;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Object overridePost(UriInfo infoView, Object entity) {
        JsonObject query = null;
        try {
            EdmEntitySet oDataEntitySet = infoView.getTargetEntitySet();
            EdmEntityType entityType = oDataEntitySet.getEntityType();
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query == null) {
                return null;
            }
            if (!QueryManager.isNull(query.get("endpoint"))) {
                WebServicesQuery restQuery = new WebServicesQuery(query, RestClient.getRestClient().getMethod(), RestClient.getRestClient().getMethod(), "", infoView);
                return restQuery.save(entity);
            }
            String blocklyMethod = this.getBlocklyMethod(infoView, query);
            if (blocklyMethod == null) {
                return null;
            }
            if (query != null && QueryManager.isNull(query.get("entityFullName"))) {
                Var result = QueryManager.executeBlockly(query, this.getRestMehtod(infoView), Var.valueOf(entity));
                if (result != null && !result.isNull().booleanValue()) {
                    if (!QueryManager.isNull(query.get("baseEntity"))) {
                        return result.getObject();
                    }
                    return result;
                }
                return entity;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public boolean canOverridePut(UriInfo infoView) {
        try {
            EdmEntitySet oDataEntitySet = infoView.getTargetEntitySet();
            EdmEntityType entityType = oDataEntitySet.getEntityType();
            JsonObject query = QueryManager.getQuery(entityType.getName());
            if (!QueryManager.isNull(query.get("endpoint"))) {
                return true;
            }
            String blocklyMethod = this.getBlocklyMethod(infoView, query);
            if (blocklyMethod == null) {
                return false;
            }
            return query != null && QueryManager.isNull(query.get("entityFullName"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canOverrideDelete(UriInfo infoView) {
        return this.canOverridePut(infoView);
    }

    public boolean canOverridePost(UriInfo infoView) {
        return this.canOverridePut(infoView);
    }

    public Object overridePut(UriInfo infoView, Object entity) {
        return this.overridePost(infoView, entity);
    }

    public boolean overrideDelete(UriInfo infoView, Object entity) {
        JsonObject query = null;
        try {
            EdmEntitySet oDataEntitySet = infoView.getTargetEntitySet();
            EdmEntityType entityType = oDataEntitySet.getEntityType();
            try {
                query = QueryManager.getQuery(entityType.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query == null) {
                return false;
            }
            if (!QueryManager.isNull(query.get("endpoint"))) {
                WebServicesQuery restQuery = new WebServicesQuery(query, RestClient.getRestClient().getMethod(), RestClient.getRestClient().getMethod(), "", infoView);
                return restQuery.delete(entity);
            }
            String blocklyMethod = this.getBlocklyMethod(infoView, query);
            if (blocklyMethod == null) {
                return false;
            }
            if (query != null && QueryManager.isNull(query.get("entityFullName"))) {
                QueryManager.executeBlockly(query, this.getRestMehtod(infoView), Var.valueOf(entity));
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public Object convert(Object obj, Class clazz) {
        return Var.valueOf(obj).getObject(clazz);
    }

    public void prepareQuery(Query query) {
        JPAUtil.prepareQuery(query);
    }
}

