/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest;

import com.google.gson.JsonObject;
import cronapi.ErrorResponse;
import cronapi.QueryManager;
import cronapi.RestBody;
import cronapi.RestClient;
import cronapi.RestResult;
import cronapi.Utils;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.database.DataSourceFilter;
import cronapi.database.EntityMetadata;
import cronapi.database.TenantService;
import cronapi.database.TransactionManager;
import cronapi.util.Operations;
import cronapi.util.SecurityUtil;
import cronapi.util.StorageService;
import cronapi.util.StorageServiceFileObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/cronapi"})
public class CronapiREST {
    private static Pattern RELATION_PARAM = Pattern.compile("relation:(.*?):(.*?)$");
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private TenantService tenantService;
    private int paramBlockly;

    private TranslationPath translatePathVars(String clazz) {
        return this.translatePathVars(clazz, 0, -1);
    }

    private TranslationPath translatePathVars(String clazz, int offSet, int max) {
        String paths = this.request.getServletPath().substring(this.request.getServletPath().indexOf(clazz) + clazz.length()).trim();
        if (paths.startsWith("/")) {
            paths = paths.substring(1);
        }
        if (paths.endsWith("/")) {
            paths = paths.substring(0, paths.length() - 1);
        }
        String[] strParams = paths.split("/");
        strParams = Arrays.copyOfRange(strParams, offSet, max != -1 ? max : strParams.length);
        LinkedList<Var> params = new LinkedList<Var>();
        LinkedList<Var> relationParams = new LinkedList<Var>();
        TranslationPath translationPath = new TranslationPath();
        boolean isParam = true;
        boolean isRelationParam = false;
        if (!paths.isEmpty()) {
            for (int i = 0; i < strParams.length; ++i) {
                Matcher matcher;
                if (strParams[i] != null && (matcher = RELATION_PARAM.matcher(strParams[i])).matches()) {
                    translationPath.relationClass = matcher.group(2);
                    translationPath.field = matcher.group(1);
                    translationPath.refId = strParams[i];
                    isParam = false;
                    isRelationParam = true;
                    continue;
                }
                if (isParam) {
                    params.add(Var.valueOf(strParams[i]));
                }
                if (!isRelationParam) continue;
                relationParams.add(Var.valueOf(strParams[i]));
            }
        }
        translationPath.params = params.toArray(new Var[params.size()]);
        translationPath.relationParams = relationParams.toArray(new Var[relationParams.size()]);
        boolean caseInsensitive = false;
        if (this.request.getParameter("filterCaseInsensitive") != null && !this.request.getParameter("filterCaseInsensitive").isEmpty()) {
            caseInsensitive = "true".equalsIgnoreCase(this.request.getParameter("filterCaseInsensitive"));
        }
        translationPath.filter = DataSourceFilter.getInstance(this.request.getParameter("filter"), this.request.getParameter("order"), this.request.getParameter("filterType"), caseInsensitive);
        return translationPath;
    }

    private Var[] toVarArray(LinkedList list) {
        Var[] vars = new Var[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            vars[i] = Var.valueOf(list.get(i));
        }
        return vars;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
        ex.printStackTrace();
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/metadata/{entity}/**"})
    public HttpEntity<EntityMetadata> dataOptions(@PathVariable(value="entity") String entity) throws Exception {
        DataSource ds = new DataSource(entity);
        EntityMetadata data = ds.getMetadata();
        return new ResponseEntity((Object)data, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/crud/{entity}/**"})
    public HttpEntity<Object> crudGet(@PathVariable(value="entity") String entity, Pageable pageable) throws Exception {
        RestResult data = this.runIntoTransaction(() -> {
            TranslationPath translationPath = this.translatePathVars(entity);
            PageRequest page = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize());
            DataSource ds = new DataSource(entity);
            if (translationPath.relationClass == null) {
                ds.checkRESTSecurity("GET");
                if (translationPath.params.length > 0 && translationPath.params[0].equals("__new__")) {
                    ds.insert();
                    return Var.valueOf(ds.getObject());
                }
                ds.setDataSourceFilter(translationPath.filter);
                ds.filter(null, page, translationPath.params);
            } else {
                ds.checkRESTSecurity(translationPath.refId, "GET");
                if (translationPath.relationParams.length > 0 && translationPath.relationParams[0].equals("__new__")) {
                    ds.resolveRelation(translationPath.refId);
                    ds.insert();
                    return Var.valueOf(ds.getObject());
                }
                ds.setDataSourceFilter(translationPath.filter);
                ds.filterByRelation(translationPath.refId, page, translationPath.params);
            }
            return Var.valueOf(ds.getPage().getContent());
        });
        return new ResponseEntity(data.getValue().getObject(), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/crud/{entity}/**"})
    public HttpEntity<Object> crudPut(@PathVariable(value="entity") String entity, @RequestBody Var data) throws Exception {
        RestResult result = this.runIntoTransaction(() -> {
            DataSource ds = new DataSource(entity);
            TranslationPath translationPath = this.translatePathVars(entity);
            if (translationPath.relationClass == null) {
                ds.checkRESTSecurity("PUT");
                ds.filter(data, null);
                ds.update(data);
                return Var.valueOf(ds.save());
            }
            ds.checkRESTSecurity(translationPath.refId, "PUT");
            String entityRelation = ds.getRelationEntity(translationPath.refId);
            ds = new DataSource(entityRelation);
            ds.filter(data, null);
            ds.update(data);
            return Var.valueOf(ds.save());
        });
        return new ResponseEntity(result.getValue().getObject(), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/crud/{entity}/**"})
    public HttpEntity<Object> crudPost(@PathVariable(value="entity") String entity, @RequestBody Var data) throws Exception {
        RestResult result = this.runIntoTransaction(() -> {
            DataSource ds = new DataSource(entity);
            TranslationPath translationPath = this.translatePathVars(entity);
            Object inserted = null;
            if (translationPath.relationClass == null) {
                ds.checkRESTSecurity("POST");
                ds.insert((Map)data.getObject());
                inserted = ds.save();
            } else {
                ds.checkRESTSecurity(translationPath.refId, "POST");
                inserted = ds.insertRelation(translationPath.refId, (Map)data.getObject(), translationPath.params);
            }
            return Var.valueOf(inserted);
        });
        return new ResponseEntity(result.getValue().getObject(), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/crud/{entity}/**"})
    public void crudDelete(@PathVariable(value="entity") String entity) throws Exception {
        this.runIntoTransaction(() -> {
            TranslationPath translationPath = this.translatePathVars(entity);
            DataSource ds = new DataSource(entity);
            if (translationPath.relationClass == null) {
                ds.checkRESTSecurity("DELETE");
                ds.delete(translationPath.params);
            } else {
                ds.checkRESTSecurity(translationPath.refId, "DELETE");
                ds.deleteRelation(translationPath.refId, translationPath.params, translationPath.relationParams);
            }
            return null;
        });
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/query/{id}/__new__"})
    public HttpEntity<Var> queryGetNew(@PathVariable(value="id") String id) throws Exception {
        RestResult data = this.runIntoTransaction(() -> {
            JsonObject query = QueryManager.getQuery(id);
            QueryManager.checkSecurity(query, "GET");
            if (!QueryManager.getType(query).equals("blockly")) {
                DataSource ds = new DataSource(query);
                ds.insert();
                QueryManager.addDefaultValues(query, Var.valueOf(ds), false);
                QueryManager.executeNavigateEvent(query, ds);
                QueryManager.checkFieldSecurity(query, ds, "GET");
                return Var.valueOf(ds.getObject());
            }
            Var empty = Var.newMap();
            QueryManager.addDefaultValues(query, empty, false);
            return empty;
        });
        return new ResponseEntity((Object)data.getValue(), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/query/{id}/**"})
    public HttpEntity<?> queryGet(@PathVariable(value="id") String id, Pageable pageable) throws Exception {
        RestResult data = this.runIntoTransaction(() -> {
            PageRequest page = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize());
            JsonObject query = QueryManager.getQuery(id);
            QueryManager.checkSecurity(query, "GET");
            if (QueryManager.getType(query).equals("blockly")) {
                TranslationPath translationPath = this.translatePathVars(id);
                if (translationPath.filter != null && translationPath.filter.getItems().size() > 0) {
                    Object[] filterParams = this.toVarArray(translationPath.filter.getItems());
                    Var[] params = (Var[])ArrayUtils.addAll((Object[])translationPath.params, (Object[])filterParams);
                    return QueryManager.executeBlockly(query, "FILTER", params).getObjectAsPOJOList();
                }
                return QueryManager.executeBlockly(query, "GET", translationPath.params).getObjectAsPOJOList();
            }
            TranslationPath translationPath = this.translatePathVars(id, 0, -1);
            QueryManager.checkFilterSecurity(query, translationPath.filter);
            DataSource ds = new DataSource(query);
            String jpql = QueryManager.getJPQL(query, true);
            List<Var> params = Utils.getParamsAndExecuteBlockParams(query, translationPath);
            ds.setDataSourceFilter(translationPath.filter);
            ds.filter(jpql, page, params.toArray(new Var[0]));
            QueryManager.addCalcFields(query, ds);
            QueryManager.executeNavigateEvent(query, ds);
            QueryManager.checkFieldSecurity(query, ds, "GET");
            return Var.valueOf(ds.getPage());
        });
        if (data.getValue().getObject() instanceof Page) {
            Page page = (Page)data.getValue().getObject();
            return new ResponseEntity((Object)page.getContent(), HttpStatus.OK);
        }
        return new ResponseEntity((Object)data.getValue(), HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/query/{id}/**"})
    public Object queryPost(@PathVariable(value="id") String id, @RequestBody Map<?, ?> rawData, @RequestHeader(value="X-From-DataSource", defaultValue="false") boolean isFromDataSource) throws Exception {
        RestResult result = this.runIntoTransaction(() -> {
            JsonObject query = QueryManager.getQuery(id);
            QueryManager.checkSecurity(query, "POST");
            RestBody data = RestBody.parseBody(rawData, isFromDataSource);
            QueryManager.checkFieldSecurity(query, data, "POST");
            Var entity = Var.valueOf(data.getEntityData());
            RestClient.getRestClient().setRawBody(entity);
            RestClient.getRestClient().setBody(data);
            if (QueryManager.getType(query).equals("blockly")) {
                TranslationPath translationPath = this.translatePathVars(id);
                Var[] params = (Var[])ArrayUtils.addAll((Object[])new Var[]{entity}, (Object[])translationPath.params);
                QueryManager.executeEvent(query, entity, "beforeInsert");
                Var inserted = QueryManager.executeBlockly(query, "POST", params);
                QueryManager.executeEvent(query, entity, "afterInsert");
                return inserted.getPOJO();
            }
            DataSource ds = new DataSource(query);
            ds.insert(entity.getObject());
            QueryManager.addDefaultValues(query, Var.valueOf(ds), true);
            QueryManager.executeEvent(query, ds.getObject(), "beforeInsert");
            Object inserted = ds.save(false);
            QueryManager.executeEvent(query, ds.getObject(), "afterInsert");
            QueryManager.checkFieldSecurity(query, ds, "GET");
            QueryManager.addCalcFields(query, ds);
            return Var.valueOf(inserted);
        });
        if (isFromDataSource) {
            return result;
        }
        return result.getValue();
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/query/{id}/**"})
    public Object queryPut(@PathVariable(value="id") String id, @RequestBody Map<?, ?> rawData, @RequestHeader(value="X-From-DataSource", defaultValue="false") boolean isFromDataSource) throws Exception {
        RestResult result = this.runIntoTransaction(() -> {
            JsonObject query = QueryManager.getQuery(id);
            QueryManager.checkSecurity(query, "PUT");
            RestBody data = RestBody.parseBody(rawData, isFromDataSource);
            QueryManager.checkFieldSecurity(query, data, "PUT");
            Var entity = Var.valueOf(data.getEntityData());
            RestClient.getRestClient().setRawBody(entity);
            RestClient.getRestClient().setBody(data);
            if (QueryManager.getType(query).equals("blockly")) {
                TranslationPath translationPath = this.translatePathVars(id);
                Var[] params = (Var[])ArrayUtils.addAll((Object[])new Var[]{entity}, (Object[])translationPath.params);
                QueryManager.executeEvent(query, entity, "beforeUpdate");
                Var modified = QueryManager.executeBlockly(query, "PUT", params);
                QueryManager.executeEvent(query, entity, "beforeUpdate");
                return modified.getPOJO();
            }
            DataSource ds = new DataSource(query);
            ds.filter(entity, null);
            QueryManager.executeEvent(query, ds.getObject(), "beforeUpdate");
            ds.update(entity);
            Var saved = Var.valueOf(ds.save());
            QueryManager.executeEvent(query, ds.getObject(), "afterUpdate");
            QueryManager.checkFieldSecurity(query, ds, "GET");
            QueryManager.addCalcFields(query, ds);
            return saved;
        });
        if (isFromDataSource) {
            return result;
        }
        return result.getValue();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/query/{id}/**"})
    public Object queryDelete(@PathVariable(value="id") String id, @RequestHeader(value="X-From-DataSource", defaultValue="false") boolean isFromDataSource) throws Exception {
        RestResult result = this.runIntoTransaction(() -> {
            JsonObject query = QueryManager.getQuery(id);
            QueryManager.checkSecurity(query, "DELETE");
            if (QueryManager.getType(query).equals("blockly")) {
                TranslationPath translationPath = this.translatePathVars(id);
                QueryManager.executeEvent(query, "beforeDelete", translationPath.params);
                QueryManager.executeBlockly(query, "DELETE", translationPath.params);
                QueryManager.executeEvent(query, "afterDelete", translationPath.params);
            } else {
                TranslationPath translationPath = this.translatePathVars(id, query.getAsJsonArray("queryParamsValues").size(), -1);
                DataSource ds = new DataSource(query);
                ds.filter(null, PageRequest.of((int)1, (int)1), translationPath.params);
                QueryManager.executeEvent(query, ds.getObject(), "beforeDelete");
                ds.delete();
                QueryManager.executeEvent(query, ds.getObject(), "afterDelete");
            }
            return Var.VAR_NULL;
        });
        if (isFromDataSource) {
            return result;
        }
        return result.getValue();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/call/body/{class}/**"})
    public RestResult postBody(@RequestBody RestBody body, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransaction(() -> {
            RestClient.getRestClient().setBody(body);
            return Operations.callBlockly(new Var(clazz), true, "execute", body.getInputs());
        });
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/call/{class}/**"})
    public RestResult getParam(@PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransaction(() -> {
            TranslationPath translationPath = this.translatePathVars(clazz);
            return Operations.callBlockly(new Var(clazz), true, "execute", translationPath.params);
        });
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/call/{class}/**"})
    public RestResult postParams(@RequestBody Var[] vars, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransaction(() -> Operations.callBlockly(new Var(clazz), true, "execute", vars));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/rest/{class}/**"})
    public Var getRest(@PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> {
            TranslationPath translationPath = this.translatePathVars(clazz);
            return Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), translationPath.params);
        });
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rest/raw/{class}/**"})
    public Var postRestRaw(@RequestBody(required=false) String body, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), Var.valueOf(body)));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rest/{class}/**"}, consumes={"text/plain"})
    public Var postRestBinary(@RequestBody(required=false) String body, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), Var.valueOf(body)));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rest/{class}/**"}, consumes={"application/x-www-form-urlencoded"})
    public Var postRestForm(@RequestParam Map<String, String> body, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), Var.valueOf(body)));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rest/{class}/**"}, consumes={"multipart/form-data"})
    public Var postRestFile(@PathVariable(value="class") String clazz, HttpServletRequest request) throws Exception {
        ArrayList<Var> varsToParse = new ArrayList<Var>();
        request.getParts().forEach(part -> {
            if (part.getSubmittedFileName() != null) {
                try {
                    InputStream fileContent = part.getInputStream();
                    Var param = new Var(IOUtils.toByteArray((InputStream)fileContent));
                    param.setId(part.getName());
                    varsToParse.add(param);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
        });
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            Var param = new Var(request.getParameter(paramName));
            param.setId(paramName);
            varsToParse.add(param);
        }
        Var[] vars = new Var[varsToParse.size()];
        for (int i = 0; i < varsToParse.size(); ++i) {
            vars[i] = (Var)varsToParse.get(i);
        }
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), vars));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rest/{class}/**"}, consumes={"application/json", "application/atom+xml"})
    public Var postRest(@RequestBody(required=false) Var var, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), var));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/rest/{class}/**"})
    public Var putRest(@RequestBody(required=false) Var[] vars, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), vars));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/rest/{class}/**"})
    public Var deleteRest(@PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> {
            TranslationPath translationPath = this.translatePathVars(clazz);
            return Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), translationPath.params);
        });
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/legacyrest/{class}/**"})
    public Var postRestLegacy(@RequestBody(required=false) Var[] vars, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), vars));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/legacyrest/{class}/**"})
    public Var getRestLegacy(@PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> {
            TranslationPath translationPath = this.translatePathVars(clazz);
            return Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), translationPath.params);
        });
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/legacyrest/{class}/**"})
    public Var putRestLegacy(@RequestBody(required=false) Var[] vars, @PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), vars));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/legacyrest/{class}/**"})
    public Var deleteRestLegacy(@PathVariable(value="class") String clazz) throws Exception {
        return this.runIntoTransactionVar(() -> {
            TranslationPath translationPath = this.translatePathVars(clazz);
            return Operations.callBlockly(new Var(clazz), true, RestClient.getRestClient().getMethod(), translationPath.params);
        });
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/security/roles"})
    public List<SecurityUtil.SecurityGroup> securityRoles() throws Exception {
        return SecurityUtil.getRoles();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/filePreview/{fileName}/**"})
    public void filePreview(@PathVariable(value="fileName") String fileName) throws Exception {
        StorageServiceFileObject fileObject = StorageService.getFileObjectFromTempDirectory(fileName);
        this.response.setContentType(fileObject.contentType);
        this.response.setHeader("Content-disposition", "attachment; filename=" + fileObject.name + fileObject.extension);
        ServletOutputStream responseOutputStream = this.response.getOutputStream();
        responseOutputStream.write(fileObject.bytes);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/downloadFile/{entity}/{field}/**"})
    public void downloadFile(@PathVariable(value="entity") String entity, @PathVariable(value="field") String field, @RequestBody Var data) throws Exception {
        DataSource ds = new DataSource(entity);
        ds.checkRESTSecurity("GET");
        ds.filter(data, null);
        Object obj = ds.getObject();
        byte[] bytes = (byte[])Utils.getFieldValue(obj, field);
        StorageServiceFileObject fileObject = StorageService.getFileObjectFromBytes(bytes);
        this.response.setContentType(fileObject.contentType);
        this.response.addHeader("x-filename", fileObject.name + fileObject.extension);
        ServletOutputStream responseOutputStream = this.response.getOutputStream();
        responseOutputStream.write(fileObject.bytes);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/downloadFile/{entity}/{field}/{ids}/**"})
    public void downloadFileGet(@PathVariable(value="entity") String entity, @PathVariable(value="field") String field, @PathVariable(value="ids") String ids) throws Exception {
        String[] idsSplited;
        DataSource ds = new DataSource(entity);
        LinkedList<Var> varIds = new LinkedList<Var>();
        for (String id : idsSplited = ids.split(Pattern.quote(":"))) {
            varIds.add(Var.valueOf(id));
        }
        Object domainInstance = ds.getObjectWithId(varIds.toArray(new Var[0]));
        ds.filter(Var.valueOf(domainInstance), null);
        Object obj = ds.getObject();
        byte[] bytes = (byte[])Utils.getFieldValue(obj, field);
        StorageServiceFileObject fileObject = StorageService.getFileObjectFromBytes(bytes);
        this.response.setContentType(fileObject.contentType);
        this.response.addHeader("x-filename", fileObject.name + fileObject.extension);
        this.response.setHeader("Content-Disposition", "attachment;filename=" + fileObject.name + fileObject.extension);
        ServletOutputStream responseOutputStream = this.response.getOutputStream();
        responseOutputStream.write(fileObject.bytes);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/uploadFile"})
    public ResponseEntity<Object> uploadFile(@RequestParam(value="file") MultipartFile[] uploadfiles) throws Exception {
        return new ResponseEntity((Object)StorageService.saveUploadFiles(uploadfiles), HttpStatus.OK);
    }

    private RestResult runIntoTransaction(Callable<Var> callable) throws Exception {
        RestClient.getRestClient().setFilteredEnabled(true);
        RestClient.getRestClient().setTenantService(this.tenantService);
        Var var = Var.VAR_NULL;
        try {
            var = callable.call();
            TransactionManager.commit();
        }
        catch (Exception e) {
            TransactionManager.rollback();
            throw e;
        }
        finally {
            TransactionManager.close();
            TransactionManager.clear();
        }
        return new RestResult(var, RestClient.getRestClient().getCommands());
    }

    private Var runIntoTransactionVar(Callable<Var> callable) throws Exception {
        RestClient.getRestClient().setFilteredEnabled(true);
        RestClient.getRestClient().setTenantService(this.tenantService);
        Var var = Var.VAR_NULL;
        try {
            var = callable.call();
            TransactionManager.commit();
        }
        catch (Exception e) {
            TransactionManager.rollback();
            throw e;
        }
        finally {
            TransactionManager.close();
            TransactionManager.clear();
        }
        return var;
    }

    public class TranslationPath {
        public Var[] params;
        public String relationClass;
        public String relationAssossiative;
        public String field;
        public String refId;
        public Var[] relationParams;
        public DataSourceFilter filter;
    }
}

