/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import com.google.gson.JsonObject;
import cronapi.ErrorResponse;
import cronapi.QueryManager;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.database.TransactionManager;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.springframework.data.domain.PageRequest;
import org.springframework.http.HttpStatus;

public class DatabaseQueryManager {
    private boolean isolatedTransaction = true;
    private String id;
    private JsonObject query;
    private boolean isDatabase = true;
    private String entity;

    public DatabaseQueryManager(String id) {
        this.id = id;
        this.query = QueryManager.getQuery(id);
        this.isDatabase = this.query.get("sourceType").getAsString().equals("entityFullName");
        if (this.isDatabase) {
            this.entity = this.query.get("entityFullName").getAsString();
        }
    }

    public DatabaseQueryManager(String id, boolean isolatedTransaction) {
        this(id);
        this.isolatedTransaction = isolatedTransaction;
    }

    public DatabaseQueryManager() {
    }

    public static DatabaseQueryManager getInsanceBasedOnEntity(String entityFullName) {
        DatabaseQueryManager databaseQueryManager = new DatabaseQueryManager();
        databaseQueryManager.fromEntity(entityFullName);
        return databaseQueryManager;
    }

    public void addFilter(String field, String type, String operator, String value) {
        QueryManager.addFilter(this.query, field, type, operator, value);
    }

    protected void fromEntity(String entityFullName) {
        this.query = QueryManager.createNewQuery(entityFullName);
        this.id = this.query.get("customId").getAsString();
        this.isDatabase = true;
        this.entity = entityFullName;
    }

    public boolean isDatabase() {
        return this.isDatabase;
    }

    public String getEntity() {
        return this.entity;
    }

    public Var get(Object ... params) throws Exception {
        return this.get(null, params);
    }

    private Var[] toVarArray(Object[] list) {
        Var[] vars = new Var[list.length];
        for (int i = 0; i < list.length; ++i) {
            vars[i] = Var.valueOf(list[i]);
        }
        return vars;
    }

    public Var get(PageRequest paramPage, Object ... objParams) throws Exception {
        PageRequest page = paramPage == null ? PageRequest.of((int)0, (int)100) : paramPage;
        Var[] params = this.toVarArray(objParams);
        return this.runIntoTransaction(() -> {
            if (QueryManager.getType(this.query).equals("blockly")) {
                return QueryManager.executeBlockly(this.query, "GET", params);
            }
            DataSource ds = new DataSource(this.query);
            String jpql = QueryManager.getJPQL(this.query, false);
            ds.filter(jpql, page, params);
            QueryManager.executeNavigateEvent(this.query, ds);
            return Var.valueOf(ds.getPage().getContent());
        });
    }

    public Var insert(Object objData, Object ... extraObjParams) throws Exception {
        return this.runIntoTransaction(() -> this.insertNoTransaction(objData, extraObjParams));
    }

    public Var insertNoTransaction(Object objData, Object ... extraObjParams) {
        Object[] extraParams = this.toVarArray(extraObjParams);
        Var data = Var.valueOf(objData);
        if (QueryManager.getType(this.query).equals("blockly")) {
            Var[] params = (Var[])ArrayUtils.addAll((Object[])new Var[]{data}, (Object[])extraParams);
            QueryManager.executeEvent(this.query, data, "beforeInsert");
            Var inserted = QueryManager.executeBlockly(this.query, "POST", params);
            QueryManager.executeEvent(this.query, data, "afterInsert");
            return inserted;
        }
        DataSource ds = new DataSource(this.query);
        ds.insert(data.getObject());
        QueryManager.addDefaultValues(this.query, Var.valueOf(ds), true);
        QueryManager.executeEvent(this.query, ds, "beforeInsert");
        Object inserted = ds.save(false);
        QueryManager.executeEvent(this.query, ds, "afterInsert");
        return Var.valueOf(inserted);
    }

    public Var insertAfterCommit(AbstractSession session, Object objData, Object ... extraObjParams) {
        Object[] extraParams = this.toVarArray(extraObjParams);
        Var data = Var.valueOf(objData);
        if (QueryManager.getType(this.query).equals("blockly")) {
            Var[] params = (Var[])ArrayUtils.addAll((Object[])new Var[]{data}, (Object[])extraParams);
            QueryManager.executeEvent(this.query, data, "beforeInsert");
            Var inserted = QueryManager.executeBlockly(this.query, "POST", params);
            QueryManager.executeEvent(this.query, data, "afterInsert");
            return inserted;
        }
        DataSource ds = new DataSource(this.query);
        ds.insert(data.getObject());
        QueryManager.addDefaultValues(this.query, Var.valueOf(ds), true);
        QueryManager.executeEvent(this.query, ds, "beforeInsert");
        Object inserted = ds.saveAfterCommit(session);
        QueryManager.executeEvent(this.query, ds, "afterInsert");
        return Var.valueOf(inserted);
    }

    public Var update(Var objData, Object ... extraObjParams) throws Exception {
        Var[] extraParams = this.toVarArray(extraObjParams);
        Var data = Var.valueOf(objData);
        return this.runIntoTransaction(() -> {
            if (QueryManager.getType(this.query).equals("blockly")) {
                Var[] params = (Var[])ArrayUtils.addAll((Object[])new Var[]{data}, (Object[])extraParams);
                QueryManager.executeEvent(this.query, data, "beforeUpdate");
                Var modified = QueryManager.executeBlockly(this.query, "PUT", params);
                QueryManager.executeEvent(this.query, data, "beforeUpdate");
                return modified;
            }
            DataSource ds = new DataSource(this.query);
            ds.filter(data, null);
            QueryManager.executeEvent(this.query, ds, "beforeUpdate");
            ds.update(data);
            Var saved = Var.valueOf(ds.save());
            QueryManager.executeEvent(this.query, ds, "afterUpdate");
            return saved;
        });
    }

    public void delete(Object ... extraObjParams) throws Exception {
        Var[] extraParams = this.toVarArray(extraObjParams);
        this.runIntoTransaction(() -> {
            if (QueryManager.getType(this.query).equals("blockly")) {
                QueryManager.executeEvent(this.query, "beforeDelete", extraParams);
                QueryManager.executeBlockly(this.query, "DELETE", extraParams);
                QueryManager.executeEvent(this.query, "afterDelete", extraParams);
            } else {
                DataSource ds = new DataSource(this.query);
                ds.filter(null, PageRequest.of((int)1, (int)1), extraParams);
                QueryManager.executeEvent(this.query, ds, "beforeDelete");
                ds.delete();
                QueryManager.executeEvent(this.query, ds, "afterDelete");
            }
            return null;
        });
    }

    private Var runIntoTransaction(Callable<Var> callable) throws Exception {
        Var var = Var.VAR_NULL;
        try {
            var = callable.call();
            if (this.isolatedTransaction) {
                TransactionManager.commit();
            }
        }
        catch (Exception ex) {
            if (this.isolatedTransaction) {
                TransactionManager.rollback();
            }
            ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, "GET");
            throw new Exception(errorResponse.getError(), ex);
        }
        return var;
    }
}

