/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.QueryManager;
import cronapi.util.Operations;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import javax.persistence.FlushModeType;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;

public class AppConfig {
    public static final String UNDERLINE = "_";
    public static final String NONE = "Nenhuma";
    public static boolean FORCE_METADATA = false;
    public static boolean FORCE_LOCAL_ENTITIES = false;
    private static JsonObject JSON = AppConfig.loadJSON();

    private static void configureOData(JsonObject config) {
        if (!AppConfig.isNull(config.get("odata"))) {
            JsonElement elem = config.get("odata").getAsJsonObject().get("expandCompositeKeys");
            ODataJPAConfig.EXPAND_COMPOSITE_KEYS = !AppConfig.isNull(elem) ? elem.getAsBoolean() : false;
            elem = config.get("odata").getAsJsonObject().get("addDisplayFields");
            ODataJPAConfig.ADD_DISPLAY_FIELDS = !AppConfig.isNull(elem) ? elem.getAsBoolean() : true;
        }
    }

    private static JsonObject loadJSON() {
        JsonObject jsonObject;
        block8: {
            ClassLoader classLoader = QueryManager.class.getClassLoader();
            InputStream stream = classLoader.getResourceAsStream("META-INF/app.config");
            try {
                InputStreamReader reader = new InputStreamReader(stream);
                JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                AppConfig.configureOData(jsonElement.getAsJsonObject());
                jsonObject = jsonElement.getAsJsonObject();
                if (stream == null) break block8;
            }
            catch (Throwable reader) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            reader.addSuppressed(throwable);
                        }
                    }
                    throw reader;
                }
                catch (Exception e) {
                    JsonObject jsonElement = new JsonObject();
                    AppConfig.configureOData(jsonElement.getAsJsonObject());
                    return jsonElement.getAsJsonObject();
                }
            }
            stream.close();
        }
        return jsonObject;
    }

    public static JsonObject getJSON() {
        if (Operations.IS_DEBUG) {
            return AppConfig.loadJSON();
        }
        return JSON;
    }

    public static boolean isNull(JsonElement value) {
        return value == null || value.isJsonNull();
    }

    public static boolean exposeLocalEntities() {
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("odata"))) {
            JsonElement elem = config.get("odata").getAsJsonObject().get("exposeEntities");
            return !AppConfig.isNull(elem) && elem.getAsBoolean() || FORCE_LOCAL_ENTITIES;
        }
        return true;
    }

    public static boolean exposeMetadada() {
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("odata"))) {
            JsonElement elem = config.get("odata").getAsJsonObject().get("exposeMetadata");
            return !AppConfig.isNull(elem) && elem.getAsBoolean() || FORCE_METADATA;
        }
        return true;
    }

    public static String exposeMetadadaSecurity() {
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("odata"))) {
            JsonElement elem = config.get("odata").getAsJsonObject().get("exposeMetadadaSecurity");
            return !AppConfig.isNull(elem) ? elem.getAsString() : null;
        }
        return null;
    }

    public static String exposeEnitiesSecurity() {
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("odata"))) {
            JsonElement elem = config.get("odata").getAsJsonObject().get("exposeEnitiesSecurity");
            return !AppConfig.isNull(elem) ? elem.getAsString() : null;
        }
        return null;
    }

    public static String tokenRecaptcha() {
        JsonElement elem;
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("security")) && config.get("security").getAsJsonObject().has("tokenRecaptcha") && !AppConfig.isNull(elem = config.get("security").getAsJsonObject().get("tokenRecaptcha"))) {
            return elem.getAsString();
        }
        return "";
    }

    public static String tokenSeleniumIdeId() {
        JsonElement elem;
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("security")) && !AppConfig.isNull(elem = config.get("security").getAsJsonObject().get("tokenSeleniumIdeId"))) {
            return elem.getAsString();
        }
        return "";
    }

    public static String tokenCronappId() {
        JsonElement elem;
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("security")) && !AppConfig.isNull(elem = config.get("security").getAsJsonObject().get("tokenCronappId"))) {
            return elem.getAsString();
        }
        return "";
    }

    public static String token() {
        JsonElement elem;
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("security")) && !AppConfig.isNull(elem = config.get("security").getAsJsonObject().get("token"))) {
            return elem.getAsString();
        }
        return "9SyECk96oDsTmXfogIieDI0cD/8FpnojlYSUJT5U9I/FGVmBz5oskmjOR8cbXTvoPjX+Pq/T/b1PqpHX0lYm0oCBjXWICA==";
    }

    public static String guid() {
        JsonElement elem;
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("app")) && !AppConfig.isNull(elem = config.get("app").getAsJsonObject().get("guid"))) {
            return elem.getAsString();
        }
        return "00000000-0000-0000-0000-000000000000";
    }

    public static long tokenExpiration() {
        JsonElement elem;
        JsonObject config = AppConfig.getJSON();
        if (!AppConfig.isNull(config.get("security")) && !AppConfig.isNull(elem = config.get("security").getAsJsonObject().get("tokenExpiration"))) {
            return elem.getAsLong();
        }
        return 3600L;
    }

    public static String type() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("type"))) {
            return elem.getAsString();
        }
        return null;
    }

    public static String defaultDomain() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("defaultDomain"))) {
            return elem.getAsString();
        }
        return null;
    }

    public static String hostname() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("hostname"))) {
            return elem.getAsString();
        }
        return null;
    }

    public static String groupName() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("groupName"))) {
            return elem.getAsString();
        }
        return null;
    }

    public static boolean autoSignUp() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("autoSignUp"))) {
            return elem.getAsBoolean();
        }
        return false;
    }

    public static boolean fixedTimeZone() {
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("fixedTimeZone"))) {
            return config.get("fixedTimeZone").getAsBoolean();
        }
        return true;
    }

    public static String timeZone() {
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("timeZone"))) {
            return config.get("timeZone").getAsString();
        }
        return "UTC";
    }

    public static int timeZoneOffset() {
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("timeZoneOffset"))) {
            return config.get("timeZoneOffset").getAsInt();
        }
        return 0;
    }

    public static FlushModeType flushMode() {
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("flushMode"))) {
            if ("AUTO".equalsIgnoreCase(config.get("flushMode").getAsString())) {
                return FlushModeType.AUTO;
            }
            return FlushModeType.COMMIT;
        }
        return FlushModeType.AUTO;
    }

    public static String getApplicationId() {
        JsonObject app;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("app")) && !AppConfig.isNull((app = config.get("app").getAsJsonObject()).get("guid"))) {
            return app.get("guid").getAsString();
        }
        return "";
    }

    public static String xFrameOptions() {
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("xframeOptions"))) {
            return config.get("xframeOptions").getAsString();
        }
        return "SameOrigin";
    }

    public static String getProjectName() {
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("projectName"))) {
            return config.get("projectName").getAsString();
        }
        return "";
    }

    public static Boolean getIfRegistrationAvailable() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("availableSignup"))) {
            return elem.getAsBoolean();
        }
        return Boolean.FALSE;
    }

    public static Integer getMinPasswordSize() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("minPasswordSize"))) {
            return elem.getAsInt();
        }
        return 6;
    }

    public static Integer getFailedAttempts() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("failedAttempts"))) {
            return elem.getAsInt();
        }
        return 4;
    }

    public static Integer getBlockTime() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("blockTime"))) {
            return elem.getAsInt();
        }
        return 10;
    }

    public static Integer getIdletime() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("idletime"))) {
            return elem.getAsInt();
        }
        return 60;
    }

    public static Boolean getOnlyStrongPass() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("onlyStrongPass"))) {
            return elem.getAsBoolean();
        }
        return true;
    }

    public static Boolean getDontAllowRepeatedPass() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("dontAllowRepeatedPass"))) {
            return elem.getAsBoolean();
        }
        return true;
    }

    public static Integer getMinUpperCase() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("minUpperCase"))) {
            return elem.getAsInt();
        }
        return 1;
    }

    public static Integer getMinDigit() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("minDigit"))) {
            return elem.getAsInt();
        }
        return 1;
    }

    public static Integer getMinSpecial() {
        JsonElement elem;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("auth")) && !AppConfig.isNull(elem = config.get("auth").getAsJsonObject().get("minSpecial"))) {
            return elem.getAsInt();
        }
        return 1;
    }

    public static Locale getLocale() {
        String jsonLocale;
        Locale locale = null;
        JsonObject config = AppConfig.loadJSON();
        if (!AppConfig.isNull(config.get("locale")) && StringUtils.isNotEmpty((CharSequence)(jsonLocale = config.get("locale").getAsString())) && jsonLocale.contains(UNDERLINE)) {
            String[] splited = jsonLocale.split(UNDERLINE);
            locale = new Locale(splited[0], splited[1]);
        }
        return locale;
    }

    public static boolean hasAnyTypeAuthentication() {
        JsonObject auth;
        boolean authenticated = true;
        JsonObject config = AppConfig.loadJSON();
        if (!(AppConfig.isNull(config.get("auth")) || AppConfig.isNull((auth = config.get("auth").getAsJsonObject()).get("templateProperties")) || AppConfig.isNull(auth.get("templateProperties").getAsJsonObject().get("authentication")))) {
            String authentication = auth.get("templateProperties").getAsJsonObject().get("authentication").getAsString();
            authenticated = !NONE.equals(authentication);
        }
        return authenticated;
    }
}

