/*
 * Decompiled with CFR 0.152.
 */
package cronapi.regex;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.i18n.Messages;
import cronapi.regex.PatternFlags;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

@CronapiMetaData(category=CronapiMetaData.CategoryType.REGEX, categoryTags={"Express\u00e3o Regular", "Regular Expression"})
public class Operations {
    @CronapiMetaData(type="function", name="{{extractTextWithRegex}}", nameTags={"extractTextWithRegex"}, description="{{extractTextWithRegexDescription}}", params={"{{text}}", "{{regex}}", "{{flag}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.LIST)
    public static final Var extractTextWithRegexUnscape(Var text, Var regex, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{flag}}", blockType="util_dropdown", keys={"CASE_INSENSITIVE", "MULTILINE", "DOTALL", "UNICODE_CASE", "CANON_EQ", "UNIX_LINES", "LITERAL", "UNICODE_CHARACTER_CLASS", "COMMENTS"}, values={"{{CASE_INSENSITIVE}}", "{{MULTILINE}}", "{{DOTALL}}", "{{UNICODE_CASE}}", "{{CANON_EQ}}", "{{UNIX_LINES}}", "{{LITERAL}}", "{{UNICODE_CHARACTER_CLASS}}", "{{COMMENTS}}"}) Var flags) throws Exception {
        if (Var.valueOf(regex).isEmptyOrNull().booleanValue()) {
            return Var.newList();
        }
        Pattern pattern = Operations.getPattern(regex, flags, false);
        return Operations.getMatcherResults(pattern, text);
    }

    @Deprecated
    public static final Var extractTextWithRegex(Var text, Var regex, Var flags) throws Exception {
        if (Var.valueOf(regex).isEmptyOrNull().booleanValue()) {
            return Var.newList();
        }
        Pattern pattern = Operations.getPattern(regex, flags, true);
        return Operations.getMatcherResults(pattern, text);
    }

    @Deprecated
    public static final Var validateTextWithRegex(Var text, Var regex, Var flags) throws Exception {
        if (Var.valueOf(regex).isEmptyOrNull().booleanValue()) {
            return Var.VAR_FALSE;
        }
        Pattern pattern = Operations.getPattern(regex, flags, true);
        return Operations.existsMatches(pattern, text);
    }

    @CronapiMetaData(type="function", name="{{validateTextWithRegex}}", nameTags={"validateTextWithRegex"}, description="{{validateTextWithRegexDescription}}", params={"{{text}}", "{{regex}}", "{{flag}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var validateTextWithRegexUnscape(Var text, Var regex, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{flag}}", blockType="util_dropdown", keys={"CASE_INSENSITIVE", "MULTILINE", "DOTALL", "UNICODE_CASE", "CANON_EQ", "UNIX_LINES", "LITERAL", "UNICODE_CHARACTER_CLASS", "COMMENTS"}, values={"{{CASE_INSENSITIVE}}", "{{MULTILINE}}", "{{DOTALL}}", "{{UNICODE_CASE}}", "{{CANON_EQ}}", "{{UNIX_LINES}}", "{{LITERAL}}", "{{UNICODE_CHARACTER_CLASS}}", "{{COMMENTS}}"}) Var flags) throws Exception {
        if (Var.valueOf(regex).isEmptyOrNull().booleanValue()) {
            return Var.VAR_FALSE;
        }
        Pattern pattern = Operations.getPattern(regex, flags, false);
        return Operations.existsMatches(pattern, text);
    }

    private static Pattern getPattern(Var regex, Var flags, boolean unescape) throws Exception {
        if (Var.valueOf(flags).isNull().booleanValue()) {
            if (unescape) {
                return Pattern.compile(StringEscapeUtils.unescapeJava((String)regex.getObjectAsString()));
            }
            return Pattern.compile(regex.getObjectAsString());
        }
        Integer patternFlag = Operations.getFlags(flags);
        if (Var.valueOf(patternFlag).isNull().booleanValue()) {
            throw new Exception(Messages.getString("flagRegexError"));
        }
        if (unescape) {
            return Pattern.compile(StringEscapeUtils.unescapeJava((String)regex.getObjectAsString()), patternFlag);
        }
        return Pattern.compile(regex.getObjectAsString(), patternFlag);
    }

    private static Integer getFlags(Var flags) throws Exception {
        try {
            if (flags.getObject() instanceof String) {
                return PatternFlags.valueOf(Var.valueOf(flags).toString()).getValue();
            }
            if (flags.getObject() instanceof List) {
                Integer flagValue = null;
                for (Object flag : flags.getObjectAsList()) {
                    if (!(Var.valueOf(flag).getObject() instanceof String)) {
                        throw new Exception(Messages.getString("flagRegexError"));
                    }
                    if (Var.valueOf(flagValue).isNull().booleanValue()) {
                        flagValue = PatternFlags.valueOf(Var.valueOf(flag).toString()).getValue();
                        continue;
                    }
                    flagValue = flagValue | PatternFlags.valueOf(Var.valueOf(flag).toString()).getValue();
                }
                return flagValue;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(Messages.getString("flagRegexError"));
        }
        return null;
    }

    private static Var getMatcherResults(Pattern pattern, Var text) {
        if (pattern == null) {
            return Var.newList();
        }
        Matcher matcher = pattern.matcher(text.getObjectAsString());
        LinkedList<Var> list = null;
        LinkedList list2 = new LinkedList();
        while (matcher.find()) {
            list = new LinkedList<Var>();
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                list.add(new Var(matcher.group(i)));
            }
            list2.add(list);
        }
        return Var.valueOf(list2);
    }

    private static Var existsMatches(Pattern pattern, Var text) {
        if (pattern == null) {
            return Var.VAR_FALSE;
        }
        Matcher matcher = pattern.matcher(text.getObjectAsString());
        return Var.valueOf(matcher.matches());
    }
}

