/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class DataType {
    private static Map<String, String> contentType = DataType.initializeDefaultFileMimeTypes();

    private static HashMap<String, String> initializeDefaultFileMimeTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pdf", "application/pdf");
        map.put("jpg", "image/jpeg");
        map.put("gif", "image/gif");
        map.put("png", "image/png");
        map.put("bmp", "image/bmp");
        map.put("ico", "image/x-icon");
        map.put("htm", "text/html");
        map.put("html", "text/html");
        map.put("xml", "text/xml");
        map.put("xsd", "text/xml");
        map.put("yaml", "text/x-yaml");
        map.put("raml", "text/x-raml");
        map.put("js", "text/javascript");
        map.put("bat", "text/bat");
        map.put("sh", "text/sh");
        map.put("zip", "application/zip");
        map.put("bz2", "application/x-bzip2");
        map.put("gz", "application/gzip");
        map.put("ear", "application/java-archive");
        map.put("jar", "application/java-archive");
        map.put("war", "application/java-archive");
        map.put("txt", "text/plain");
        map.put("css", "text/css");
        map.put("md", "text/markdown");
        map.put("mf", "text/manifest");
        map.put("sql", "text/sql");
        map.put("jsp", "text/jsp");
        map.put("json", "text/json");
        map.put("db", "text/database");
        map.put("java", "text/java");
        map.put("properties", "text/properties");
        map.put("project", "text/project");
        map.put("classpath", "text/classpath");
        map.put("ftl", "text/ftl");
        map.put("gitignore", "text/plain");
        map.put("umlcd", "text/umlcd");
        map.put("umlsc", "text/umlsc");
        map.put("erd", "text/erd");
        map.put("bpmn", "text/bpmn");
        map.put("fsa", "text/fsa");
        map.put("org", "text/org");
        map.put("pn", "text/pn");
        map.put("devs", "text/devs");
        map.put("logic", "text/logic");
        map.put("graph", "text/graph");
        map.put("kroki", "text/kroki");
        map.put("jrxml", "text/xml");
        map.put("blockly", "text/blockly");
        return map;
    }

    public static String getFileExtension(File file) {
        return DataType.getFileExtension(file.getAbsolutePath());
    }

    public static String getFileExtension(String path) {
        int fileType = path.lastIndexOf(".");
        return path.substring(fileType + 1).trim();
    }

    public static String getContentType(File filename) {
        return DataType.getContentType(filename.getAbsolutePath());
    }

    public static String getContentType(String filename) {
        String ext = DataType.getFileExtension(filename);
        if (contentType.containsKey(ext.toLowerCase())) {
            return contentType.get(ext.toLowerCase());
        }
        return "application/binary";
    }
}

