/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import com.google.gson.JsonObject;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.odata.server.JPAODataServiceFactory;
import cronapi.odata.server.JPQLParserUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.PathInfoImpl;
import org.apache.olingo.odata2.core.servlet.RestUtil;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ODataDatasource {
    private static Map<String, Integer> ORDER = new HashMap<String, Integer>();
    private String namespace;

    public ODataDatasource(String namespace) {
        this.namespace = namespace.substring(0, namespace.indexOf("."));
    }

    private String setQueryString(String queryString, String name, String value) {
        List pairs = URLEncodedUtils.parse((String)queryString, (Charset)Charset.forName("UTF-8"));
        if (pairs != null) {
            NameValuePair pair = pairs.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
            if (pair != null) {
                pairs.remove(pair);
            }
            pair = new BasicNameValuePair(name, value);
            pairs.add(pair);
        }
        return URLEncodedUtils.format((Iterable)pairs, (Charset)Charset.forName("UTF-8"));
    }

    public ODataResponse odata(String method, String strPath, String body, Pageable pageRequest, boolean isCount, Var ... params) {
        try {
            ODataResponse odataResponse;
            String queryString = null;
            if (params != null) {
                for (Var param : params) {
                    strPath = JPQLParserUtil.replaceToken(strPath, ":" + param.getId(), URLEncoder.encode(param.getObjectAsOdata(), "UTF-8"));
                }
            }
            if (strPath.contains("?")) {
                String[] urlParts = strPath.split("\\?");
                queryString = urlParts[1];
                strPath = urlParts[0];
                List pairs = URLEncodedUtils.parse((String)queryString, (Charset)Charset.forName("UTF-8"));
                if (pairs != null) {
                    for (NameValuePair pair : List.copyOf(pairs)) {
                        pairs.remove(pair);
                        String value = pair.getValue();
                        for (Var param : params) {
                            value = JPQLParserUtil.replaceToken(value, ":" + param.getId(), param.getObjectAsOdata());
                        }
                        pair = new BasicNameValuePair(pair.getName(), value);
                        pairs.add(pair);
                    }
                    queryString = URLEncodedUtils.format((Iterable)pairs, (Charset)Charset.forName("UTF-8"));
                }
                RestClient.getRestClient().setParameters(queryString);
                RestClient.getRestClient().setQueryString(queryString);
            } else {
                RestClient.getRestClient().setParameters("");
            }
            if (pageRequest != null) {
                queryString = this.setQueryString(queryString, "$top", String.valueOf(pageRequest.getPageSize()));
                queryString = this.setQueryString(queryString, "$skip", String.valueOf(pageRequest.getOffset()));
                RestClient.getRestClient().setParameters(queryString);
                RestClient.getRestClient().setQueryString(queryString);
            }
            RestClient.getRestClient().setMethod(method);
            String[] parts = strPath.split("/");
            JPAODataServiceFactory serviceFactory = new JPAODataServiceFactory(this.namespace, ORDER.getOrDefault(this.namespace, 0), null);
            LinkedList<ODataPathSegmentImpl> odataPathSegment = new LinkedList<ODataPathSegmentImpl>();
            for (int i = 1; i < parts.length; ++i) {
                odataPathSegment.add(new ODataPathSegmentImpl(parts[i], new LinkedHashMap()));
            }
            PathInfoImpl path = new PathInfoImpl();
            path.setODataPathSegment(odataPathSegment);
            path.setServiceRoot(new URI("file:///local/"));
            path.setRequestUri(new URI("file:///local/" + strPath));
            ByteArrayInputStream ip = new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
            ODataRequest odataRequest = ODataRequest.method((ODataHttpMethod)ODataHttpMethod.valueOf((String)method)).httpMethod(method).contentType("application/json").acceptHeaders(RestUtil.extractAcceptHeaders((String)"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8")).acceptableLanguages(RestUtil.extractAcceptableLanguage((String)"en-US")).pathInfo((PathInfo)path).allQueryParameters(RestUtil.extractAllQueryParameters((String)queryString, null)).requestHeaders(new HashMap()).body((InputStream)ip).build();
            ODataContextImpl context = new ODataContextImpl(odataRequest, (ODataServiceFactory)serviceFactory);
            ODataService service = serviceFactory.createService((ODataContext)context);
            context.setService(service);
            service.getProcessor().setContext((ODataContext)context);
            ODataRequestHandler requestHandler = new ODataRequestHandler((ODataServiceFactory)serviceFactory, service, (ODataContext)context);
            ODataResponse oDataResponse = odataResponse = requestHandler.handle(odataRequest, false);
            return oDataResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            RestClient.removeClient();
        }
    }

    public Page query(String query, Pageable pageRequest, boolean isCount, Var ... params) {
        String method = query.substring(0, query.indexOf(" "));
        query = query.substring(query.indexOf(" ") + 1);
        LinkedList resultsInPage = new LinkedList();
        try {
            ODataResponse odataResponse = this.odata(method, query, "", pageRequest, isCount, params);
            resultsInPage.addAll(odataResponse.getEntities());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            RestClient.removeClient();
        }
        return new PageImpl(resultsInPage, pageRequest, 0L);
    }

    public Map<String, Object> execute(String query, Var ... params) {
        String method = query.substring(0, query.indexOf(" "));
        query = query.substring(query.indexOf(" ") + 1);
        JsonObject data = new JsonObject();
        for (Var p : params) {
            data.add(p.getId(), p.getObjectAsJsonElement());
        }
        this.odata(method, query, method.equals("POST") || method.equals("PUT") ? data.toString() : "", null, false, params);
        return Map.of();
    }

    static {
        Set archives = PersistenceUnitProcessor.findPersistenceArchives();
        int i = 0;
        for (Archive archive : archives) {
            List persistenceUnitInfos = PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
            persistenceUnitInfos.sort((p1, p2) -> {
                if (p1.getPersistenceUnitName().equals("app")) {
                    return -1;
                }
                if (p2.getPersistenceUnitName().equals("app")) {
                    return 1;
                }
                return p1.getPersistenceUnitName().compareTo(p2.getPersistenceUnitName());
            });
            for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                String namespace = pui.getPersistenceUnitName();
                ORDER.put(namespace, i);
                ++i;
            }
        }
    }
}

