/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import cronapi.odata.server.ODataServletV2;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"cronappEntityManagerFactory"})
@ComponentScan(basePackages={"cronapi.odata.server"})
public class ODataConfiguration
implements ServletContextInitializer {
    public static final String SERVICE_URL = "/api/cronapi/odata/v2/";

    public void onStartup(ServletContext servletContext) {
        this.registerServlet(servletContext);
    }

    private void registerServlet(ServletContext servletContext) {
        Set archives = PersistenceUnitProcessor.findPersistenceArchives();
        int i = 0;
        for (Archive archive : archives) {
            List persistenceUnitInfos = PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
            persistenceUnitInfos.sort((p1, p2) -> {
                if (p1.getPersistenceUnitName().equals("app")) {
                    return -1;
                }
                if (p2.getPersistenceUnitName().equals("app")) {
                    return 1;
                }
                return p1.getPersistenceUnitName().compareTo(p2.getPersistenceUnitName());
            });
            for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                String namespace = pui.getPersistenceUnitName();
                ODataServletV2 servlet = new ODataServletV2(namespace, i);
                ServletRegistration.Dynamic serviceServlet = servletContext.addServlet("ServiceOData" + namespace, (Servlet)servlet);
                serviceServlet.addMapping(new String[]{SERVICE_URL + namespace + "/*"});
                serviceServlet.setAsyncSupported(true);
                serviceServlet.setLoadOnStartup(2);
                ++i;
            }
        }
    }
}

