/*
 * Decompiled with CFR 0.152.
 */
package cronapi.dateTime;

import cronapi.AppConfig;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.RestClient;
import cronapi.Utils;
import cronapi.Var;
import cronapi.i18n.Messages;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@CronapiMetaData(category=CronapiMetaData.CategoryType.DATETIME, categoryTags={"Data", "Data e hora", "Hora", "Date", "DateTime", "Time"})
public class Operations {
    private static Var getFromCalendar(Var date, int type) {
        return new Var(date.getObjectAsDateTime().get(type));
    }

    @CronapiMetaData(type="function", name="{{getSecondFromDate}}", nameTags={"getSecond"}, description="{{functionToGetSecondFromDate}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getSecond(Var value) {
        return Operations.getFromCalendar(value, 13);
    }

    @CronapiMetaData(type="function", name="{{getMinuteFromDate}}", nameTags={"getMinute"}, description="{{functionToGetMinuteFromDate}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getMinute(Var value) {
        return Operations.getFromCalendar(value, 12);
    }

    @CronapiMetaData(type="function", name="{{getHourFromDate}}", nameTags={"getHour"}, description="{{functionToGetHourFromDate}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getHour(Var value) {
        return Operations.getFromCalendar(value, 11);
    }

    @CronapiMetaData(type="function", name="{{getYearFromDate}}", nameTags={"getYear"}, description="{{functionToGetYearFromDate}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getYear(Var value) {
        return Operations.getFromCalendar(value, 1);
    }

    @CronapiMetaData(type="function", name="{{getMonthFromDate}}", nameTags={"getMonth"}, description="{{functionToGetMonthFromDate}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getMonth(Var value) {
        return new Var(Operations.getFromCalendar(value, 2).getObjectAsInt() + 1);
    }

    @CronapiMetaData(type="function", name="{{getDayFromDate}}", nameTags={"getDay"}, description="{{functionToGetDayFromDate}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getDay(Var value) {
        return Operations.getFromCalendar(value, 5);
    }

    @CronapiMetaData(type="function", name="{{getDayOfWeek}}", nameTags={"getDayOfWeek"}, description="{{functionToGetDayOfWeek}}", params={"{{date}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getDayOfWeek(Var value) {
        return Operations.getFromCalendar(value, 7);
    }

    @CronapiMetaData(type="function", name="{{getLastDayFromMonth}}", nameTags={"getLastDayFromMonth"}, description="{{functionToGetLastDayFromMonth}}", params={"{{month}}", "{{year}}"}, paramsType={CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getLastDayFromMonth(Var month, Var year) {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.set(2, month.getObjectAsInt() - 1);
        c.set(1, year.getObjectAsInt());
        int actualMaximum = c.getActualMaximum(5);
        return new Var(actualMaximum);
    }

    @CronapiMetaData(type="function", name="{{newDate}}", nameTags={"newDate", "createDate"}, description="{{functionToNewDate}}", params={"{{year}}", "{{month}}", "{{day}}", "{{hour}}", "{{minute}}", "{{second}}"}, paramsType={CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var newDate(Var year, Var month, Var day, Var hour, Var minute, Var second) {
        int y = year.getObjectAsInt();
        int m = month.getObjectAsInt() - 1;
        int d = day.getObjectAsInt();
        int h = hour.getObjectAsInt();
        int min = minute.getObjectAsInt();
        int s = second.getObjectAsInt();
        Calendar date = Calendar.getInstance();
        date.set(y, m, d, h, min, s);
        date.set(14, 0);
        return new Var(date.getTime());
    }

    @Deprecated
    public static final Var updateDate(Var date, Var year, Var month, Var day, Var hour, Var minute, Var second, Var millisecond) {
        Calendar updatedDate = Calendar.getInstance();
        updatedDate.setTime(date.getObjectAsDateTime().getTime());
        int y = year.getObjectAsInt();
        int m = month.getObjectAsInt() - 1;
        int d = day.getObjectAsInt();
        int h = hour.getObjectAsInt();
        int min = minute.getObjectAsInt();
        int s = second.getObjectAsInt();
        int mili = millisecond.getObjectAsInt();
        updatedDate.set(y, m, d, h, min, s);
        updatedDate.set(14, mili);
        return new Var(updatedDate.getTime());
    }

    @CronapiMetaData(type="function", name="{{updateDate}}", nameTags={"updateDate", "setDate"}, description="{{functionToUpdateDate}}", params={"{{date}}", "{{type}}", "{{value}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var updateNewDate(Var date, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{attribute}}", blockType="util_dropdown", keys={"year", "month", "day", "hour", "minute", "second", "millisecond"}, values={"{{year}}", "{{month}}", "{{day}}", "{{hour}}", "{{minute}}", "{{second}}", "{{millisecond}}"}) Var type, Var value) {
        Calendar updatedDate = Calendar.getInstance();
        updatedDate.setTime(date.getObjectAsDateTime().getTime());
        switch (type.getObjectAsString()) {
            case "year": {
                updatedDate.set(1, value.getObjectAsInt());
                break;
            }
            case "month": {
                updatedDate.set(2, value.getObjectAsInt() - 1);
                break;
            }
            case "day": {
                updatedDate.set(5, value.getObjectAsInt());
                break;
            }
            case "hour": {
                updatedDate.set(11, value.getObjectAsInt());
                break;
            }
            case "minute": {
                updatedDate.set(12, value.getObjectAsInt());
                break;
            }
            case "second": {
                updatedDate.set(13, value.getObjectAsInt());
                break;
            }
            case "millisecond": {
                updatedDate.set(14, value.getObjectAsInt());
            }
        }
        return new Var(updatedDate.getTime());
    }

    @CronapiMetaData(type="function", name="{{getSecondsBetweenDates}}", nameTags={"getSecondsBetweenDates", "getSecondsDiffDate", "diffDatesSeconds"}, description="{{functionToGetSecondsBetweenDates}}", params={"{{largerDateToBeSubtracted}}", "{{smallerDateToBeSubtracted}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getSecondsBetweenDates(Var dateVar, Var date2Var) {
        long SECOND_IN_MILLIS = 1000L;
        Date date = dateVar.getObjectAsDateTime().getTime();
        Date date2 = date2Var.getObjectAsDateTime().getTime();
        int resultBetween = (int)((date.getTime() - date2.getTime()) / 1000L);
        return new Var(resultBetween);
    }

    @CronapiMetaData(type="function", name="{{getMinutesBetweenDates}}", nameTags={"getMinutesBetweenDates", "getMinutesDiffDate", "diffDatesMinutes"}, description="{{functionToGetMinutesBetweenDates}}", params={"{{largerDateToBeSubtracted}}", "{{smallerDateToBeSubtracted}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getMinutesBetweenDates(Var dateVar, Var date2Var) {
        long MINUTE_IN_MILLIS = 60000L;
        Date date = dateVar.getObjectAsDateTime().getTime();
        Date date2 = date2Var.getObjectAsDateTime().getTime();
        int resultBetween = (int)((date.getTime() - date2.getTime()) / 60000L);
        return new Var(resultBetween);
    }

    @CronapiMetaData(type="function", name="{{getHoursBetweenDates}}", nameTags={"getHoursBetweenDates", "getHoursDiffDate", "diffDatesHours"}, description="{{functionToGetHoursBetweenDates}}", params={"{{largerDateToBeSubtracted}}", "{{smallerDateToBeSubtracted}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getHoursBetweenDates(Var dateVar, Var date2Var) {
        long HOUR_IN_MILLIS = 3600000L;
        Date date = dateVar.getObjectAsDateTime().getTime();
        Date date2 = date2Var.getObjectAsDateTime().getTime();
        int resultBetween = (int)((date.getTime() - date2.getTime()) / 3600000L);
        return new Var(resultBetween);
    }

    @CronapiMetaData(type="function", name="{{getDaysBetweenDates}}", nameTags={"getDaysBetweenDates", "getDaysDiffDate", "diffDatesDays"}, description="{{functionToGetDaysBetweenDates}}", params={"{{largerDateToBeSubtracted}}", "{{smallerDateToBeSubtracted}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getDaysBetweenDates(Var dateVar, Var date2Var) {
        long DAY_IN_MILLIS = 86400000L;
        Date date = dateVar.getObjectAsDateTime().getTime();
        Date date2 = date2Var.getObjectAsDateTime().getTime();
        int daysBetween = (int)((date.getTime() - date2.getTime()) / 86400000L);
        return new Var(daysBetween);
    }

    @CronapiMetaData(type="function", name="{{getMonthsBetweenDates}}", nameTags={"getMonthsBetweenDates", "getMonthsDiffDate", "diffDatesMonths"}, description="{{functionToGetMonthsBetweenDates}}", params={"{{largerDateToBeSubtracted}}", "{{smallerDateToBeSubtracted}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getMonthsBetweenDates(Var dateVar, Var date2Var) {
        int yearBetween = 0;
        int monthBetween = 0;
        Calendar date = Calendar.getInstance();
        Calendar date2 = Calendar.getInstance();
        date.setTime(dateVar.getObjectAsDateTime().getTime());
        date2.setTime(date2Var.getObjectAsDateTime().getTime());
        yearBetween = (date.get(1) - date2.get(1)) * 12;
        monthBetween = date.get(2) - date2.get(2);
        monthBetween += yearBetween;
        if (date2.before(date) && date.get(5) < date2.get(5)) {
            --monthBetween;
        } else if (date2.after(date) && date.get(5) > date2.get(5)) {
            ++monthBetween;
        }
        return new Var(monthBetween);
    }

    @CronapiMetaData(type="function", name="{{getYearsBetweenDates}}", nameTags={"getYearsBetweenDates", "getYearsDiffDate", "diffDatesYears"}, description="{{functionToGetYearsBetweenDates}}", params={"{{largerDateToBeSubtracted}}", "{{smallerDateToBeSubtracted}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getYearsBetweenDates(Var dateVar, Var date2Var) {
        Calendar date = Calendar.getInstance();
        Calendar date2 = Calendar.getInstance();
        date.setTime(dateVar.getObjectAsDateTime().getTime());
        date2.setTime(date2Var.getObjectAsDateTime().getTime());
        double diference = date.get(1) * 12 * 30 + date.get(2) * 30 + date.get(5) - (date2.get(1) * 12 * 30 + date2.get(2) * 30 + date2.get(5));
        double result = diference / 360.0;
        if (result - (double)((int)result) >= 0.5) {
            return new Var((int)(result += 1.0));
        }
        return new Var((int)result);
    }

    @CronapiMetaData(type="function", name="{{incSecond}}", nameTags={"incSecond", "increaseSecond"}, description="{{functionToIncSecond}}", params={"{{date}}", "{{secondsToIncrement}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var incSeconds(Var value, Var second) {
        Calendar d = Calendar.getInstance();
        d.setTime(value.getObjectAsDateTime().getTime());
        d.add(13, second.getObjectAsInt());
        return new Var(d.getTime());
    }

    @CronapiMetaData(type="function", name="{{incMinute}}", nameTags={"incMinute", "increaseMinute"}, description="{{functionToIncMinute}}", params={"{{date}}", "{{minutesToIncrement}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var incMinute(Var value, Var minute) {
        Calendar d = Calendar.getInstance();
        d.setTime(value.getObjectAsDateTime().getTime());
        d.add(12, minute.getObjectAsInt());
        return new Var(d.getTime());
    }

    @CronapiMetaData(type="function", name="{{incHour}}", nameTags={"incHour", "increaseHour"}, description="{{functionToIncHour}}", params={"{{date}}", "{{hoursToIncrement}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var incHour(Var value, Var hour) {
        Calendar d = Calendar.getInstance();
        d.setTime(value.getObjectAsDateTime().getTime());
        d.add(11, hour.getObjectAsInt());
        return new Var(d.getTime());
    }

    @CronapiMetaData(type="function", name="{{incDay}}", nameTags={"incDay", "increaseDay"}, description="{{functionToIncDay}}", params={"{{date}}", "{{daysToIncrement}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var incDay(Var value, Var day) {
        Calendar d = Calendar.getInstance();
        d.setTime(value.getObjectAsDateTime().getTime());
        d.add(5, day.getObjectAsInt());
        return new Var(d.getTime());
    }

    @CronapiMetaData(type="function", name="{{incMonth}}", nameTags={"incMonth", "increaseMonth"}, description="{{functionToIncMonth}}", params={"{{date}}", "{{monthsToIncrement}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var incMonth(Var value, Var month) {
        Calendar d = Calendar.getInstance();
        d.setTime(value.getObjectAsDateTime().getTime());
        d.add(2, month.getObjectAsInt());
        return new Var(d.getTime());
    }

    @CronapiMetaData(type="function", name="{{incYear}}", nameTags={"incYear", "increaseYear"}, description="{{functionToIncYear}}", params={"{{date}}", "{{yearsToIncrement}}"}, paramsType={CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var incYear(Var value, Var year) {
        Calendar d = Calendar.getInstance();
        d.setTime(value.getObjectAsDateTime().getTime());
        d.add(1, year.getObjectAsInt());
        return new Var(d.getTime());
    }

    @CronapiMetaData(type="function", name="{{getNow}}", nameTags={"getNow", "now", "getDate"}, description="{{functionToGetNow}}", returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var getNow() {
        Calendar cal = Calendar.getInstance();
        return new Var(cal.getTime());
    }

    @CronapiMetaData(type="function", name="{{getNowNoHour}}", nameTags={"getNow", "now", "getDate"}, description="{{functionToGetNowNoHour}}", returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var getNowNoHour() {
        Calendar cal = Operations.getNow().getObjectAsDateTime();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Var(cal);
    }

    @CronapiMetaData(type="function", name="{{getNowInMilliseconds}}", nameTags={"getNow", "now", "getDate", "milliseconds"}, description="{{getNowInMillisecondsDescription}}", returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var getNowInMilliseconds() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return new Var(cal.getTimeInMillis());
    }

    @Deprecated
    @CronapiMetaData(type="function", name="{{formatDateTimeWithTimeZone}}", nameTags={"format", "date", "datetime", "@deprecated"}, description="{{functionToFormatDateTime}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var formatDateTime(@ParamMetaData(type=CronapiMetaData.ObjectType.DATETIME, description="{{date}}") Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{maskFormat}}") Var format, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{timezoneFormat}}") Var timeZone) {
        return Operations.formatDateTime2(value, format, timeZone, Var.VAR_FALSE);
    }

    @CronapiMetaData(type="function", name="{{formatDateTimeWithTimeZone}}", nameTags={"format", "date", "datetime"}, description="{{functionToFormatDateTime}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var formatDateTime2(@ParamMetaData(type=CronapiMetaData.ObjectType.DATETIME, description="{{date}}") Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{maskFormat}}") Var format, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{timezoneFormat}}") Var timeZone, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{useClientLocale}}", blockType="util_dropdown", keys={"true", "false"}, values={"{{yes}}", "{{no}}"}) Var useClientLocale) {
        if (format.isEmptyOrNull().booleanValue()) {
            format = Var.valueOf(Messages.getString("DateTimeFormat"));
        }
        if (format.getObjectAsString().equals("DateTimeFormat")) {
            format = Var.valueOf(Messages.getString("DateTimeFormat"));
        }
        if (format.getObjectAsString().equals("DateFormat")) {
            format = Var.valueOf(Messages.getString("DateFormat"));
        }
        if (format.getObjectAsString().equals("ISO8601")) {
            DateFormat frm = Utils.getISODateFormat();
            return Var.valueOf(frm.format(value.getObjectAsDateTime().getTime()));
        }
        Locale locale = AppConfig.getLocale();
        if (useClientLocale.getObjectAsBoolean().booleanValue()) {
            locale = RestClient.getRestClient().getLocale();
        }
        SimpleDateFormat sdf = locale != null ? new SimpleDateFormat(format.getObjectAsString(), locale) : new SimpleDateFormat(format.getObjectAsString());
        sdf.setTimeZone(Utils.toTimeZone(timeZone));
        return Var.valueOf(sdf.format(value.getObjectAsDateTime().getTime()));
    }

    @Deprecated
    @CronapiMetaData(type="function", name="{{formatDateTime}}", nameTags={"format", "date", "datetime", "@deprecated"}, description="{{functionToFormatDateTime}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var formatDateTime(@ParamMetaData(type=CronapiMetaData.ObjectType.DATETIME, description="{{date}}") Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{maskFormat}}") Var format) {
        return Operations.formatDateTime2(value, format, Var.VAR_FALSE);
    }

    @CronapiMetaData(type="function", name="{{formatDateTime}}", nameTags={"format", "date", "datetime"}, description="{{functionToFormatDateTime}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var formatDateTime2(@ParamMetaData(type=CronapiMetaData.ObjectType.DATETIME, description="{{date}}") Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{maskFormat}}") Var format, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{useClientLocale}}", blockType="util_dropdown", keys={"true", "false"}, values={"{{yes}}", "{{no}}"}) Var useClientLocale) {
        return Operations.formatDateTime2(value, format, Var.VAR_NULL, useClientLocale);
    }
}

