/*
 * Decompiled with CFR 0.152.
 */
package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.AppConfig;
import cronapi.ParamMetaData;
import cronapi.i18n.Messages;
import cronapi.odata.server.ODataAgent;
import cronapi.rest.security.CronappSecurity;
import cronapi.swagger.CronappOpenApiConsts;
import cronapi.swagger.CronappSwagger;
import cronapi.swagger.ExampleBodyDefinition;
import cronapi.swagger.InfoDefinition;
import cronapi.swagger.OperationDefinition;
import cronapi.swagger.ParameterBlocklyBodyDefinition;
import cronapi.swagger.ParameterBodyDefinition;
import cronapi.swagger.ParameterDefinition;
import cronapi.swagger.PathDefinition;
import cronapi.swagger.ResponseDefinition;
import cronapi.swagger.SecurityDefinition;
import cronapi.swagger.ServerDefinition;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

@Configuration
public class CronappOpenApiDefinition {
    private String openapi = "3.0.1";
    private final ArrayList<ServerDefinition> servers = new ArrayList();
    private InfoDefinition info = new InfoDefinition();
    private LinkedHashMap<String, PathDefinition> paths = new LinkedHashMap();
    private final HashMap<String, HashMap> components = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(CronappOpenApiDefinition.class);
    private Map<String, Edm> edmSchemas;

    private void fillDefinitions() {
        this.servers.add(this.getDefaultServer());
        this.info.setTitle(AppConfig.getProjectName());
        this.info.setDescription(AppConfig.getProjectName());
        this.info.setVersion("1.0");
        this.fillComponentODataDefaultParams();
        this.fillSecurityDefinition();
        this.fillAuthDefinition();
        try {
            this.fillEntitiesOdataDefinition();
        }
        catch (EdmException e) {
            throw new RuntimeException(e);
        }
        this.fillDatasourcesOdataDefinition();
        this.fillBlocklyDefinition();
        this.fillRestDefinition();
    }

    @JsonIgnore
    public JsonElement getJsonData() {
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
        CronappOpenApiDefinition def = new CronappOpenApiDefinition();
        def.fillDefinitions();
        String json = null;
        try {
            json = ow.writeValueAsString((Object)def);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return (JsonElement)new Gson().fromJson(json, JsonElement.class);
    }

    private ServerDefinition getDefaultServer() {
        ServerDefinition server = new ServerDefinition();
        server.setDescription(Messages.getLocale().getCountry());
        server.setUrl("/");
        return server;
    }

    private void fillEntitiesOdataDefinition() throws EdmException {
        this.edmSchemas = ODataAgent.getSchemas();
        if (this.exposeEntities()) {
            Reflections reflections = new Reflections(CronappOpenApiConsts.ODATA_PACKAGE, new Scanner[0]);
            Set allEntities = reflections.getTypesAnnotatedWith(CronappSwagger.class);
            for (Class entity : allEntities) {
                ResponseDefinition response201;
                ResponseDefinition response200;
                OperationDefinition operation;
                EdmEntityType schema;
                CronappSecurity metaSecurity = entity.getAnnotation(CronappSecurity.class);
                if (metaSecurity.get().equals(CronappOpenApiConsts.SECURITY_NONE) && metaSecurity.post().equals(CronappOpenApiConsts.SECURITY_NONE) && metaSecurity.put().equals(CronappOpenApiConsts.SECURITY_NONE) && metaSecurity.delete().equals(CronappOpenApiConsts.SECURITY_NONE)) continue;
                PathDefinition path = new PathDefinition();
                PathDefinition pathWithParamUrl = new PathDefinition();
                String[] tags = entity.getSimpleName().split(",");
                ArrayList<ParameterDefinition> arrParamKeysDefinition = new ArrayList<ParameterDefinition>();
                ParameterBodyDefinition paramBodyDefinition = new ParameterBodyDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                ExampleBodyDefinition exampleBodyDefinition = new ExampleBodyDefinition();
                ArrayList<String> requiredFields = new ArrayList<String>();
                if (this.exposeMetadata()) {
                    LinkedHashMap<String, CallSite> metadata = new LinkedHashMap<String, CallSite>();
                    metadata.put("id", (CallSite)((Object)(CronappOpenApiConsts.ODATA_REST_PREFIX + "/" + entity.getSimpleName() + "('_objectKey')")));
                    metadata.put("uri", (CallSite)((Object)(CronappOpenApiConsts.ODATA_REST_PREFIX + "/" + entity.getSimpleName() + "('_objectKey')")));
                    metadata.put("type", (CallSite)((Object)(this.getNamespace(entity.getName()) + "." + entity.getSimpleName())));
                    exampleBodyDefinition.addProperty("__metadata", metadata);
                }
                if ((schema = ODataAgent.getSchema(this.edmSchemas, this.getNamespace(entity.getPackageName()), entity.getSimpleName())) == null) continue;
                paramBodyDefinition.setRequired(true);
                schema.getKeyProperties().forEach(field -> {
                    try {
                        ParameterDefinition paramKey = new ParameterDefinition();
                        paramKey.setType(this.parseType(field.getType().getName()));
                        paramKey.setName(field.getName());
                        paramKey.setIn(CronappOpenApiConsts.PARAMETER_PATH);
                        arrParamKeysDefinition.add(paramKey);
                        exampleBodyDefinition.addProperty(field.getName(), this.getValueBasedOnType(this.parseType(field.getType().getName())));
                    }
                    catch (EdmException e) {
                        logger.error(e.getMessage());
                    }
                });
                schema.getPropertyNames().forEach(propName -> {
                    try {
                        EdmTyped field = schema.getProperty(propName);
                        EdmSimplePropertyImplProv props = (EdmSimplePropertyImplProv)field;
                        if (!field.getName().contains("_objectKey") && !props.getProperty().isDisplayField()) {
                            LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
                            param.put("type", this.parseType(field.getType().getName()));
                            param.put("description", field.getName());
                            paramBodyDefinition.addProperty(field.getName(), param);
                            exampleBodyDefinition.addProperty(field.getName(), this.getValueBasedOnType(this.parseType(field.getType().getName())));
                        }
                    }
                    catch (EdmException e) {
                        logger.error(e.getMessage());
                    }
                });
                for (int j = 0; j < entity.getDeclaredFields().length; ++j) {
                    Field field2 = entity.getDeclaredFields()[j];
                    Column columnAnnotation = field2.getAnnotation(Column.class);
                    if (columnAnnotation == null || columnAnnotation != null && columnAnnotation.nullable()) continue;
                    requiredFields.add(columnAnnotation.name());
                }
                this.addEntityToSchemaModel(entity.getSimpleName(), paramBodyDefinition, requiredFields);
                paramBodyDefinition.addToMetadataReference(entity.getSimpleName());
                StringBuilder pathParams = new StringBuilder();
                for (ParameterDefinition param : arrParamKeysDefinition) {
                    pathParams.append("('{" + param.getName() + "}')");
                }
                if (!metaSecurity.get().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                    operation = new OperationDefinition();
                    operation.setOperationId(entity.getSimpleName() + CronappOpenApiConsts.ACTION_GET);
                    operation.setTags(tags);
                    operation.setSecurity(this.getSecurity());
                    operation.setParameters(this.fillODataDefaultParams());
                    response200 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                    response200.setDescription(Messages.getString("swaggerResponseSuccess"));
                    response200.addExample(exampleBodyDefinition.getContentAsModelList());
                    operation.getResponses().putIfAbsent("200", response200);
                    operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                    path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_GET, operation);
                }
                if (!metaSecurity.get().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                    operation = new OperationDefinition();
                    operation.setOperationId(entity.getSimpleName() + CronappOpenApiConsts.ACTION_GET + "PATH");
                    operation.setTags(tags);
                    operation.setSecurity(this.getSecurity());
                    response200 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                    response200.setDescription(Messages.getString("swaggerResponseSuccess"));
                    response200.addExample(exampleBodyDefinition.getContent());
                    operation.getResponses().putIfAbsent("200", response200);
                    operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                    operation.setParameters(arrParamKeysDefinition);
                    pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_GET, operation);
                }
                if (!metaSecurity.post().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                    operation = new OperationDefinition();
                    operation.setOperationId(entity.getSimpleName() + CronappOpenApiConsts.ACTION_POST);
                    operation.setTags(tags);
                    operation.setRequestBody(paramBodyDefinition);
                    operation.setSecurity(this.getSecurity());
                    response201 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                    response201.setDescription(Messages.getString("swaggerPostSuccess"));
                    response201.addExample(exampleBodyDefinition.getContent());
                    operation.getResponses().putIfAbsent("201", response201);
                    operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                    path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_POST, operation);
                }
                if (!metaSecurity.put().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                    operation = new OperationDefinition();
                    operation.setOperationId(entity.getName() + CronappOpenApiConsts.ACTION_PUT);
                    operation.setTags(tags);
                    operation.setRequestBody(paramBodyDefinition);
                    operation.setSecurity(this.getSecurity());
                    response201 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                    response201.setDescription(Messages.getString("swaggerPutSuccess"));
                    response201.addExample(exampleBodyDefinition.getContent());
                    operation.getResponses().putIfAbsent("201", response201);
                    operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                    operation.setParameters(arrParamKeysDefinition);
                    pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_PUT, operation);
                }
                if (!metaSecurity.delete().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                    operation = new OperationDefinition();
                    operation.setOperationId(entity.getName() + CronappOpenApiConsts.ACTION_DELETE);
                    operation.setTags(tags);
                    operation.setParameters(arrParamKeysDefinition);
                    operation.setSecurity(this.getSecurity());
                    operation.getResponses().put("204", this.getDefaultDeleteResponse());
                    operation.getResponses().put("500", this.getDefaultBadRequestResponse());
                    pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_DELETE, operation);
                }
                this.paths.putIfAbsent(String.join((CharSequence)"/", CronappOpenApiConsts.ODATA_REST_PREFIX, schema.getNamespace(), entity.getSimpleName()), path);
                this.paths.putIfAbsent(String.join((CharSequence)"/", CronappOpenApiConsts.ODATA_REST_PREFIX, schema.getNamespace(), entity.getSimpleName() + pathParams.toString()), pathWithParamUrl);
            }
        }
    }

    private void fillDatasourcesOdataDefinition() {
        if (this.edmSchemas == null) {
            this.edmSchemas = ODataAgent.getSchemas();
        }
        if (this.exposeDataSources()) {
            ClassLoader classLoader = CronappOpenApiDefinition.class.getClassLoader();
            Reflections reflections = new Reflections("META-INF.datasources", new Scanner[]{new ResourcesScanner()});
            Set files = reflections.getResources(CronappOpenApiConsts.DATASOURCE_PATTERN);
            for (String file : files) {
                if (!file.endsWith(".datasource.json")) continue;
                try (InputStream stream = classLoader.getResourceAsStream(file);
                     InputStreamReader reader = new InputStreamReader(stream);){
                    ResponseDefinition response201;
                    EdmEntityType schema;
                    JsonObject verbs;
                    JsonObject datasource = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    if (datasource.get("swagger") == null || !datasource.get("swagger").getAsBoolean() || !this.isDatasourceVerbEnabled((JsonElement)(verbs = datasource.get("verbs").getAsJsonObject()), CronappOpenApiConsts.ACTION_GET.toUpperCase()) && !this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_POST.toUpperCase()) && !this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_PUT.toUpperCase()) && !this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_DELETE.toUpperCase())) continue;
                    PathDefinition path = new PathDefinition();
                    PathDefinition pathWithParamUrl = new PathDefinition();
                    String[] tags = datasource.get("queryName").getAsString().split(",");
                    String datasourceId = datasource.getAsJsonObject().get("customId").getAsString();
                    ArrayList<ParameterDefinition> arrParamKeysDefinition = new ArrayList<ParameterDefinition>();
                    ParameterBodyDefinition paramBodyDefinition = new ParameterBodyDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                    ExampleBodyDefinition exampleBodyDefinition = new ExampleBodyDefinition();
                    if (this.exposeMetadata()) {
                        LinkedHashMap<String, CallSite> metadata = new LinkedHashMap<String, CallSite>();
                        metadata.put("id", (CallSite)((Object)(CronappOpenApiConsts.ODATA_REST_PREFIX + "/" + datasourceId + "('_objectKey')")));
                        metadata.put("uri", (CallSite)((Object)(CronappOpenApiConsts.ODATA_REST_PREFIX + "/" + datasourceId + "('_objectKey')")));
                        metadata.put("type", (CallSite)((Object)(this.getDatasourceNamespace((JsonElement)datasource) + "." + datasourceId)));
                        exampleBodyDefinition.addProperty("__metadata", metadata);
                    }
                    if ((schema = ODataAgent.getSchema(this.edmSchemas, this.getDatasourceNamespace((JsonElement)datasource), datasourceId)) == null) continue;
                    paramBodyDefinition.setRequired(true);
                    schema.getKeyProperties().forEach(field -> {
                        try {
                            ParameterDefinition paramKey = new ParameterDefinition();
                            paramKey.setType(this.parseType(field.getType().getName()));
                            paramKey.setName(field.getName());
                            paramKey.setIn(CronappOpenApiConsts.PARAMETER_PATH);
                            arrParamKeysDefinition.add(paramKey);
                            exampleBodyDefinition.addProperty(field.getName(), this.getValueBasedOnType(this.parseType(field.getType().getName())));
                        }
                        catch (EdmException e) {
                            logger.error(e.getMessage());
                        }
                    });
                    schema.getPropertyNames().forEach(propName -> {
                        try {
                            EdmTyped field = schema.getProperty(propName);
                            EdmSimplePropertyImplProv props = (EdmSimplePropertyImplProv)field;
                            if (!field.getName().contains("_objectKey") && !props.getProperty().isDisplayField()) {
                                LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
                                param.put("type", this.parseType(field.getType().getName()));
                                param.put("description", field.getName());
                                paramBodyDefinition.addProperty(field.getName(), param);
                                exampleBodyDefinition.addProperty(field.getName(), this.getValueBasedOnType(this.parseType(field.getType().getName())));
                            }
                        }
                        catch (EdmException e) {
                            logger.error(e.getMessage());
                        }
                    });
                    this.addEntityToSchemaModel(datasourceId, paramBodyDefinition, null);
                    paramBodyDefinition.addToMetadataReference(datasourceId);
                    StringBuilder pathParams = new StringBuilder();
                    for (ParameterDefinition param : arrParamKeysDefinition) {
                        pathParams.append("('{" + param.getName() + "}')");
                    }
                    ArrayList<ParameterDefinition> arrParamsDefinition = new ArrayList<ParameterDefinition>();
                    JsonArray paramsArr = datasource.getAsJsonObject().getAsJsonArray("queryParamsValues");
                    for (int i = 0; i < paramsArr.size(); ++i) {
                        JsonObject param = paramsArr.get(i).getAsJsonObject();
                        ParameterDefinition paramDefinition = new ParameterDefinition();
                        paramDefinition.setName(param.get("fieldName").getAsString());
                        paramDefinition.setRequired(false);
                        paramDefinition.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
                        arrParamsDefinition.add(paramDefinition);
                    }
                    if (this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_GET.toUpperCase())) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(datasourceId + CronappOpenApiConsts.ACTION_GET);
                        operation.setTags(tags);
                        ArrayList paramsToJoin = (ArrayList)arrParamsDefinition.clone();
                        paramsToJoin.addAll(this.fillODataDefaultParams());
                        operation.setParameters(paramsToJoin);
                        operation.setSecurity(this.getSecurity());
                        ResponseDefinition response200 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                        response200.setDescription(Messages.getString("swaggerResponseSuccess"));
                        response200.addExample(exampleBodyDefinition.getContentAsModelList());
                        operation.getResponses().putIfAbsent("200", response200);
                        operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                        path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_GET, operation);
                    }
                    if (this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_POST.toUpperCase())) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(datasourceId + CronappOpenApiConsts.ACTION_POST);
                        operation.setTags(tags);
                        operation.setSecurity(this.getSecurity());
                        operation.setParameters(arrParamsDefinition);
                        operation.setRequestBody(paramBodyDefinition);
                        response201 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                        response201.setDescription(Messages.getString("swaggerPostSuccess"));
                        response201.addExample(exampleBodyDefinition.getContent());
                        operation.getResponses().putIfAbsent("201", response201);
                        operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                        path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_POST, operation);
                    }
                    if (this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_PUT.toUpperCase())) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(datasourceId + CronappOpenApiConsts.ACTION_PUT);
                        operation.setTags(tags);
                        operation.setParameters(arrParamsDefinition);
                        operation.setRequestBody(paramBodyDefinition);
                        operation.setSecurity(this.getSecurity());
                        response201 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                        response201.setDescription(Messages.getString("swaggerPostSuccess"));
                        response201.addExample(exampleBodyDefinition.getContent());
                        operation.getResponses().putIfAbsent("201", response201);
                        operation.getResponses().put("500", this.getDefaultServerErrorResponse());
                        operation.setParameters(arrParamKeysDefinition);
                        pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_PUT, operation);
                    }
                    if (this.isDatasourceVerbEnabled((JsonElement)verbs, CronappOpenApiConsts.ACTION_DELETE.toUpperCase())) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(datasourceId + CronappOpenApiConsts.ACTION_DELETE);
                        operation.setTags(tags);
                        operation.setParameters(arrParamKeysDefinition);
                        operation.setSecurity(this.getSecurity());
                        operation.getResponses().put("204", this.getDefaultDeleteResponse());
                        operation.getResponses().put("400", this.getDefaultBadRequestResponse());
                        pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_DELETE, operation);
                    }
                    this.paths.putIfAbsent(String.join((CharSequence)"/", CronappOpenApiConsts.ODATA_REST_PREFIX, schema.getNamespace(), datasourceId), path);
                    this.paths.putIfAbsent(String.join((CharSequence)"/", CronappOpenApiConsts.ODATA_REST_PREFIX, schema.getNamespace(), datasourceId + pathParams.toString()), pathWithParamUrl);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    private void fillBlocklyDefinition() {
        if (this.exposeBlocklys()) {
            Reflections reflections = new Reflections(CronappOpenApiConsts.BLOCKLY_PACKAGE, new Scanner[0]);
            Set allBlocklys = reflections.getTypesAnnotatedWith(CronappSwagger.class);
            for (Class blockly : allBlocklys) {
                CronappSecurity metaSecurity = blockly.getAnnotation(CronappSecurity.class);
                for (int i = 0; i < blockly.getMethods().length; ++i) {
                    PathDefinition path = new PathDefinition();
                    PathDefinition pathWithParamUrl = new PathDefinition();
                    Method method = blockly.getMethods()[i];
                    if (CronappOpenApiConsts.SKIP_METHODS.toLowerCase().contains(method.getName().toLowerCase())) continue;
                    ArrayList<ParameterDefinition> arrParamsDefinition = new ArrayList<ParameterDefinition>();
                    StringBuilder pathParams = new StringBuilder();
                    ParameterBlocklyBodyDefinition paramBodyDefinition = new ParameterBlocklyBodyDefinition(CronappOpenApiConsts.PARAMETER_JSON);
                    for (int j = 0; j < method.getParameterAnnotations().length; ++j) {
                        if (method.getParameterAnnotations()[j].length < 1) continue;
                        for (Annotation parameterAnnotation : method.getParameterAnnotations()[j]) {
                            if (!(parameterAnnotation instanceof ParamMetaData)) continue;
                            ParamMetaData paramMetaData = (ParamMetaData)parameterAnnotation;
                            ParameterDefinition paramDefinition = new ParameterDefinition();
                            paramDefinition.setName(paramMetaData.description());
                            paramDefinition.setRequired(true);
                            paramDefinition.setIn(CronappOpenApiConsts.PARAMETER_PATH);
                            arrParamsDefinition.add(paramDefinition);
                            paramBodyDefinition.addProperty(paramMetaData.description(), "");
                            pathParams.append("/{" + paramMetaData.description() + "}");
                        }
                    }
                    if (!metaSecurity.get().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(method.getName() + CronappOpenApiConsts.ACTION_GET);
                        operation.setParameters(arrParamsDefinition);
                        operation.setTags(blockly.getName().split(","));
                        operation.setSecurity(this.getSecurity());
                        operation.getResponses().put("200", this.getDefaultSuccessResponse());
                        operation.getResponses().put("400", this.getDefaultBadRequestResponse());
                        if (pathParams.length() == 0) {
                            path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_GET, operation);
                        } else {
                            pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_GET, operation);
                        }
                    }
                    if (!metaSecurity.post().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(method.getName() + CronappOpenApiConsts.ACTION_POST);
                        operation.setTags(blockly.getName().split(","));
                        if (pathParams.length() > 0) {
                            operation.setRequestBody(paramBodyDefinition);
                        }
                        operation.setSecurity(this.getSecurity());
                        operation.getResponses().put("200", this.getDefaultSuccessResponse());
                        operation.getResponses().put("400", this.getDefaultBadRequestResponse());
                        path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_POST, operation);
                    }
                    if (!metaSecurity.put().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(method.getName() + CronappOpenApiConsts.ACTION_PUT);
                        operation.setTags(blockly.getName().split(","));
                        if (pathParams.length() > 0) {
                            operation.setRequestBody(paramBodyDefinition);
                        }
                        operation.setTags(blockly.getName().split(","));
                        operation.setSecurity(this.getSecurity());
                        operation.getResponses().put("200", this.getDefaultSuccessResponse());
                        operation.getResponses().put("400", this.getDefaultBadRequestResponse());
                        path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_PUT, operation);
                    }
                    if (!metaSecurity.delete().equals(CronappOpenApiConsts.SECURITY_NONE)) {
                        OperationDefinition operation = new OperationDefinition();
                        operation.setOperationId(method.getName() + CronappOpenApiConsts.ACTION_DELETE);
                        operation.setParameters(arrParamsDefinition);
                        operation.setTags(blockly.getName().split(","));
                        operation.setSecurity(this.getSecurity());
                        operation.getResponses().put("200", this.getDefaultSuccessResponse());
                        operation.getResponses().put("400", this.getDefaultBadRequestResponse());
                        if (pathParams.length() == 0) {
                            path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_DELETE, operation);
                        } else {
                            pathWithParamUrl.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_DELETE, operation);
                        }
                    }
                    this.paths.putIfAbsent(CronappOpenApiConsts.BLOCKLY_REST_PREFIX + blockly.getSimpleName() + ":" + method.getName(), path);
                    this.paths.putIfAbsent(CronappOpenApiConsts.BLOCKLY_REST_PREFIX + blockly.getSimpleName() + ":" + method.getName() + pathParams.toString(), pathWithParamUrl);
                }
            }
        }
    }

    private void fillRestDefinition() {
        new Reflections(CronappOpenApiConsts.BLOCKLY_PACKAGE, new Scanner[]{new MethodAnnotationsScanner()}).getMethodsAnnotatedWith(RequestMapping.class).stream().map(Method::getDeclaringClass).distinct().forEach(this::fillRestClassDefinition);
    }

    /*
     * WARNING - void declaration
     */
    private void fillRestClassDefinition(Class<?> restClass) {
        for (Method restMethod : restClass.getMethods()) {
            void var10_13;
            if (!restMethod.isAnnotationPresent(RequestMapping.class)) continue;
            RequestMapping requestMapping = restMethod.getAnnotation(RequestMapping.class);
            ArrayList<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>();
            Parameter[] parameterArray = restMethod.getParameters();
            int n = parameterArray.length;
            boolean bl = false;
            while (var10_13 < n) {
                Parameter restParameter = parameterArray[var10_13];
                if (restParameter.isAnnotationPresent(RequestParam.class)) {
                    RequestParam requestParam = restParameter.getAnnotation(RequestParam.class);
                    ParameterDefinition parameterDefinition = new ParameterDefinition();
                    parameterDefinition.setName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{requestParam.name(), restParameter.getName()}));
                    parameterDefinition.setRequired(requestParam.required());
                    parameterDefinition.setIn("query");
                    parameterDefinitions.add(parameterDefinition);
                } else if (restParameter.isAnnotationPresent(RequestBody.class)) {
                    RequestBody requestBody = restParameter.getAnnotation(RequestBody.class);
                    ParameterDefinition parameterDefinition = new ParameterDefinition();
                    parameterDefinition.setName(restParameter.getName());
                    parameterDefinition.setRequired(requestBody.required());
                    parameterDefinition.setIn("body");
                    parameterDefinitions.add(parameterDefinition);
                } else if (restParameter.isAnnotationPresent(PathVariable.class)) {
                    PathVariable pathVariable = restParameter.getAnnotation(PathVariable.class);
                    ParameterDefinition parameterDefinition = new ParameterDefinition();
                    parameterDefinition.setName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{pathVariable.name(), restParameter.getName()}));
                    parameterDefinition.setRequired(pathVariable.required());
                    parameterDefinition.setIn("path");
                    parameterDefinitions.add(parameterDefinition);
                } else if (restParameter.isAnnotationPresent(RequestHeader.class)) {
                    RequestHeader requestHeader = restParameter.getAnnotation(RequestHeader.class);
                    ParameterDefinition parameterDefinition = new ParameterDefinition();
                    parameterDefinition.setName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{requestHeader.name(), restParameter.getName()}));
                    parameterDefinition.setRequired(requestHeader.required());
                    parameterDefinition.setIn("header");
                    parameterDefinitions.add(parameterDefinition);
                } else if (restParameter.isAnnotationPresent(RequestPart.class)) {
                    RequestPart requestPart = restParameter.getAnnotation(RequestPart.class);
                    ParameterDefinition parameterDefinition = new ParameterDefinition();
                    parameterDefinition.setName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{requestPart.name(), restParameter.getName()}));
                    parameterDefinition.setRequired(requestPart.required());
                    parameterDefinition.setIn("formData");
                    parameterDefinitions.add(parameterDefinition);
                }
                ++var10_13;
            }
            OperationDefinition operation = new OperationDefinition();
            operation.setOperationId(restClass.getName() + "#" + restMethod.getName());
            operation.setParameters(parameterDefinitions);
            operation.setTags(restClass.getName().split(","));
            operation.setSecurity(this.getSecurity());
            operation.getResponses().put("200", this.getDefaultSuccessResponse());
            operation.getResponses().put("400", this.getDefaultBadRequestResponse());
            PathDefinition path = new PathDefinition();
            for (RequestMethod requestMethod : requestMapping.method()) {
                path.getOperations().putIfAbsent(requestMethod.name().toLowerCase(), operation);
            }
            for (String string : requestMapping.value()) {
                this.paths.putIfAbsent(string, path);
            }
            for (String string : requestMapping.path()) {
                this.paths.putIfAbsent(string, path);
            }
        }
    }

    private void fillSecurityDefinition() {
        if (this.getProjectAuthType().equals(CronappOpenApiConsts.SECURITY_AUTH_TOKEN) || this.getProjectAuthType().equals(CronappOpenApiConsts.SECURITY_AUTH_SSO)) {
            HashMap<String, SecurityDefinition> apiKey = new HashMap<String, SecurityDefinition>();
            SecurityDefinition securityDefinitions = new SecurityDefinition();
            securityDefinitions.setType(CronappOpenApiConsts.SECURITY_SCHEME_AUTH_APIKEY);
            securityDefinitions.setDescription(Messages.getString("swaggerAuthMessage"));
            securityDefinitions.setName(CronappOpenApiConsts.SECURITY_HEADER_NAME);
            securityDefinitions.setIn(CronappOpenApiConsts.PARAMETER_HEADER);
            apiKey.put(AppConfig.getJSON().get("auth").getAsJsonObject().get("type").getAsString(), securityDefinitions);
            this.components.put("securitySchemes", apiKey);
        }
    }

    private void fillComponentODataDefaultParams() {
        HashMap<String, ParameterDefinition> oDataDefault = new HashMap<String, ParameterDefinition>();
        ParameterDefinition pTop = new ParameterDefinition();
        pTop.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
        pTop.setDescription(Messages.getString("swaggerTopParamDescription"));
        pTop.setName("$top");
        pTop.setType("integer");
        oDataDefault.put("top", pTop);
        ParameterDefinition pSkip = new ParameterDefinition();
        pSkip.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
        pSkip.setDescription(Messages.getString("swaggerSkipParamDescription"));
        pSkip.setName("$skip");
        pSkip.setType("integer");
        oDataDefault.put("skip", pSkip);
        ParameterDefinition pFilter = new ParameterDefinition();
        pFilter.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
        pFilter.setDescription(Messages.getString("swaggerSearchParamDescription"));
        pFilter.setName("$filter");
        oDataDefault.put("filter", pFilter);
        ParameterDefinition pFormat = new ParameterDefinition();
        pFormat.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
        pFormat.setDescription(Messages.getString("swaggerFormatParamDescription"));
        pFormat.setName("$format");
        oDataDefault.put("format", pFormat);
        ParameterDefinition pInlineCount = new ParameterDefinition();
        pInlineCount.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
        pInlineCount.setDescription(Messages.getString("swaggerCountParamDescription"));
        pInlineCount.setName("$inlinecount");
        oDataDefault.put("inlinecount", pInlineCount);
        ParameterDefinition pOrderBy = new ParameterDefinition();
        pOrderBy.setIn(CronappOpenApiConsts.PARAMETER_QUERY);
        pOrderBy.setDescription(Messages.getString("swaggerOrderByParamDescription"));
        pOrderBy.setName("$orderby");
        oDataDefault.put("orderby", pOrderBy);
        this.components.put("parameters", oDataDefault);
    }

    private ArrayList<ParameterDefinition> fillODataDefaultParams() {
        ArrayList<ParameterDefinition> arrParamsDefinition = new ArrayList<ParameterDefinition>();
        ParameterDefinition pTop = new ParameterDefinition();
        pTop.setParamByRef("#/components/parameters/top");
        arrParamsDefinition.add(pTop);
        ParameterDefinition pSkip = new ParameterDefinition();
        pSkip.setParamByRef("#/components/parameters/skip");
        arrParamsDefinition.add(pSkip);
        ParameterDefinition pFilter = new ParameterDefinition();
        pFilter.setParamByRef("#/components/parameters/filter");
        arrParamsDefinition.add(pFilter);
        ParameterDefinition pFormat = new ParameterDefinition();
        pFormat.setParamByRef("#/components/parameters/format");
        arrParamsDefinition.add(pFormat);
        ParameterDefinition pInlineCount = new ParameterDefinition();
        pInlineCount.setParamByRef("#/components/parameters/inlinecount");
        arrParamsDefinition.add(pInlineCount);
        ParameterDefinition pOrderBy = new ParameterDefinition();
        pOrderBy.setParamByRef("#/components/parameters/orderby");
        arrParamsDefinition.add(pOrderBy);
        return arrParamsDefinition;
    }

    private ArrayList getSecurity() {
        if (this.hasAuthentication()) {
            HashMap securityType = new HashMap();
            securityType.put(this.getProjectAuthType(), new ArrayList());
            ArrayList security = new ArrayList();
            security.add(securityType);
            return security;
        }
        return null;
    }

    private void fillAuthDefinition() {
        if (!this.exposeAuth()) {
            return;
        }
        if (this.isSSO()) {
            PathDefinition path = new PathDefinition();
            OperationDefinition opr = new OperationDefinition();
            opr.setOperationId("00-cronapp-auth-sso");
            opr.setTags(Messages.getString("swaggerAuthorization").split(","));
            ParameterBodyDefinition body = new ParameterBodyDefinition(CronappOpenApiConsts.MULTIPART_FORMDATA);
            body.setRequired(true);
            LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
            param.put("type", "string");
            param.put("description", Messages.getString("clientId"));
            body.addProperty("client_id", param);
            param = new LinkedHashMap();
            param.put("type", "string");
            param.put("description", Messages.getString("clientSecret"));
            body.addProperty("client_secret", param);
            param = new LinkedHashMap();
            param.put("type", "string");
            param.put("description", Messages.getString("accessToken"));
            body.addProperty("access_token", param);
            opr.setRequestBody(body);
            ResponseDefinition response = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
            response.setDescription(Messages.getString("swaggerLoginSuccess"));
            this.setAuthSuccessExample(response);
            opr.getResponses().putIfAbsent("200", response);
            response = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
            response.setDescription(Messages.getString("loginPasswordInvalid"));
            this.setAuthFailExample(response);
            opr.getResponses().putIfAbsent("401", response);
            response = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
            response.setDescription(Messages.getString("swaggerLoginError"));
            this.setAuthError(response);
            opr.getResponses().putIfAbsent("500", response);
            path.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_POST, opr);
            this.paths.putIfAbsent("/auth/sso", path);
        } else {
            PathDefinition pathAuth = new PathDefinition();
            OperationDefinition oprAuth = new OperationDefinition();
            oprAuth.setOperationId("00-cronapp-auth");
            oprAuth.setTags(Messages.getString("swaggerAuthorization").split(","));
            ParameterBodyDefinition paramBodyDefinition = new ParameterBodyDefinition(CronappOpenApiConsts.MULTIPART_FORMDATA);
            paramBodyDefinition.setRequired(true);
            LinkedHashMap<String, String> paramLogin = new LinkedHashMap<String, String>();
            paramLogin.put("type", "string");
            paramLogin.put("description", Messages.getString("login"));
            paramBodyDefinition.addProperty("username", paramLogin);
            LinkedHashMap<String, String> paramPwd = new LinkedHashMap<String, String>();
            paramPwd.put("type", "string");
            paramPwd.put("description", Messages.getString("password"));
            paramBodyDefinition.addProperty("password", paramPwd);
            oprAuth.setRequestBody(paramBodyDefinition);
            ResponseDefinition response200 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
            response200.setDescription(Messages.getString("swaggerLoginSuccess"));
            this.setAuthSuccessExample(response200);
            oprAuth.getResponses().putIfAbsent("200", response200);
            ResponseDefinition response401 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
            response401.setDescription(Messages.getString("loginPasswordInvalid"));
            this.setAuthFailExample(response401);
            oprAuth.getResponses().putIfAbsent("401", response401);
            pathAuth.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_POST, oprAuth);
            this.paths.putIfAbsent("/auth", pathAuth);
        }
        PathDefinition pathRefresh = new PathDefinition();
        OperationDefinition oprRefresh = new OperationDefinition();
        oprRefresh.setSecurity(this.getSecurity());
        oprRefresh.setOperationId("01-cronapp-auth");
        oprRefresh.setTags(Messages.getString("swaggerAuthorization").split(","));
        oprRefresh.getResponses().put("200", this.getDefaultSuccessResponse());
        oprRefresh.getResponses().put("400", this.getDefaultBadRequestResponse());
        pathRefresh.getOperations().putIfAbsent(CronappOpenApiConsts.ACTION_GET, oprRefresh);
        this.paths.putIfAbsent("/auth/refresh", pathRefresh);
    }

    private void setAuthSuccessExample(ResponseDefinition response) {
        LinkedHashMap<String, Object> example = new LinkedHashMap<String, Object>();
        example.put("summary", Messages.getString("swaggerAuthExampleMessage"));
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> dataUser = new LinkedHashMap<String, Object>();
        dataUser.put("name", "Administrator");
        dataUser.put("username", "admin");
        dataUser.put("theme", "");
        dataUser.put("picture", "");
        dataUser.put("lockoutEnabled", false);
        dataUser.put("accessFailedCount", 0);
        data.put("user", dataUser);
        data.put("token", "eyJhbGciOiJIUzUxMiJ9.....");
        data.put("expires", Calendar.getInstance().getTimeInMillis());
        data.put("roles", "");
        data.put("root", false);
        data.put("picture", "");
        example.put("value", data);
        response.addExample(example);
    }

    private void setAuthFailExample(ResponseDefinition response) {
        LinkedHashMap<String, Object> example = new LinkedHashMap<String, Object>();
        example.put("summary", Messages.getString("swaggerAuthExampleFailMessage"));
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("timestamp", "2100-01-03T02:10:59.317Z");
        data.put("status", 401);
        data.put("error", "Unauthorized");
        data.put("message", "{\"exception\":\"Erro durante o processo de autentica\u00e7\u00e3o: Usu\u00e1rio n\u00e3o encontrado!\",\"timestamp\":1654222259300}");
        data.put("path", "/path");
        example.put("value", data);
        response.addExample(example);
    }

    private void setAuthError(ResponseDefinition response) {
        LinkedHashMap<String, Object> example = new LinkedHashMap<String, Object>();
        example.put("summary", Messages.getString("swaggerAuthExampleErrorMessage"));
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("error", "Error message");
        data.put("status", 500);
        data.put("method", "POST");
        data.put("stackTrace", "Error stack trace");
        example.put("value", data);
        response.addExample(example);
    }

    private Object getValueBasedOnType(String type) {
        if (type.equals("boolean")) {
            return true;
        }
        if (type.equals("integer")) {
            return Math.round(Math.random());
        }
        if (type.equals("number")) {
            return Math.random();
        }
        return "String - Example";
    }

    private String getNamespace(String fullQname) {
        String[] t = fullQname.split("[.?]");
        if (t.length > 0) {
            return t[0];
        }
        return "app";
    }

    private boolean hasAuthentication() {
        return !AppConfig.getJSON().get("auth").getAsJsonObject().get("type").getAsString().equals(CronappOpenApiConsts.SECURITY_AUTH_NONE);
    }

    private void addEntityToSchemaModel(String entityName, ParameterBodyDefinition paramBodyDefinition, ArrayList<String> requiredFields) {
        HashMap schemas = this.components.get("schemas");
        if (schemas == null) {
            schemas = new HashMap();
        }
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        metadata.put("type", "object");
        if (requiredFields != null && requiredFields.size() > 0) {
            metadata.put("required", requiredFields);
        }
        metadata.put("properties", paramBodyDefinition.getProperties());
        schemas.put(entityName, metadata);
        this.components.put("schemas", schemas);
    }

    private boolean isDatasourceVerbEnabled(JsonElement verbs, String verb) {
        JsonElement verbToCheck = verbs.getAsJsonObject().get(verb);
        JsonElement verbAuthorities = verbs.getAsJsonObject().get(verb + "Authorities");
        JsonArray verbAuthoritiesList = verbAuthorities.isJsonNull() ? new JsonArray() : verbAuthorities.getAsJsonArray();
        return verbToCheck.getAsBoolean() && (verbAuthoritiesList.size() == 0 || verbAuthoritiesList.size() > 0 && !verbAuthoritiesList.get(0).getAsString().equals(CronappOpenApiConsts.SECURITY_NONE));
    }

    private String getDatasourceNamespace(JsonElement datasource) {
        if (!datasource.getAsJsonObject().get("entityFullName").isJsonNull()) {
            return this.getNamespace(datasource.getAsJsonObject().get("entityFullName").getAsString());
        }
        if (!datasource.getAsJsonObject().get("baseEntity").isJsonNull()) {
            return this.getNamespace(datasource.getAsJsonObject().get("baseEntity").getAsString());
        }
        return null;
    }

    private boolean exposeMetadata() {
        if (AppConfig.getJSON().get("odata") == null) {
            return false;
        }
        return AppConfig.getJSON().get("odata").getAsJsonObject().get("exposeMetadata").getAsBoolean();
    }

    private boolean exposeAuth() {
        if (AppConfig.getJSON().get("openApi") == null) {
            return false;
        }
        return AppConfig.getJSON().get("openApi").getAsJsonObject().get("exposeAuth").getAsBoolean();
    }

    private boolean isSSO() {
        return "SSO".equals(AppConfig.type());
    }

    private boolean exposeEntities() {
        if (AppConfig.getJSON().get("openApi") == null) {
            return false;
        }
        return AppConfig.getJSON().get("openApi").getAsJsonObject().get("exposeEntities").getAsBoolean();
    }

    private boolean exposeDataSources() {
        if (AppConfig.getJSON().get("openApi") == null) {
            return false;
        }
        return AppConfig.getJSON().get("openApi").getAsJsonObject().get("exposeDataSources").getAsBoolean();
    }

    private boolean exposeBlocklys() {
        if (AppConfig.getJSON().get("openApi") == null) {
            return false;
        }
        return AppConfig.getJSON().get("openApi").getAsJsonObject().get("exposeBlocklys").getAsBoolean();
    }

    @JsonIgnore
    public boolean exposeEndpoints() {
        if (AppConfig.getJSON().get("openApi") == null) {
            return false;
        }
        return AppConfig.getJSON().get("openApi").getAsJsonObject().get("exposeEndpoints").getAsBoolean();
    }

    private String getProjectAuthType() {
        return AppConfig.getJSON().get("auth").getAsJsonObject().get("type").getAsString();
    }

    private ResponseDefinition getDefaultSuccessResponse() {
        ResponseDefinition response200 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
        response200.setDescription(Messages.getString("swaggerResponseSuccess"));
        return response200;
    }

    private ResponseDefinition getDefaultDeleteResponse() {
        ResponseDefinition response204 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_TEXT);
        response204.setDescription(Messages.getString("swaggerDeleteResponse"));
        return response204;
    }

    private ResponseDefinition getDefaultBadRequestResponse() {
        ResponseDefinition response400 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
        response400.setDescription(Messages.getString("swaggerResponseError"));
        return response400;
    }

    private ResponseDefinition getDefaultServerErrorResponse() {
        LinkedHashMap example = new LinkedHashMap();
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("code", "-1520");
        LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
        message.put("lang", "en");
        message.put("value", "Resource not found");
        data.put("message", message);
        example.put("error", data);
        ResponseDefinition response500 = new ResponseDefinition(CronappOpenApiConsts.PARAMETER_JSON);
        response500.addExample(example);
        response500.setDescription(Messages.getString("errorNotSpecified"));
        return response500;
    }

    private String parseType(String type) {
        switch (type) {
            case "Boolean": {
                type = "boolean";
                break;
            }
            case "Byte": 
            case "Int16": 
            case "Int32": 
            case "Int64": {
                type = "integer";
                break;
            }
            case "java.lang.Long": {
                type = "integer";
                break;
            }
            case "Double": 
            case "Decimal": {
                type = "number";
                break;
            }
            default: {
                type = "string";
            }
        }
        return type;
    }

    public ArrayList<ServerDefinition> getServers() {
        return this.servers;
    }

    public void setOpenAPi(String openAPi) {
        this.openapi = openAPi;
    }

    public String getOpenapi() {
        return this.openapi;
    }

    public InfoDefinition getInfo() {
        return this.info;
    }

    public void setInfo(InfoDefinition info) {
        this.info = info;
    }

    public LinkedHashMap<String, PathDefinition> getPaths() {
        return this.paths;
    }

    public void setPaths(LinkedHashMap<String, PathDefinition> paths) {
        this.paths = paths;
    }

    public HashMap getComponents() {
        return this.components;
    }
}

