/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest.security;

import cronapi.rest.RestHandlerInterceptor;
import cronapi.rest.security.BlocklySecurity;
import cronapi.rest.security.CronappSecurity;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class CronappSecurityVoter
implements AccessDecisionVoter<FilterInvocation> {
    protected final Log logger = LogFactory.getLog(CronappSecurityVoter.class);
    private final List<HandlerMapping> handlerMappings;

    public CronappSecurityVoter(List<HandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, FilterInvocation filterInvocation, Collection<ConfigAttribute> attributes) {
        HandlerMethod handlerMethod = this.handlerMappings.stream().map(handlerMapping -> {
            try {
                return handlerMapping.getHandler(filterInvocation.getRequest());
            }
            catch (Exception e) {
                this.logger.error((Object)"Handler lookup failed", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).map(HandlerExecutionChain::getHandler).filter(HandlerMethod.class::isInstance).map(HandlerMethod.class::cast).filter(RestHandlerInterceptor::isManaged).findFirst().orElse(null);
        if (handlerMethod == null) {
            return 0;
        }
        return this.vote(handlerMethod, filterInvocation.getRequest());
    }

    private int vote(HandlerMethod handlerMethod, HttpServletRequest request) {
        if (this.checkSecurity(request, handlerMethod)) {
            return 1;
        }
        return -1;
    }

    private boolean checkSecurity(HttpServletRequest request, HandlerMethod handlerMethod) {
        CronappSecurity beanSecurity;
        String requestMethodSecurity;
        String[] authorities;
        Class beanType = handlerMethod.getBeanType();
        String requestMethod = request.getMethod();
        if (StringUtils.equals((String)"HEAD", (String)requestMethod)) {
            requestMethod = "GET";
        }
        if (beanType.isAnnotationPresent(CronappSecurity.class) && !BlocklySecurity.isAuthorized(authorities = (requestMethodSecurity = BlocklySecurity.getRequestMethodSecurity(beanSecurity = beanType.getAnnotation(CronappSecurity.class), requestMethod)).trim().split(";"))) {
            return false;
        }
        Method beanMethod = handlerMethod.getMethod();
        if (beanMethod.isAnnotationPresent(RequestMapping.class)) {
            CronappSecurity beanMethodSecurity = beanMethod.getAnnotation(CronappSecurity.class);
            String requestMethodSecurity2 = BlocklySecurity.getRequestMethodSecurity(beanMethodSecurity, requestMethod);
            String[] authorities2 = requestMethodSecurity2.trim().split(";");
            return BlocklySecurity.isAuthorized(authorities2);
        }
        return true;
    }
}

