/*
 * Decompiled with CFR 0.152.
 */
package cronapi.cloud;

import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.v2.DbxClientV2;
import cronapi.cloud.CloudService;
import cronapi.cloud.DropboxService;
import cronapi.cloud.FieldData;
import cronapi.cloud.FileObject;
import cronapi.cloud.S3Service;
import java.util.List;

public final class CloudFactory {
    private final List<FileObject> files;

    CloudFactory(List<FileObject> files) {
        this.files = files;
    }

    public CloudService send(FieldData fieldData) {
        if ("dropbox".equals(fieldData.data.type())) {
            DbxRequestConfig.Builder builder = DbxRequestConfig.newBuilder((String)"cronapp/app");
            DbxRequestConfig requestConfig = builder.build();
            DbxClientV2 client = new DbxClientV2(requestConfig, fieldData.data.value());
            return new DropboxService(client, this.files);
        }
        if ("S3".equals(fieldData.data.type()) || "cloudservices".equals(fieldData.data.type())) {
            return new S3Service(fieldData, this.files);
        }
        return null;
    }

    public List<FileObject> getFiles() {
        return this.files;
    }
}

