/*
 * Decompiled with CFR 0.152.
 */
package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class ResponseDefinition {
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LinkedHashMap<String, LinkedHashMap> content = new LinkedHashMap();
    private final String type;

    @JsonIgnore
    public ResponseDefinition(String type) {
        this.type = type;
        this.content.put(type, new LinkedHashMap());
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        schema.put("properties", new LinkedHashMap());
        this.content.get(this.type).put("schema", schema);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HashMap getContent() {
        return this.content;
    }

    public void setContent(LinkedHashMap content) {
        this.content = content;
    }

    @JsonIgnore
    public void addProperty(String name, LinkedHashMap definition) {
        LinkedHashMap schema = (LinkedHashMap)this.content.get(this.type).get("schema");
        LinkedHashMap properties = (LinkedHashMap)schema.get("properties");
        properties.put(name, definition);
        schema.put("properties", properties);
        this.content.get(this.type).put("schema", schema);
    }

    @JsonIgnore
    public void addExample(LinkedHashMap definition) {
        this.content.get(this.type).put("example", definition);
    }

    @JsonIgnore
    public void addToMetadataReference(String entityLink) {
        LinkedHashMap<String, CallSite> schema = new LinkedHashMap<String, CallSite>();
        schema.put("$ref", (CallSite)((Object)("#/components/schemas/" + entityLink)));
        this.content.get(this.type).put("schema", schema);
    }
}

