/*
 * Decompiled with CFR 0.152.
 */
package cronapi.list;

import com.google.gson.JsonArray;
import cronapi.Var;
import cronapi.json.JsonArrayWrapper;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.client.utils.CloneUtils;

public class Operations {
    public static final Var newList() {
        return Var.valueOf(new LinkedList());
    }

    private static Var ensureIsList(Var value) {
        if (value == Var.VAR_NULL) {
            return Operations.newList();
        }
        if (value.getObject() instanceof JsonArray) {
            return Var.valueOf(new JsonArrayWrapper((JsonArray)value.getObject()));
        }
        if (value.getObject() instanceof List) {
            return value;
        }
        return Var.valueOf(value.getObjectAsList());
    }

    public static final Var newList(Var ... values) throws Exception {
        LinkedList<Var> linkedList = new LinkedList<Var>();
        for (Var v : values) {
            linkedList.add(v);
        }
        return Var.valueOf(linkedList);
    }

    public static final Var newListRepeat(Var item, Var times) throws Exception {
        LinkedList<Var> linkedList = new LinkedList<Var>();
        for (int i = 0; i < times.getObjectAsInt(); ++i) {
            Object clone = item.cloneObject();
            try {
                clone = CloneUtils.clone((Object)item.getObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
            linkedList.add(new Var(clone));
        }
        return Var.valueOf(linkedList);
    }

    public static final Var size(Var list) {
        list = Operations.ensureIsList(list);
        return Var.valueOf(list.size());
    }

    public static final Var isEmpty(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.size() > 0) {
            return Var.VAR_FALSE;
        }
        return Var.VAR_TRUE;
    }

    public static final Var findFirst(Var list, Var item) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().contains(item)) {
            return Var.valueOf(list.getObjectAsList().indexOf(item) + 1);
        }
        return Var.VAR_ZERO;
    }

    public static final Var findLast(Var list, Var item) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().contains(item)) {
            return Var.valueOf(list.getObjectAsList().lastIndexOf(item) + 1);
        }
        return Var.VAR_ZERO;
    }

    public static final Var get(Var list, Var index) throws Exception {
        list = Operations.ensureIsList(list);
        int indexAsInt = index.getObjectAsInt();
        if (indexAsInt < 1) {
            indexAsInt = 1;
        }
        if (indexAsInt > list.size()) {
            indexAsInt = list.size();
        }
        if (list.getObjectAsList().get(indexAsInt - 1) != Var.VAR_NULL) {
            return Var.valueOf(list.getObjectAsList().get(index.getObjectAsInt() - 1));
        }
        return Var.VAR_NULL;
    }

    public static final Var getFromEnd(Var list, Var index) throws Exception {
        int i;
        Var item = Operations.get(list = Operations.ensureIsList(list), Var.valueOf(i = list.getObjectAsList().size() - index.getObjectAsInt() + 1));
        if (item != Var.VAR_NULL) {
            return Var.valueOf(item);
        }
        return Var.VAR_NULL;
    }

    public static final Var getFirst(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getObjectAsList().size() > 0) {
            return Var.valueOf(list.getObjectAsList().get(0));
        }
        return Var.VAR_NULL;
    }

    public static final Var getLast(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getObjectAsList().size() > 0) {
            return Var.valueOf(list.getObjectAsList().get(list.size() - 1));
        }
        return Var.VAR_NULL;
    }

    public static final Var getRandom(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getObjectAsList().size() > 0) {
            return cronapi.math.Operations.listRandomItem(list);
        }
        return Var.VAR_NULL;
    }

    public static final Var getAndRemove(Var list, Var index) throws Exception {
        Var v;
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && (v = Var.valueOf(Operations.get(list, index))) != Var.VAR_NULL) {
            list.getObjectAsList().remove(v);
            return v;
        }
        return Var.VAR_NULL;
    }

    public static final Var getAndRemoveFromEnd(Var list, Var index) throws Exception {
        Var i;
        Var item;
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && (item = Operations.get(list, i = Var.valueOf(list.getObjectAsList().size() - index.getObjectAsInt()))) != Var.VAR_NULL) {
            list.getObjectAsList().remove(item);
            return item;
        }
        return Var.VAR_NULL;
    }

    public static final Var getAndRemoveFirst(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            Var v = Var.valueOf(list.getObjectAsList().get(0));
            list.getObjectAsList().remove(0);
            return v;
        }
        return Var.VAR_NULL;
    }

    public static final Var getAndRemoveLast(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            Var v = Var.valueOf(list.getObjectAsList().get(list.size() - 1));
            list.getObjectAsList().remove(list.size() - 1);
            return v;
        }
        return Var.VAR_NULL;
    }

    public static final Var getAndRemoveRandom(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            Var v = cronapi.math.Operations.listRandomItem(list);
            list.getObjectAsList().remove(v);
            return v;
        }
        return Var.VAR_NULL;
    }

    public static final Var remove(Var list, Var index) throws Exception {
        Var item;
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && (item = Operations.get(list, index)) != Var.VAR_NULL) {
            return Var.valueOf(list.getObjectAsList().remove(item));
        }
        return Var.VAR_FALSE;
    }

    public static final Var removeFromEnd(Var list, Var index) throws Exception {
        Var i;
        Var item;
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && (item = Operations.get(list, i = Var.valueOf(list.getObjectAsList().size() - index.getObjectAsInt()))) != Var.VAR_NULL) {
            return Var.valueOf(list.getObjectAsList().remove(item));
        }
        return Var.VAR_FALSE;
    }

    public static final Var removeFirst(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            return Var.valueOf(list.getObjectAsList().remove(0));
        }
        return Var.VAR_FALSE;
    }

    public static final Var removeLast(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            return Var.valueOf(list.getObjectAsList().remove(list.size() - 1));
        }
        return Var.VAR_FALSE;
    }

    public static final Var removeRandom(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            int index = cronapi.math.Operations.randomInt(Var.VAR_ZERO, Var.valueOf(list.getObjectAsList().size() - 1)).getObjectAsInt();
            return Var.valueOf(list.getObjectAsList().remove(index));
        }
        return Var.VAR_FALSE;
    }

    public static final Var set(Var list, Var index, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            if (index.getObjectAsInt() < 1) {
                index = Var.valueOf(1);
            }
            if (list.size() >= 0 && index.getObjectAsInt() > list.size()) {
                index = Var.valueOf(list.size());
                Operations.add(list, index, element);
            } else {
                list.getObjectAsList().set(index.getObjectAsInt() - 1, element);
            }
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var setFromEnd(Var list, Var index, Var element) throws Exception {
        list = Operations.ensureIsList(list);
        if (index.getObjectAsInt() <= 1) {
            Operations.set(list, Var.valueOf(list.size()), element);
            return Var.VAR_TRUE;
        }
        if (index.getObjectAsInt() >= list.size()) {
            Operations.set(list, Var.valueOf(1), element);
            return Var.VAR_TRUE;
        }
        Var i = Var.valueOf(list.getObjectAsList().size() - index.getObjectAsInt() + 1);
        Operations.set(list, i, element);
        return Var.VAR_TRUE;
    }

    public static final Var setFirst(Var list, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            Operations.set(list, Var.VAR_ZERO, element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var setLast(Var list, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int index = Math.max(list.getObjectAsList().size(), 1);
            Operations.set(list, Var.valueOf(index), element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var setRandom(Var list, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            int index = cronapi.math.Operations.randomInt(Var.VAR_ZERO, Var.valueOf(list.getObjectAsList().size() - 1)).getObjectAsInt();
            Operations.set(list, Var.valueOf(index), element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var add(Var list, Var index, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            if (index.getObjectAsInt() < 1) {
                index = Var.valueOf(1);
            }
            if (list.size() > 0 && index.getObjectAsInt() > list.size() + 1) {
                index = Var.valueOf(list.size() + 1);
            }
            list.getObjectAsList().add(index.getObjectAsInt() - 1, element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var addFromEnd(Var list, Var index, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() >= index.getObjectAsInt() && list.getObjectAsList().size() - index.getObjectAsInt() >= 0 && index.getObjectAsInt() >= 0) {
            list.getObjectAsList().add(list.getObjectAsList().size() - index.getObjectAsInt(), element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var addFirst(Var list, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            list.getObjectAsList().add(0, element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var addLast(Var list, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)) == Var.VAR_NULL) {
            list = Var.valueOf(new LinkedList());
        }
        if (list.getType() == Var.Type.LIST && list.getObjectAsList().size() >= 0) {
            list.getObjectAsList().add(element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var addRandom(Var list, Var element) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST && list.getObjectAsList().size() > 0) {
            int index = cronapi.math.Operations.randomInt(Var.VAR_ZERO, Var.valueOf(list.getObjectAsList().size() - 1)).getObjectAsInt();
            list.getObjectAsList().add(index, element);
            return Var.VAR_TRUE;
        }
        return Var.VAR_FALSE;
    }

    public static final Var getSublistFromNToN(Var list, Var indexInitial, Var indexFinal) throws Exception {
        list = Operations.ensureIsList(list);
        int start = Operations.getStartIndex(list, indexInitial).getObjectAsInt();
        int end = Operations.getEndIndex(list, indexFinal).getObjectAsInt();
        if (list.getType() == Var.Type.LIST) {
            Var result = Var.valueOf(list.getObjectAsList().subList(start, end));
            return result;
        }
        return Var.newList();
    }

    public static final Var getSublistFromNToEnd(Var list, Var indexInitial, Var indexFinal) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int start = Operations.getStartIndex(list, indexInitial).getObjectAsInt();
            int end = Operations.getEndIndex(list, Var.valueOf(indexFinal.getObjectAsInt() - 1)).getObjectAsInt();
            Var result = Var.valueOf(list.getObjectAsList().subList(start, list.getObjectAsList().size() - end));
            return result;
        }
        return Var.newList();
    }

    public static final Var getSublistFromNToLast(Var list, Var indexInitial) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int start = Operations.getStartIndex(list, indexInitial).getObjectAsInt();
            Var result = Var.valueOf(list.getObjectAsList().subList(start, list.size()));
            return result;
        }
        return Var.newList();
    }

    public static final Var getSublistFromEndToN(Var list, Var indexInitial, Var indexFinal) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int start = Operations.getStartIndex(list, indexInitial).getObjectAsInt();
            int end = Operations.getEndIndex(list, indexFinal).getObjectAsInt();
            return Var.valueOf(list.getObjectAsList().subList(list.size() - start, end));
        }
        return Var.newList();
    }

    public static final Var getSublistFromEndToEnd(Var list, Var indexInitial, Var indexFinal) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int start = Operations.getStartIndex(list, Var.valueOf(list.size() - indexInitial.getObjectAsInt() + 1)).getObjectAsInt();
            int end = Operations.getEndIndex(list, Var.valueOf(list.size() - indexFinal.getObjectAsInt() + 1)).getObjectAsInt();
            return Var.valueOf(list.getObjectAsList().subList(start, end));
        }
        return Var.newList();
    }

    public static final Var getSublistFromEndToLast(Var list, Var indexInitial) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int start = Operations.getStartIndex(list, indexInitial).getObjectAsInt() + 1;
            return Var.valueOf(list.getObjectAsList().subList(list.size() - start, list.size()));
        }
        return Var.newList();
    }

    public static final Var getSublistFromFirstToN(Var list, Var indexFinal) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int end = Operations.getEndIndex(list, indexFinal).getObjectAsInt();
            Var result = Var.valueOf(list.getObjectAsList().subList(0, end));
            return result;
        }
        return Var.newList();
    }

    public static final Var getSublistFromFirstToEnd(Var list, Var indexFinal) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            int end = Operations.getEndIndex(list, Var.valueOf(indexFinal.getObjectAsInt() - 1)).getObjectAsInt();
            Var result = Var.valueOf(list.getObjectAsList().subList(0, list.size() - end));
            return result;
        }
        return Var.newList();
    }

    public static final Var getSublistFromFirstToLast(Var list) throws Exception {
        if ((list = Operations.ensureIsList(list)).getType() == Var.Type.LIST) {
            return list;
        }
        return Var.newList();
    }

    public static final Var getTextFromList(Var list, Var limiter) throws Exception {
        list = Operations.ensureIsList(list);
        Var result = Var.valueOf("");
        for (Object v : list.getObjectAsList()) {
            result.append(Var.valueOf(v).getObjectAsString());
            result.append(limiter.getObjectAsString());
        }
        return Var.valueOf(result.getObjectAsString().substring(0, result.getObjectAsString().length() - 1));
    }

    public static final Var getListFromText(Var text, Var limiter) {
        LinkedList<Var> linked = new LinkedList<Var>();
        if (text.getType() == Var.Type.LIST) {
            for (Object v : text.getObjectAsList()) {
                if (Var.valueOf(v).getObjectAsString().equals(limiter.getObjectAsString())) continue;
                linked.add(Var.valueOf(v));
            }
        } else {
            String[] list;
            for (String s : list = text.getObjectAsString().split(limiter.getObjectAsString())) {
                linked.add(Var.valueOf(s));
            }
        }
        return Var.valueOf(linked);
    }

    public static final Var orderListNumericGrowing(Var list) throws Exception {
        list = Operations.ensureIsList(list);
        list.getObjectAsList().sort((p1, p2) -> Var.valueOf(p1).getObjectAsInt().compareTo(Var.valueOf(p2).getObjectAsInt()));
        return list;
    }

    public static final Var orderListNumericDecreasing(Var list) throws Exception {
        list = Operations.ensureIsList(list);
        list.getObjectAsList().sort((p1, p2) -> Var.valueOf(p2).getObjectAsInt().compareTo(Var.valueOf(p1).getObjectAsInt()));
        return list;
    }

    public static final Var orderListAlphabeticGrowing(Var list) throws Exception {
        list = Operations.ensureIsList(list);
        list.getObjectAsList().sort((p1, p2) -> Var.valueOf(p1).getObjectAsString().compareTo(Var.valueOf(p2).getObjectAsString()));
        return list;
    }

    public static final Var orderListAlphabeticDecreasing(Var list) throws Exception {
        list = Operations.ensureIsList(list);
        list.getObjectAsList().sort((p1, p2) -> Var.valueOf(p2).getObjectAsString().compareTo(Var.valueOf(p1).getObjectAsString()));
        return list;
    }

    public static final Var orderListAlphabeticIgnoreCasesGrowing(Var list) throws Exception {
        list = Operations.ensureIsList(list);
        list.getObjectAsList().sort((p1, p2) -> Var.valueOf(p1).getObjectAsString().compareToIgnoreCase(Var.valueOf(p2).getObjectAsString()));
        return list;
    }

    public static final Var orderListAlphabeticIgnoreCasesDecreasing(Var list) throws Exception {
        list = Operations.ensureIsList(list);
        list.getObjectAsList().sort((p1, p2) -> Var.valueOf(p2).getObjectAsString().compareToIgnoreCase(Var.valueOf(p1).getObjectAsString()));
        return list;
    }

    private static final Var getStartIndex(Var list, Var index) {
        list = Operations.ensureIsList(list);
        if (index.getObjectAsInt() < 0) {
            return Var.valueOf(0);
        }
        if (index.getObjectAsInt() > list.getObjectAsList().size()) {
            return Var.valueOf(list.getObjectAsList().size());
        }
        return Var.valueOf(index.getObjectAsInt() - 1);
    }

    private static final Var getEndIndex(Var list, Var index) {
        list = Operations.ensureIsList(list);
        if (index.getObjectAsInt() < 0) {
            return Var.valueOf(0);
        }
        if (index.getObjectAsInt() > list.getObjectAsList().size()) {
            return Var.valueOf(list.getObjectAsList().size());
        }
        return Var.valueOf(index.getObjectAsInt());
    }
}

