/*
 * Decompiled with CFR 0.152.
 */
package cronapi.pushnotification;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.pushnotification.FirebasePushNotificationService;
import cronapi.pushnotification.HeaderRequestInterceptor;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.http.HttpEntity;
import org.springframework.web.client.RestTemplate;

@CronapiMetaData(category=CronapiMetaData.CategoryType.UTIL, categoryTags={"UTIL", "Util"})
public class Operations {
    @CronapiMetaData(type="function", name="{{firebaseSendNotification}}", nameTags={"SendNotification"}, description="{{firebaseSendNotificationDescription}}")
    public static final void sendNotification(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseServerKey}}") Var serverKey, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{FirebaseTo}}") Var paramTo, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseTitle}}") Var paramTitle, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseSubtitle}}") Var paramSubtitle, @ParamMetaData(type=CronapiMetaData.ObjectType.JSON, description="{{FirebaseData}}") Var paramData) throws Exception {
        JsonObject body = new JsonObject();
        body.addProperty("to", paramTo.getObjectAsString());
        body.addProperty("priority", "high");
        if (!paramTitle.isEmptyOrNull().booleanValue() && !paramSubtitle.isEmptyOrNull().booleanValue()) {
            JsonObject notification = new JsonObject();
            notification.addProperty("title", paramTitle.getObjectAsString());
            notification.addProperty("body", paramSubtitle.getObjectAsString());
            notification.addProperty("icon", "notification_icon");
            body.add("notification", (JsonElement)notification);
        }
        if (!paramData.isNull().booleanValue() && paramData.getObjectAsJson() != null) {
            body.add("data", (JsonElement)paramData.getObjectAsJson().getAsJsonObject());
        }
        HttpEntity request = new HttpEntity((Object)body.toString());
        FirebasePushNotificationService firebaseService = new FirebasePushNotificationService(serverKey.getObjectAsString());
        CompletableFuture<String> pushNotification = firebaseService.send((HttpEntity<String>)request);
        CompletableFuture.allOf(pushNotification).join();
        try {
            String string = pushNotification.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @CronapiMetaData(type="function", name="{{firebaseSendRawNotification}}", nameTags={"SendNotification"}, description="{{firebaseSendRawNotificationDescription}}")
    public static final void sendRawNotification(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{FirebaseServerKey}}") Var serverKey, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{FirebaseTo}}") Var paramTo, @ParamMetaData(type=CronapiMetaData.ObjectType.JSON, description="{{FirebaseBody}}") Var paramBody) throws Exception {
        JsonObject body = (JsonObject)new Gson().fromJson(paramBody.getObjectAsString(), JsonObject.class);
        body.addProperty("to", paramTo.getObjectAsString());
        body.addProperty("priority", "high");
        HttpEntity request = new HttpEntity((Object)body.toString());
        FirebasePushNotificationService firebaseService = new FirebasePushNotificationService(serverKey.getObjectAsString());
        CompletableFuture<String> pushNotification = firebaseService.send((HttpEntity<String>)request);
        CompletableFuture.allOf(pushNotification).join();
        try {
            String string = pushNotification.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @CronapiMetaData(type="function", name="{{firebaseRegister}}", nameTags={"Firebase", "Topic", "Register", "Registrar"}, description="{{firebaseRegisterDescription}}")
    public static void firebaseRegister(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firebaseServerKey}}") Var serverKey, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firebaseTopicName}}") Var topicName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firebaseToken}}") Var token) throws Exception {
        String baseUrl = "https://iid.googleapis.com/iid/v1/";
        String topicUrl = "/rel/topics/";
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<HeaderRequestInterceptor> interceptors = new ArrayList<HeaderRequestInterceptor>();
        interceptors.add(new HeaderRequestInterceptor("Authorization", "key=" + serverKey.toString()));
        interceptors.add(new HeaderRequestInterceptor("Content-Type", "application/json"));
        restTemplate.setInterceptors(interceptors);
        HttpEntity request = new HttpEntity((Object)"");
        if (token.getType().equals((Object)Var.Type.LIST)) {
            for (Object tokenItem : token.getObjectAsList()) {
                String url = baseUrl + Var.valueOf(tokenItem).getObjectAsString() + topicUrl + topicName.getObjectAsString();
                restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            }
        } else {
            String url = baseUrl + token.getObjectAsString() + topicUrl + topicName.getObjectAsString();
            restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        }
    }
}

