/*
 * Decompiled with CFR 0.152.
 */
package cronapi.screen;

import cronapi.ClientCommand;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.RestClient;
import cronapi.TokenUtils;
import cronapi.Var;
import io.jsonwebtoken.Claims;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@CronapiMetaData(category=CronapiMetaData.CategoryType.SCREEN, categoryTags={"Formul\u00e1rio", "Form", "Frontend"})
public class Operations {
    @CronapiMetaData(type="function", name="{{getValueOfFieldName}}", nameTags={"getValueOfField"}, description="{{getValueOfFieldDescription}}", returnType=CronapiMetaData.ObjectType.JSON)
    public static final Var getValueOfField(@ParamMetaData(blockType="field_from_screen", type=CronapiMetaData.ObjectType.STRING, description="{{getValueOfFieldParam0}}") Var field) throws Exception {
        Var result = cronapi.map.Operations.getJsonOrMapField(Var.valueOf(RestClient.getRestClient().getBody().getFields()), field);
        if (result.getObject() instanceof String) {
            result = Var.valueOf(Var.deserialize((String)result.getObject()));
        }
        return result;
    }

    @CronapiMetaData(type="function", name="{{getParamFromQueryString}}", nameTags={"parameter", "Parametro", "request", "requisi\u00e7\u00e3o"}, description="{{getParamDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getParam(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{getValueOfFieldParam0}}") Var name) throws Exception {
        Var result = Var.valueOf(RestClient.getRestClient().getParameter(name.getObjectAsString()));
        if (result.getObject() instanceof String) {
            result = Var.valueOf(Var.deserialize((String)result.getObject()));
        }
        return result;
    }

    @CronapiMetaData(type="function", name="{{getHeader}}", nameTags={"header", "cabe\u00e7alho", "request", "requisi\u00e7\u00e3o"}, description="{{getHeaderDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getHeader(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{getValueOfFieldParam0}}") Var name) throws Exception {
        Var result = Var.valueOf(RestClient.getRestClient().getHeader(name.getObjectAsString()));
        return result;
    }

    @CronapiMetaData(type="function", name="{{getToken}}", nameTags={"token", "requisi\u00e7\u00e3o", "request"}, description="{{getTokenDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getToken() {
        return Var.valueOf(RestClient.getRestClient().getToken());
    }

    @CronapiMetaData(type="function", name="{{getTokenClaim}}", nameTags={"token", "claim"}, description="{{getTokenClaimDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getTokenClaim(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{getTokenClaimKey}}") Var key) {
        Claims claims = TokenUtils.getClaimsFromToken(Operations.getToken().getObjectAsString());
        return Var.valueOf(claims.get((Object)key.getObjectAsString()));
    }

    @CronapiMetaData(type="function", name="{{getTokenClaims}}", nameTags={"token", "claim"}, description="{{getTokenClaimsDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getTokenClaims() {
        Claims claims = TokenUtils.getClaimsFromToken(Operations.getToken().getObjectAsString());
        Var result = Var.valueOf(new HashMap());
        for (Map.Entry entry : claims.entrySet()) {
            result.put(entry.getKey(), Var.valueOf(entry.getValue()));
        }
        return result;
    }

    @CronapiMetaData(type="function", name="{{addTokenClaim}}", nameTags={"token", "claim"}, description="{{addTokenClaimDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final void addTokenClaim(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{addTokenClaimKey}}") Var key, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{addTokenClaimValue}}") Var value) throws Exception {
        boolean fromAuth = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals("cronapp.framework.authentication.token.AuthenticationController") && !element.getClassName().contains("cronapp.framework.authentication.sso")) continue;
            fromAuth = true;
            break;
        }
        if (fromAuth) {
            RestClient.getRestClient().getRequest().setAttribute("CronappToken:" + key.getObjectAsString(), (Object)value.getObjectAsString());
        } else {
            String token = RestClient.getRestClient().getToken();
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                String newToken = TokenUtils.addClaimToToken(token, key.getObjectAsString(), value.getObjectAsString());
                ClientCommand command = new ClientCommand("cronapi.util.setToken");
                command.addParam(newToken);
                RestClient.getRestClient().addCommand(command);
                RestClient.getRestClient().setToken(newToken);
            } else {
                throw new RuntimeException("Token is not in the request");
            }
        }
    }

    @CronapiMetaData(type="function", name="{{getTokenExpiration}}", nameTags={"token", "claim"}, description="{{getTokenExpirationDescription}}", returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var getTokenExpiration() {
        return Var.valueOf(TokenUtils.getClaimsFromToken(Operations.getToken().getObjectAsString()).getExpiration());
    }

    @CronapiMetaData(type="function", name="{{setTokenExpiration}}", nameTags={"token", "claim"}, description="{{setTokenExpirationDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final void setTokenExpiration(@ParamMetaData(type=CronapiMetaData.ObjectType.DATETIME, description="{{setTokenExpirationParam}}") Var value) throws Exception {
        boolean fromAuth = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals("cronapp.framework.authentication.token.AuthenticationController") && !element.getClassName().contains("cronapp.framework.authentication.sso")) continue;
            fromAuth = true;
            break;
        }
        if (fromAuth) {
            RestClient.getRestClient().getRequest().setAttribute("CronappTokenExpiration", (Object)value.getObjectAsDateTime());
        } else {
            String token = RestClient.getRestClient().getToken();
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                String newToken = TokenUtils.setExpiration(token, value.getObjectAsDateTime().getTime());
                ClientCommand command = new ClientCommand("cronapi.util.setToken");
                command.addParam(newToken);
                RestClient.getRestClient().addCommand(command);
                RestClient.getRestClient().setToken(newToken);
            } else {
                throw new RuntimeException("Token is not in the request");
            }
        }
    }
}

