/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest;

import cronapi.CronapiMetaData;
import cronapi.RestClient;
import cronapi.database.TenantService;
import cronapi.database.TransactionManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RestHandlerInterceptor
implements HandlerInterceptor {
    private final TenantService tenantService;

    public RestHandlerInterceptor(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public static boolean isManaged(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        if (!handlerMethod.getMethod().isAnnotationPresent(RequestMapping.class)) {
            return false;
        }
        Class beanType = handlerMethod.getBeanType();
        if (!beanType.isAnnotationPresent(CronapiMetaData.class)) {
            return false;
        }
        CronapiMetaData metadata = beanType.getAnnotation(CronapiMetaData.class);
        return StringUtils.equals((CharSequence)metadata.type(), (CharSequence)"blockly");
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (RestHandlerInterceptor.isManaged(handler)) {
            RestClient.getRestClient().setFilteredEnabled(true);
            RestClient.getRestClient().setTenantService(this.tenantService);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (RestHandlerInterceptor.isManaged(handler)) {
            try {
                if (ex == null) {
                    TransactionManager.commit();
                } else {
                    TransactionManager.rollback();
                }
            }
            finally {
                TransactionManager.close();
                TransactionManager.clear();
            }
        }
    }
}

