/*
 * Decompiled with CFR 0.152.
 */
package cronapi.conversion;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Utils;
import cronapi.Var;
import cronapi.i18n.Messages;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@CronapiMetaData(category=CronapiMetaData.CategoryType.CONVERSION, categoryTags={"Convers\u00e3o", "Convert"})
public class Operations {
    @CronapiMetaData(type="function", name="{{TextToBase64Name}}", nameTags={"TextToBase64"}, description="{{TextToBase64Description}}", params={"{{TextToConvert}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var StringToBase64(Var text) throws Exception {
        String base64 = Base64.getEncoder().encodeToString(text.getObjectAsString().getBytes());
        return new Var(base64);
    }

    @CronapiMetaData(type="function", name="{{base64ToText}}", nameTags={"base64ToString"}, description="{{functionConvertBase64ToText}}", params={"{{contentInBase64}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var base64ToString(Var base64Var) throws Exception {
        if (base64Var.getObject() instanceof String) {
            return new Var(new String(Base64.getDecoder().decode(base64Var.getObjectAsString())));
        }
        byte[] decodedBytes = Base64.getDecoder().decode((byte[])base64Var.getObject());
        return new Var(new String(decodedBytes));
    }

    @CronapiMetaData(type="function", name="{{textToTextBinary}}", nameTags={"asciiToBinary"}, description="{{functionToConvertTextInTextBinary}}", params={"{{contentInAscii}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var asciiToBinary(Var asciiVar) throws Exception {
        byte[] bytes = asciiVar.getObjectAsString().getBytes();
        StringBuilder binary = new StringBuilder();
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int val = b = byArray[i];
            for (int i2 = 0; i2 < 8; ++i2) {
                binary.append((val & 0x80) == 0 ? 0 : 1);
                val <<= 1;
            }
        }
        return new Var(binary.toString());
    }

    @CronapiMetaData(type="function", name="{{textBinaryToText}}", nameTags={"binaryToAscii"}, description="{{functionToConvertTextBinaryToText}}", params={"{{contentInTextBinary}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var binaryToAscii(Var binaryVar) throws Exception {
        BigInteger bg = new BigInteger(binaryVar.getObjectAsString(), 2);
        byte[] bt = bg.toByteArray();
        return new Var(new String(bt));
    }

    @CronapiMetaData(type="function", name="{{convertToBytes}}", nameTags={"toBytes"}, description="{{convertToBytesDescription}}", params={"{{convertToBytesParam0}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var toBytes(Var var) throws Exception {
        return new Var(var.getObjectAsString().getBytes());
    }

    @CronapiMetaData(type="function", name="{{convertToAscii}}", nameTags={"chrToAscii", "convertToAscii"}, description="{{functionToConvertToAscii}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.DOUBLE)
    public static final Var chrToAscii(Var value) throws Exception {
        if (!value.equals(Var.VAR_NULL)) {
            return new Var(value.getObjectAsString().charAt(0));
        }
        return Var.VAR_ZERO;
    }

    @CronapiMetaData(type="function", name="{{convertHexadecimalToInt}}", nameTags={"hexToInt", "hexadecimalToInteger"}, description="{{functionToConvertHexadecimalToInt}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var hexToInt(Var value) {
        return new Var(Long.parseLong(value.getObjectAsString(), 16));
    }

    @CronapiMetaData(type="function", name="{{convertArrayToList}}", nameTags={"arrayToList"}, description="{{functionToConvertArrayToList}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.LIST)
    public static final Var arrayToList(Var arrayVar) throws Exception {
        List<Object> t = Arrays.asList(arrayVar.getObject());
        return new Var(t);
    }

    @CronapiMetaData(type="function", name="{{convertBase64ToBinary}}", nameTags={"base64ToBinary"}, description="{{functionToConvertBase64ToBinary}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var base64ToBinary(Var base64) throws Exception {
        if (!base64.equals(Var.VAR_NULL)) {
            if (base64.getObject() instanceof String) {
                return new Var(Base64.getDecoder().decode(base64.getObjectAsString()));
            }
            byte[] decodedBytes = Base64.getDecoder().decode((byte[])base64.getObject());
            return new Var(decodedBytes);
        }
        return Var.VAR_NULL;
    }

    @CronapiMetaData(type="function", name="{{convertStringToJs}}", nameTags={"stringToJs"}, description="{{functionToConvertStringToJs}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var stringToJs(Var val) throws Exception {
        return new Var(Utils.stringToJs(val.getObjectAsString()));
    }

    @CronapiMetaData(type="function", name="{{convertStringToDate}}", nameTags={"string to date", "para data"}, description="{{functionToConvertStringToDate}}", params={"{{content}}", "{{maskFormat}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var stringToDate(Var val, Var mask) {
        return Operations.stringToDate(val, mask, Var.VAR_NULL);
    }

    @CronapiMetaData(type="function", name="{{convertStringToDateWithTimeZone}}", nameTags={"string to date", "para data"}, description="{{functionToConvertStringToDate}}", params={"{{content}}", "{{maskFormat}}", "{{timezoneFormat}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var stringToDate(Var val, Var mask, Var timeZone) {
        if (mask.isEmptyOrNull().booleanValue()) {
            mask = Var.valueOf(Messages.getString("DateTimeFormat"));
        }
        if (mask.getObjectAsString().equals("DateTimeFormat")) {
            mask = Var.valueOf(Messages.getString("DateTimeFormat"));
        }
        if (mask.getObjectAsString().equals("DateFormat")) {
            mask = Var.valueOf(Messages.getString("DateFormat"));
        }
        return new Var(Utils.toCalendar(val.getObjectAsString(), mask.getObjectAsString(), Utils.toTimeZone(timeZone)));
    }

    @CronapiMetaData(type="function", name="{{convertDecToHex}}", nameTags={"decToHex"}, description="{{functionToConvertDecToHex}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var decToHex(Var value) throws Exception {
        String hex = Long.toHexString(value.getObjectAsInt().intValue());
        return new Var(hex);
    }

    @CronapiMetaData(type="function", name="{{convertToLong}}", nameTags={"toLong"}, description="{{functionToConvertToLong}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var toLong(Var value) throws Exception {
        return new Var(value.getObjectAsLong());
    }

    @CronapiMetaData(type="function", name="{{convertToString}}", nameTags={"toString"}, description="{{functionToConvertToString}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var toString(Var value) throws Exception {
        return new Var(value.getObjectAsString());
    }

    @CronapiMetaData(type="function", name="{{convertToDouble}}", nameTags={"toDouble"}, description="{{functionToConvertToDouble}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.DOUBLE)
    public static final Var toDouble(Var value) throws Exception {
        return new Var(value.getObjectAsDouble());
    }

    @CronapiMetaData(type="function", name="{{toLogic}}", nameTags={"toBoolean"}, description="{{functionConvertToLogic}}", params={"{{content}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var toBoolean(Var var) throws Exception {
        return new Var(Utils.stringToBoolean(var.getObjectAsString()));
    }

    @CronapiMetaData(type="function", name="{{formatDouble}}", nameTags={"DoubleToString"}, description="{{functionformatDouble}}", params={"{{content}}", "{{mask}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.DATETIME)
    public static final Var formatDouble(Var val, Var mask) throws Exception {
        DecimalFormat _formatter = new DecimalFormat(mask.toString());
        return Var.valueOf(_formatter.format(val.getObjectAsDouble()));
    }

    @CronapiMetaData(type="function", name="{{formatDoubleWithLocale}}", nameTags={"DoubleToString"}, description="{{functionformatDoubleWithLocale}}", params={"{{content}}", "{{mask}}", "{{language}}", "{{country}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var formatDoubleWithLocale(Var val, Var mask, Var language, Var country) throws Exception {
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale(language.getObjectAsString(), country.getObjectAsString()));
        DecimalFormat formatter = (DecimalFormat)nf;
        formatter.applyPattern(mask.getObjectAsString());
        return Var.valueOf(formatter.format(val.getObjectAsDouble()));
    }

    @CronapiMetaData(type="function", name="{{convertLongToDate}}", description="{{convertLongToDateDescription}}", returnType=CronapiMetaData.ObjectType.DATETIME)
    public static Var convertLongToDate(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{content}}") Var input) {
        return Var.valueOf(new Date(Long.parseLong(input.getObjectAsString())));
    }

    @CronapiMetaData(type="function", name="{{convert}}", nameTags={"convert", "converter", "convers\u00e3o", "conversion"}, description="{{convertDescription}}", displayInline=true)
    public static Var convert(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{convertValue}}") Var object, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{convertTo}}", blockType="util_dropdown", keys={"STRING", "BOOLEAN", "LONG", "INTEGER", "DOUBLE", "DATETIME", "DATE", "ISODATE", "TIME", "TEXTTIME", "MAP", "JSON", "LIST", "BYTEARRAY", "SHORT"}, values={"{{STRING}}", "{{BOOLEAN}}", "{{LONG}}", "{{INTEGER}}", "{{DOUBLE}}", "{{DATETIME}}", "{{DATE}}", "{{ISODATE}}", "{{TIME}}", "{{TEXTTIME}}", "{{MAP}}", "{{JSON}}", "{{LIST}}", "{{BYTEARRAY}}", "{{SHORT}}"}, defaultValue="STRING") Var type) {
        if (type.equals("STRING")) {
            return Var.valueOf(object.getObjectAsString());
        }
        if (type.equals("BOOLEAN")) {
            return Var.valueOf(object.getObjectAsBoolean());
        }
        if (type.equals("LONG")) {
            return Var.valueOf(object.getObjectAsLong());
        }
        if (type.equals("SHORT")) {
            return Var.valueOf(object.getObjectAsShort());
        }
        if (type.equals("INTEGER")) {
            return Var.valueOf(object.getObjectAsInt());
        }
        if (type.equals("DOUBLE")) {
            return Var.valueOf(object.getObjectAsDouble());
        }
        if (type.equals("DATETIME")) {
            return Var.valueOf(object.getObjectAsDateTime());
        }
        if (type.equals("TEXTTIME")) {
            return Var.valueOf(cronapi.dateTime.Operations.formatDateTime(object, Var.valueOf("HH:mm:ss")));
        }
        if (type.equals("TIME")) {
            Calendar cal = object.getObjectAsDateTime();
            cal.set(5, 1);
            cal.set(2, 0);
            cal.set(1, 1970);
            return Var.valueOf(cal);
        }
        if (type.equals("DATE")) {
            Calendar cal = object.getObjectAsDateTime();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return Var.valueOf(cal);
        }
        if (type.equals("ISODATE")) {
            return Var.valueOf(Var.valueOf(object.getObjectAsDateTime()).toString());
        }
        if (type.equals("MAP")) {
            return Var.valueOf(object.getObjectAsMap());
        }
        if (type.equals("JSON")) {
            return Var.valueOf(object.getObjectAsJson());
        }
        if (type.equals("LIST")) {
            return Var.valueOf(object.getObjectAsList());
        }
        if (type.equals("BYTEARRAY")) {
            return Var.valueOf(object.getObjectAsByteArray());
        }
        return object;
    }
}

