/*
 * Decompiled with CFR 0.152.
 */
package cronapi.serialization;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.google.gson.JsonElement;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.SecurityBeanFilter;
import cronapi.Utils;
import cronapi.Var;
import cronapi.serialization.CronappVirtualBeanPropertyWriter;
import cronapi.util.StorageService;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CronappBeanSerializerModifier
extends BeanSerializerModifier {
    private boolean enableFilter = true;

    public CronappBeanSerializerModifier() {
    }

    public CronappBeanSerializerModifier(boolean enableFilter) {
        this.enableFilter = enableFilter;
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (serializer instanceof BeanSerializer) {
            return new UserEventDeserializer((BeanSerializerBase)serializer);
        }
        return serializer;
    }

    public class UserEventDeserializer
    extends BeanSerializer {
        protected UserEventDeserializer(BeanSerializerBase src) {
            super(src);
        }

        protected void serializeFieldsFiltered(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this.serializeFields(bean, gen, provider);
        }

        private void processByteHeaderSignatueFields(Object bean) {
            List<String> fields = Utils.getFieldsWithAnnotationByteHeaderSignature(bean);
            for (String field : fields) {
                Object value = Utils.getFieldValue(bean, field);
                byte[] header = StorageService.getFileBytesMetadata((byte[])value);
                if (header == null) continue;
                Utils.updateField(bean, field, header);
            }
        }

        protected void serializeFields(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (!CronappBeanSerializerModifier.this.enableFilter) {
                super.serializeFields(bean, gen, provider);
            } else {
                int i;
                BeanPropertyWriter[] props;
                LinkedList<CronappVirtualBeanPropertyWriter> addProperties = null;
                LinkedHashMap newProperties = null;
                Class<?> clazzToCheck = null;
                if (bean != null) {
                    clazzToCheck = bean.getClass();
                }
                if (RestClient.getRestClient() != null && RestClient.getRestClient().getRequest() != null) {
                    newProperties = (LinkedHashMap)RestClient.getRestClient().getRequest().getAttribute("NewBeanProperty");
                }
                if (newProperties != null && this._props.length > 0 && bean != null) {
                    for (Map.Entry entry : newProperties.entrySet()) {
                        if (!((String)entry.getKey()).startsWith(bean.getClass().getCanonicalName() + ".")) continue;
                        String field = ((String)entry.getKey()).substring(((String)entry.getKey()).lastIndexOf(".") + 1);
                        Var value = Var.VAR_NULL;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            value = Var.valueOf(entry.getValue());
                        } else {
                            try {
                                value = QueryManager.doExecuteBlockly(((JsonElement)entry.getValue()).getAsJsonObject(), RestClient.getRestClient().getMethod(), Var.valueOf(bean));
                            }
                            catch (Exception e) {
                                value = Var.valueOf("ERROR: " + e.getMessage());
                            }
                        }
                        if (addProperties == null) {
                            addProperties = new LinkedList<CronappVirtualBeanPropertyWriter>();
                        }
                        CronappVirtualBeanPropertyWriter beanPropertyWriter = new CronappVirtualBeanPropertyWriter(this._props[0], field, value);
                        addProperties.add(beanPropertyWriter);
                    }
                }
                if (addProperties != null) {
                    props = Arrays.copyOf(this._props, this._props.length + addProperties.size());
                    for (int i2 = 0; i2 < addProperties.size(); ++i2) {
                        props[this._props.length + i2] = (BeanPropertyWriter)addProperties.get(i2);
                    }
                } else {
                    props = this._props;
                }
                this.processByteHeaderSignatueFields(bean);
                try {
                    int len = props.length;
                    for (i = 0; i < len; ++i) {
                        BeanPropertyWriter prop;
                        if (!SecurityBeanFilter.includeProperty(clazzToCheck, props[i].getName(), "GET") || (prop = props[i]) == null) continue;
                        prop.serializeAsField(bean, gen, provider);
                    }
                    if (this._anyGetterWriter != null) {
                        this._anyGetterWriter.getAndSerialize(bean, gen, provider);
                    }
                }
                catch (Exception e) {
                    String name = i == props.length ? "[anySetter]" : props[i].getName();
                    this.wrapAndThrow(provider, e, bean, name);
                }
                catch (StackOverflowError e) {
                    JsonMappingException mapE = new JsonMappingException("Infinite recursion (StackOverflowError)", (Throwable)e);
                    String name = i == props.length ? "[anySetter]" : props[i].getName();
                    mapE.prependPath(new JsonMappingException.Reference(bean, name));
                    throw mapE;
                }
            }
        }
    }
}

