/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.ErrorResponse;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.dashboard.DashboardFront;
import cronapi.dashboard.DashboardService;
import cronapi.i18n.Messages;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rest"})
public class DashboardREST {
    private static final Logger log = LoggerFactory.getLogger(DashboardREST.class);
    private DashboardService dashboardService;

    @Autowired
    public DashboardREST(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<DashboardFront> getReport(@RequestBody DashboardFront dashboardFront) {
        if (dashboardFront == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Error", new String[]{"Dashboard is null"})).body((Object)new DashboardFront());
        }
        log.debug("Get dashboard [" + String.valueOf(dashboardFront) + "].");
        DashboardFront Result = this.dashboardService.getDashboard(dashboardFront.getDashboardName());
        return ResponseEntity.ok().body((Object)Result);
    }

    @RequestMapping(value={"/dashboard/contentasstring"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ResponseEntity<String> getContentAsString(@RequestBody DashboardFront dashboardFront, HttpServletResponse response) {
        if (dashboardFront == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Error", new String[]{"Dashboard is null"})).body((Object)"Error read content file");
        }
        String dashboardName = dashboardFront.getDashboardName();
        log.info("contentasstring");
        log.debug("Print dashboard [" + dashboardName + "]");
        response.setHeader("Content-Disposition", "inline; filename=" + dashboardName);
        response.setContentType("application/plain");
        String dashboardResult = this.dashboardService.getContentDashboard(dashboardName);
        ResponseEntity error = this.checkSecurity(dashboardResult);
        if (error != null) {
            return error;
        }
        return ResponseEntity.ok().body((Object)dashboardResult);
    }

    private ResponseEntity checkSecurity(String dashboardName) {
        String security;
        JsonElement getValue;
        JsonObject reportsJson = (JsonObject)new JsonParser().parse(dashboardName);
        JsonElement reportsConfig = reportsJson.get("reportConfig");
        if (!QueryManager.isNull(reportsConfig) && !QueryManager.isNull(reportsConfig.getAsJsonObject().get("restSecurity")) && !QueryManager.isNull(getValue = reportsConfig.getAsJsonObject().get("restSecurity").getAsJsonObject().get("get")) && StringUtils.isNotEmpty((CharSequence)(security = getValue.getAsJsonPrimitive().getAsString()))) {
            String[] roles;
            boolean authorized = false;
            block0: for (String role : roles = security.split(",")) {
                for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                    if (!role.trim().equalsIgnoreCase(authority.getAuthority())) continue;
                    authorized = true;
                    continue block0;
                }
            }
            if (!authorized) {
                JsonObject error = new JsonObject();
                error.addProperty("error", Messages.getString("notAllowed"));
                return ResponseEntity.status((int)403).body((Object)error.toString());
            }
        }
        return null;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

