/*
 * Decompiled with CFR 0.152.
 */
package cronapi.cloud;

import cronapi.cloud.CloudFactory;
import cronapi.cloud.FileObject;
import cronapi.util.Operations;
import cronapi.util.StorageService;
import cronapi.util.StorageServiceFileObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudManager {
    private static final Logger log = LoggerFactory.getLogger(CloudManager.class);
    public static final String DATA_BASE_64 = "data:%s;base64, ";
    public static final String REGEX_IMAGE = "image/\\w+";
    private Object sourceObject;
    private String[] ids;
    private String fieldName;

    private CloudManager() {
    }

    public static CloudManager newInstance() {
        return new CloudManager();
    }

    public CloudManager byEntity(Object sourceObject) {
        this.sourceObject = sourceObject;
        return this;
    }

    public CloudManager byID(String ... ids) {
        this.ids = ids;
        return this;
    }

    public CloudManager toField(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public CloudFactory build() {
        ByteArrayInputStream fileContent = new ByteArrayInputStream(new byte[0]);
        Class<?> aClass = this.sourceObject.getClass();
        ArrayList<FileObject> files = new ArrayList<FileObject>(10);
        try {
            Field field = aClass.getDeclaredField(this.fieldName);
            field.setAccessible(true);
            Object valueField = field.get(this.sourceObject);
            Object value = null;
            String fileExtension = null;
            if (valueField instanceof String && this.isBase64Encoded((String)valueField)) {
                value = this.getBytesFromBase64((String)valueField);
            } else if (valueField instanceof String && StorageService.isTempFileJson(valueField.toString())) {
                StorageServiceFileObject fileObject = StorageService.getFileObjectFromTempDirectory(valueField.toString());
                value = fileObject.bytes;
                fileExtension = fileObject.extension.substring(1);
            } else {
                value = valueField;
            }
            if (value instanceof byte[]) {
                fileContent = new ByteArrayInputStream((byte[])value);
                if (fileExtension == null) {
                    fileExtension = this.getExtensionFromContent(fileContent);
                }
                String filePath = aClass.getSimpleName().concat("/").concat(field.getName()).concat("/");
                String identify = "";
                for (String id : this.ids) {
                    if (!identify.isEmpty()) {
                        identify = identify.concat("-");
                    }
                    Field declaredId = aClass.getDeclaredField(id);
                    declaredId.setAccessible(true);
                    Object content = declaredId.get(this.sourceObject);
                    Object contentAsString = content == null ? "randonGen" + String.valueOf(Operations.generateUUID()) : String.valueOf(content);
                    identify = identify.concat(id).concat("-").concat((String)contentAsString);
                }
                identify = identify.concat(".").concat(fileExtension);
                files.add(new FileObject("/".concat(filePath).concat(identify), this.fieldName, fileContent));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new CloudFactory(files);
    }

    private String getExtensionFromContent(InputStream fileContent) {
        String contentType = "image/png";
        try {
            contentType = URLConnection.guessContentTypeFromStream(fileContent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String fileExtension = "png";
        if (contentType != null && contentType.contains("/")) {
            fileExtension = contentType.split("/")[1];
        }
        return fileExtension;
    }

    private boolean isBase64Encoded(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            this.getBytesFromBase64(value);
            return this.getRawStringByte(value).replace(" ", "").length() % 4 == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte[] getBytesFromBase64(String value) {
        value = this.getRawStringByte(value);
        return Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
    }

    private String getRawStringByte(String value) {
        Matcher m = Pattern.compile(REGEX_IMAGE).matcher(value);
        while (m.find()) {
            value = value.replace(String.format(DATA_BASE_64, m.group()), "");
        }
        return value;
    }
}

