/*
 * Decompiled with CFR 0.152.
 */
package cronapi.io;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.RestClient;
import cronapi.Utils;
import cronapi.Var;
import cronapi.rest.DownloadREST;
import cronapi.util.Callback;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@CronapiMetaData(category=CronapiMetaData.CategoryType.IO, categoryTags={"Arquivo", "File"})
public class Operations {
    private static String APP_FOLDER;
    private static String CLASSES_FOLDER;

    @CronapiMetaData(type="function", name="{{createFolder}}", nameTags={"createFolder"}, description="{{functionToCreateNewFolder}}", params={"{{pathMustBeCreatedForFolder}}", "{{folderName}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var folderCreate(Var path, Var folderName) throws Exception {
        boolean success = true;
        String folder = path.getObjectAsString().trim() + File.separator + folderName.getObjectAsString().trim();
        File dir = new File(folder);
        if (!dir.exists()) {
            success = dir.mkdirs();
            return new Var(success);
        }
        return Var.VAR_FALSE;
    }

    @CronapiMetaData(type="function", name="{{MD5OfFile}}", nameTags={"fileMD5"}, description="{{functionToReturnMD5OfFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileMD5(Var path) throws Exception {
        return new Var(Utils.encodeMD5(new File(path.getObjectAsString().trim())));
    }

    @CronapiMetaData(type="function", name="{{removeFolderFiles}}", nameTags={"removeFolder", "deleteFolder"}, description="{{functionToRemoveFolderFiles}}", params={"{{pathOfFolder}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileRemoveAllFolder(Var path) throws Exception {
        File dir = new File(path.getObjectAsString().trim());
        return new Var(Utils.deleteFolder(dir));
    }

    @CronapiMetaData(type="function", name="{{canReadyFile}}", nameTags={"fileCanRead"}, description="{{functionToCheckIfCanReadFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileCanRead(Var path) throws Exception {
        File file = new File(path.getObjectAsString().trim());
        return new Var(file.canRead());
    }

    @CronapiMetaData(type="function", name="{{canWriteFile}}", nameTags={"fileCanWrite"}, description="{{functionToCheckIfCanWriteFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileCanWrite(Var path) throws Exception {
        File file = new File(path.getObjectAsString().trim());
        return new Var(file.canWrite());
    }

    @CronapiMetaData(type="function", name="{{createNewFile}}", nameTags={"fileCreate"}, description="{{functionToCreateFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING})
    public static final void fileCreate(Var path) throws Exception {
        if (!Files.exists(Paths.get(path.getObjectAsString().trim(), new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            Files.createFile(Paths.get(path.getObjectAsString().trim(), new String[0]), new FileAttribute[0]);
        }
    }

    @CronapiMetaData(type="function", name="{{removeFile}}", nameTags={"fileRemove"}, description="{{functionToRemoveFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileRemove(Var path) throws Exception {
        Path p = Paths.get(path.getObjectAsString().trim(), new String[0]);
        return new Var(Files.deleteIfExists(p));
    }

    @CronapiMetaData(type="function", name="{{fileExists}}", nameTags={"fileExists"}, description="{{functionToCheckIfExistFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileExists(Var path) throws Exception {
        Path p = Paths.get(path.getObjectAsString().trim(), new String[0]);
        return new Var(Files.exists(p, LinkOption.NOFOLLOW_LINKS));
    }

    @CronapiMetaData(type="function", name="{{copyFile}}", nameTags={"fileCopy"}, description="{{functionToCopyFile}}", params={"{{sourcePath}}", "{{destinationPath}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING})
    public static final void fileCopy(Var pathFrom, Var pathTo) throws Exception {
        File from = new File(pathFrom.getObjectAsString().trim());
        File to = new File(pathTo.getObjectAsString().trim());
        Utils.copyFileTo(from, to);
    }

    @CronapiMetaData(type="function", name="{{getParentOfFile}}", nameTags={"fileGetParent"}, description="{{functionToGetParentOfFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileGetParent(Var path) throws Exception {
        File file = new File(path.getObjectAsString().trim());
        if (file.exists()) {
            return new Var(file.getParent());
        }
        return new Var(null);
    }

    @CronapiMetaData(type="function", name="{{renameFile}}", nameTags={"fileRename"}, description="{{functionToRenameFile}}", params={"{{pathOfFile}}", "{{newNameOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileRename(Var path, Var name) throws Exception {
        File from = new File(path.getObjectAsString().trim());
        File to = new File(from.getParentFile(), name.getObjectAsString().trim());
        return new Var(from.renameTo(to));
    }

    @CronapiMetaData(type="function", name="{{moveFile}}", nameTags={"fileMove"}, description="{{functionToMoveFile}}", params={"{{pathOfSourceFile}}", "{{pathOfDestinationFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var fileMove(Var pathFrom, Var pathTo) throws Exception {
        File toFolder;
        File from = new File(pathFrom.getObjectAsString().trim());
        File to = toFolder = new File(pathTo.getObjectAsString().trim());
        if (toFolder.isDirectory()) {
            to = new File(toFolder, from.getName());
        }
        Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return Var.VAR_TRUE;
    }

    @CronapiMetaData(type="function", name="{{openFileToWrite}}", nameTags={"fileOpenToWrite"}, description="{{functionToOpenFileToWrite}}", params={"{{pathOfFile}}", "{{addText}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var fileOpenToWrite(Var url, Var append) throws Exception {
        if (!append.equals(Var.VAR_NULL)) {
            FileOutputStream out = new FileOutputStream(new File(url.getObjectAsString()));
            out.write(append.getObjectAsString().getBytes());
            return new Var(out);
        }
        FileOutputStream out = new FileOutputStream(new File(url.getObjectAsString()));
        return new Var(out);
    }

    @CronapiMetaData(type="function", name="{{openFileToRead}}", nameTags={"fileOpenToRead"}, description="{{functionToOpenFileToRead}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var fileOpenToRead(Var url) throws Exception {
        FileInputStream in = new FileInputStream(new File(url.getObjectAsString()));
        return new Var(in);
    }

    @CronapiMetaData(type="function", name="{{addContentToFile}}", nameTags={"fileAppend"}, description="{{functionToAddContentToFile}}", params={"{{streamOfFileToWrite}}", "{{contentOfFile}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.OBJECT})
    public static final void fileAppend(Var outPut, Var content) throws Exception {
        FileOutputStream out = (FileOutputStream)outPut.getObject();
        if (content.getObject() instanceof byte[]) {
            out.write((byte[])content.getObject());
        } else {
            out.write(content.getObjectAsString().getBytes());
        }
    }

    @CronapiMetaData(type="function", name="{{readContentOfFile}}", nameTags={"fileRead"}, description="{{functionToReadContentOfFile}}", params={"{{streamOfFileToRead}}", "{{sizeInBytes}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.LONG}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileRead(Var input, Var size) throws Exception {
        byte[] byteSizeToRead = new byte[size.getObjectAsInt().intValue()];
        FileInputStream in = (FileInputStream)input.getObject();
        int bytes = in.read(byteSizeToRead);
        return new Var(new String(byteSizeToRead, 0, bytes));
    }

    @CronapiMetaData(type="function", name="{{readAllContentOfFile}}", nameTags={"fileReadAll"}, description="{{functionToReadAllContentOfFile}}", params={"{{streamOfFileToRead}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileReadAll(Var input) throws Exception {
        FileInputStream in = (FileInputStream)input.getObject();
        return new Var(Utils.getFileContent(in).toString());
    }

    @CronapiMetaData(type="function", name="{{readLineOfFile}}", nameTags={"fileReadLine"}, description="{{functionToReadLineOfFile}}", params={"{{streamOfFileToRead}}", "{{callBackStatements}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STATEMENTSENDER})
    public static final void readLine(Var input, Callback callback) throws Exception {
        cronapi.util.Operations.readLinesFromStream(input, callback);
    }

    @CronapiMetaData(type="function", name="{{readBytesFromStreamName}}", nameTags={"readBytesFromStream"}, description="{{readBytesFromStreamDescription}}", params={"{{readBytesFromStreamParam0}}", "{{readBytesFromStreamParam1}}", "{{callBackStatements}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.STATEMENTSENDER})
    public static void readBytesFromStream(Var input, Var size, Callback callback) throws Exception {
        cronapi.util.Operations.readBytesFromStream(input, size, callback);
    }

    @CronapiMetaData(type="function", name="{{clearFile}}", nameTags={"fileFlush"}, description="{{functionToClearFile}}", params={"{{streamOfFileToWrite}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT})
    public static final void fileFlush(Var input) throws Exception {
        FileOutputStream fos = (FileOutputStream)input.getObject();
        fos.flush();
    }

    @CronapiMetaData(type="function", name="{{closeFile}}", nameTags={"fileClose"}, description="{{functionToCloseFile}}", params={"{{streamOfFile}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT})
    public static final void fileClose(Var input) throws Exception {
        if (input.getObject() instanceof FileOutputStream) {
            FileOutputStream fos = (FileOutputStream)input.getObject();
            fos.flush();
            fos.close();
        } else {
            FileInputStream fis = (FileInputStream)input.getObject();
            fis.close();
        }
    }

    @CronapiMetaData(type="function", name="{{applicationTemporaryFolder}}", nameTags={"fileTempDir"}, description="{{functionToReturnApplicationTemporaryFolder}}", params={}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileTempDir() throws Exception {
        return new Var(System.getProperty("java.io.tmpdir"));
    }

    @CronapiMetaData(type="function", name="{{applicationFolder}}", nameTags={"fileTempDir"}, description="{{functionToReturnApplicationFolder}}", params={}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileAppDir() throws Exception {
        return new Var(APP_FOLDER);
    }

    @CronapiMetaData(type="function", name="{{applicationRecycleFolder}}", nameTags={"fileTempDir"}, description="{{functionToReturnApplicationRecycleFolder}}", params={}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileAppReclycleDir() throws Exception {
        return new Var(DownloadREST.TEMP_FOLDER.getAbsolutePath());
    }

    @CronapiMetaData(type="function", name="{{applicationClassesFolder}}", nameTags={"fileClassesDir"}, description="{{applicationClassesFolderDescription}}", params={}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileAppClassesDir() throws Exception {
        return new Var(CLASSES_FOLDER);
    }

    @CronapiMetaData(type="function", name="{{fileDownloadName}}", nameTags={"fileTempDir"}, description="{{fileDownloadDescription}}", params={"{{fileDownloadParam0}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT})
    public static final void fileDownload(Var varFile) throws Exception {
        RestClient.getRestClient().downloadURL(DownloadREST.getDownloadUrl(varFile.getObjectAsFile()));
    }

    @CronapiMetaData(type="function", name="{{fileDownloadName}}", nameTags={"fileTempDir"}, description="{{fileDownloadDescription}}", params={"{{fileDownloadParam0}}", "{{fileDownloadParam1}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING})
    public static final void fileDownload(Var varFile, Var varLabel) throws Exception {
        if (varFile.getObject() instanceof InputStream) {
            RestClient.getRestClient().downloadURL(DownloadREST.getDownloadUrl(varFile.getTypedObject(InputStream.class), varLabel.getObjectAsString()));
        } else {
            RestClient.getRestClient().downloadURL(DownloadREST.getDownloadUrl(varFile.getObjectAsFile(), varLabel.getObjectAsString()));
        }
    }

    @CronapiMetaData(type="function", name="{{startDownload}}", nameTags={"startDownload"}, description="{{startDownloadDescription}}", params={"{{startDownloadParam0}}", "{{startDownloadParam1}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING})
    public static final void startDownload(Var content, Var nameFile) throws Exception {
        if (content.getObject() instanceof byte[]) {
            Var filePath = Var.valueOf(Operations.fileAppReclycleDir().toString() + Operations.fileSeparator().toString() + UUID.randomUUID().toString() + ".temp");
            Var newFile = Operations.fileOpenToWrite(filePath, Var.VAR_NULL);
            Operations.fileAppend(newFile, content);
            Operations.fileClose(newFile);
            Operations.fileDownload(filePath, nameFile);
        } else {
            Operations.fileDownload(content, nameFile);
        }
    }

    @CronapiMetaData(type="function", name="{{readAllContentFileInBytes}}", nameTags={"fileReadAllToBytes"}, description="{{functionToReadAllContentFileInBytes}}", params={"{{streamOfFileToRead}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var fileReadAllToBytes(Var input) throws Exception {
        FileInputStream fin = (FileInputStream)input.getObject();
        long length = fin.getChannel().size();
        byte[] fileContent = new byte[(int)length];
        fin.read(fileContent);
        fin.close();
        return new Var(fileContent);
    }

    @CronapiMetaData(type="function", name="{{isEndOfFile}}", nameTags={"isFileEoF"}, description="{{functionToCheckIsEndOfFile}}", params={"{{streamOfFileToRead}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var isFileEoF(Var input) throws Exception {
        FileInputStream fis = (FileInputStream)input.getObject();
        return new Var(fis.getChannel().position() == fis.getChannel().size());
    }

    @CronapiMetaData(type="function", name="{{sizeOfFile}}", nameTags={"fileGetSize"}, description="{{functionToGetSizeOfFile}}", params={"{{streamOfFileToRead}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var fileGetSize(Var input) throws Exception {
        FileInputStream fis = (FileInputStream)input.getObject();
        return new Var(fis.getChannel().size());
    }

    @CronapiMetaData(type="function", name="{{isFolder}}", nameTags={"isDirectory", "isFolder"}, description="{{functionToCheckIsFolder}}", params={"{{pathOfFolder}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var isDirectory(Var path) {
        File dir = new File(path.getObjectAsString());
        return new Var(dir.isDirectory());
    }

    @CronapiMetaData(type="function", name="{{totalLinesFile}}", nameTags={"fileGetNumberOfLines"}, description="{{functionToGetTotalLinesFile}}", params={"{{pathOfFile}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.LONG)
    public static final Var fileGetNumberOfLines(Var path) throws Exception {
        Path p = Paths.get(path.getObjectAsString(), new String[0]);
        long lineCount = Files.lines(p).count();
        return new Var(lineCount);
    }

    @CronapiMetaData(type="function", name="{{downloadFileFromUrl}}", nameTags={"downloadFileFromUrl"}, description="{{functionToDownloadFileFromUrl}}", params={"{{URLAddress}}", "{{folderPathToSaveFile}}", "{{nameOfFileFromURL}}", "{{fileExtensionWithDot}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var downloadFileFromUrl(Var urlAddress, Var path, Var name, Var extension) {
        try {
            if (path.isNull().booleanValue() && !name.isNull().booleanValue()) {
                return Operations.downloadUrltoFile(urlAddress, Var.valueOf(name.getObjectAsString() + extension.getObjectAsString()));
            }
            if (!name.isNull().booleanValue()) {
                Object pathLocal = path.getObjectAsString();
                URL url = new URL(urlAddress.getObjectAsString());
                if (!((String)pathLocal).endsWith(File.separator)) {
                    pathLocal = (String)pathLocal + File.separator;
                }
                return Operations.downloadUrltoFile(urlAddress, Var.valueOf((String)pathLocal + name.getObjectAsString() + extension.getObjectAsString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Var(false);
    }

    public static void resolveAuthentication(String urlAddress, URLConnection urlConnection) {
        Pattern pattern = Pattern.compile("https?:\\/\\/(.*?):(.*?)@.*");
        Matcher matcher = pattern.matcher(urlAddress);
        if (matcher.find()) {
            try {
                String user = URLDecoder.decode(matcher.group(1), "UTF8");
                String pass = URLDecoder.decode(matcher.group(2), "UTF8");
                String header = "Basic " + new String(Base64.getEncoder().encode((user + ":" + pass).getBytes()));
                urlConnection.addRequestProperty("Authorization", header);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CronapiMetaData(type="function", name="{{downloadUrltoFile}}", nameTags={"download", "url"}, description="{{functionDownloadUrltoFile}}", returnType=CronapiMetaData.ObjectType.BOOLEAN)
    public static final Var downloadUrltoFile(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{URLAddress}}") Var urlAddress, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{filePathToSaveURL}}") Var file) throws Exception {
        URL url = new URL(urlAddress.getObjectAsString());
        URLConnection urlConnection = url.openConnection();
        Operations.resolveAuthentication(urlAddress.getObjectAsString(), urlConnection);
        try (InputStream is = urlConnection.getInputStream();){
            File outFile = new File(file.getObjectAsString());
            if (outFile.exists()) {
                outFile.delete();
            }
            try (FileOutputStream fos = new FileOutputStream(outFile);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
            }
        }
        return new Var(true);
    }

    @CronapiMetaData(type="function", name="{{readAllFileWithCharset}}", nameTags={"fileReadContentWithCharset"}, description="{{functionToReadAllFileWithCharset}}", params={"{{streamOfFileToRead}}", "{{charset}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileReadContentWithCharset(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{streamOfFileToRead}}") Var finp, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{charset}}", blockType="util_dropdown", keys={"UTF-8", "UTF-16", "US-ASCII", "ISO-8859-1", "ISO-8859-2"}) Var charsetSelected) throws Exception {
        String result = IOUtils.toString((InputStream)((InputStream)finp.getObject()), (String)charsetSelected.getObjectAsString());
        return new Var(result);
    }

    @CronapiMetaData(type="function", name="{{unZipFile}}", nameTags={"unZip"}, description="{{functionToUnZipFile}}", params={"{{streamOfFileToRead}}", "{{destinationFolder}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.STRING})
    public static void unZip(Var zippedFile, Var destFolder) throws Exception {
        FileInputStream zipFile = (FileInputStream)zippedFile.getObject();
        Object outputFolder = destFolder.getObjectAsString();
        if (!((String)outputFolder).endsWith("/")) {
            outputFolder = (String)outputFolder + "/";
        }
        byte[] buffer = new byte[1024];
        ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)zipFile, "UTF-8", true);
        ZipArchiveEntry ze = zis.getNextZipEntry();
        Charset utf8charset = Charset.forName("UTF-8");
        Charset iso88591charset = Charset.forName("ISO-8859-1");
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File((String)outputFolder + fileName);
            if (ze.isDirectory()) {
                new File((String)outputFolder + fileName).mkdirs();
            } else {
                int len;
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    if (newFile.getAbsolutePath().endsWith(".js") || newFile.getAbsolutePath().endsWith(".html") || newFile.getAbsolutePath().endsWith(".htm")) {
                        ByteBuffer inputBuffer = ByteBuffer.wrap(buffer, 0, len);
                        CharBuffer data = utf8charset.decode(inputBuffer);
                        ByteBuffer outputBuffer = iso88591charset.encode(data);
                        fos.write(outputBuffer.array(), 0, outputBuffer.array().length);
                        continue;
                    }
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextZipEntry();
        }
        zis.close();
    }

    @CronapiMetaData(type="function", name="{{zipFile}}", nameTags={"Zip"}, description="{{functionToZipFile}}", params={"{{fileList}}", "{{destinationFolder}}", "{{fileNameToZip}}"}, paramsType={CronapiMetaData.ObjectType.LIST, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING})
    public static void zipFile(Var sourceFiles, Var destFolder, Var zipFileName) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(String.format("%s%s%s", destFolder, File.separator, zipFileName.getObjectAsString()));){
            ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);
            List fileList = sourceFiles.getObjectAsList();
            for (Object file : fileList) {
                int length;
                File fileToZip = new File(file.toString());
                FileInputStream fileInputStream = new FileInputStream(fileToZip);
                ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fileInputStream.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                fileInputStream.close();
            }
            zipOut.close();
        }
    }

    @CronapiMetaData(type="function", name="{{listFilesName}}", nameTags={"listFiles"}, description="{{listFilesDescription}}", returnType=CronapiMetaData.ObjectType.LIST)
    public static Var listFiles(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{listFilesParam0}}") Var path, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{listFilesParam1}}", blockType="util_dropdown", keys={"all", "directories", "files"}, values={"{{all}}", "{{directories}}", "{{files}}"}) Var type) {
        try {
            if (path.equals(Var.VAR_NULL)) {
                return Var.newList();
            }
            switch (type.getObjectAsString()) {
                case "directories": {
                    FileFilter filter = File::isDirectory;
                    return Operations.getFileList(path, filter);
                }
                case "files": {
                    FileFilter filter = File::isFile;
                    return Operations.getFileList(path, filter);
                }
            }
            return Operations.getFileList(path, null);
        }
        catch (Exception e) {
            return Var.newList();
        }
    }

    private static Var getFileList(Var path, FileFilter filter) {
        File[] files = new File(path.getObjectAsString()).listFiles(filter);
        LinkedList<String> result = new LinkedList<String>();
        if (files != null) {
            for (File f : files) {
                result.add(f.getAbsolutePath());
            }
        }
        return new Var(result);
    }

    @CronapiMetaData(type="function", name="{{fileSeparatorName}}", nameTags={"fileSeparator"}, description="{{fileSeparatorDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var fileSeparator() {
        return Var.valueOf(File.separator);
    }

    @CronapiMetaData(type="function", name="{{loadPrivateKey}}", nameTags={"loadPrivateKey"}, description="{{loadPrivateKeyDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT, params={"{{privateKeyFile}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT})
    public static Var loadPrivateKeyFile(Var privateKeyFile) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        byte[] bytes = Files.readAllBytes(Paths.get(privateKeyFile.getObjectAsFile().getPath(), new String[0]));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return Var.valueOf(keyFactory.generatePrivate(keySpec));
    }

    @CronapiMetaData(type="function", name="{{loadPublicKey}}", nameTags={"loadPublicKey"}, description="{{loadPublicKeyDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT, params={"{{publicKeyFile}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT})
    public static Var loadPublicKeyFile(Var publicKeyFile) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        byte[] bytes = Files.readAllBytes(Paths.get(publicKeyFile.getObjectAsFile().getPath(), new String[0]));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return Var.valueOf(keyFactory.generatePublic(keySpec));
    }

    @CronapiMetaData(type="function", name="{{signFile}}", nameTags={"signFile"}, description="{{signFileDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT, params={"{{file}}", "{{privateKey}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.OBJECT})
    public static Var signFile(Var file, Var privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, IOException {
        Signature rsa = Signature.getInstance("SHA1withRSA");
        rsa.initSign(privateKey.getTypedObject(PrivateKey.class));
        rsa.update(file.getObjectAsByteArray());
        File newFile = new File(file.getObjectAsFile().getName() + "signed");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(newFile));
        objectOutputStream.writeObject(rsa.sign());
        objectOutputStream.close();
        return Var.valueOf(newFile);
    }

    @CronapiMetaData(type="function", name="{{verifySignature}}", nameTags={"verifySignature"}, description="{{verifySignatureDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT, params={"{{signedObject}}", "{{signature}}", "{{publicKey}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.OBJECT, CronapiMetaData.ObjectType.OBJECT})
    public static Var verifySignature(Var file, Var publicKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        Signature rsaSignature = Signature.getInstance("SHA1withRSA");
        rsaSignature.initVerify(publicKey.getTypedObject(PublicKey.class));
        rsaSignature.update(file.getObjectAsByteArray());
        return Var.valueOf(rsaSignature.verify(Signature.getInstance("SHA1withRSA").sign()));
    }

    @CronapiMetaData(type="function", name="{{getFileName}}", nameTags={"filename", "file name", "nome do arquivo"}, description="{{getFileNameDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getFileName(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathOfFile}}") Var path) {
        File file = new File(path.getObjectAsString().trim());
        return Var.valueOf(file.getName());
    }

    @CronapiMetaData(type="function", name="{{getFileParent}}", nameTags={"file parent", "parent", "ancestor", "pasta pai"}, description="{{getFileParentDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getParent(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathOfFile}}") Var path) {
        File file = new File(path.getObjectAsString().trim());
        return Var.valueOf(file.getParent());
    }

    @CronapiMetaData(type="function", name="{{toFile}}", nameTags={"file parent", "parent", "ancestor", "pasta pai"}, description="{{toFileDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var toFile(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{folderName}}") Var folder, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fileName}}") Var fileName) {
        File file = new File(new File(folder.getObjectAsString().trim()), fileName.getObjectAsString());
        return Var.valueOf(file.getAbsolutePath());
    }

    @CronapiMetaData(type="function", name="{{getFileExtension}}", nameTags={"file extension", "extension", "extens\u00e3o"}, description="{{getFileExtensionDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getFileExtension(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathOfFile}}") Var path) {
        int fileType = path.getObjectAsString().lastIndexOf(".");
        if (fileType != -1) {
            return Var.valueOf(path.getObjectAsString().substring(fileType + 1).trim());
        }
        return Var.valueOf("");
    }

    @CronapiMetaData(type="function", name="{{ArrayByteToFileName}}", nameTags={"byte array", "arquivo", "criar", "gerar"}, description="{{ArrayByteToFileDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final void fileCreateWithByteArray(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathOfFile}}") Var path, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{byteArray}}") Var byteArray) throws Exception {
        if (!path.equals(Var.VAR_NULL) && !byteArray.equals(Var.VAR_NULL)) {
            FileUtils.writeByteArrayToFile((File)new File(path.getObjectAsString()), (byte[])byteArray.getObjectAsByteArray());
        }
    }

    @CronapiMetaData(name="{{cropImage}}", nameTags={"byte array", "resize", "file", "imagem", "redimensionar"}, description="{{cropImageDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var cropImage(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{cropImageParam1}}") Var input, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{cropImageParam2}}") Var width, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{cropImageParam3}}") Var height) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(input.getObjectAsByteArray()));
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        BufferedImage scaled = bufferedImage.getSubimage(bufferedImage.getWidth() / 2 - width.getObjectAsInt() / 2, bufferedImage.getHeight() / 2 - height.getObjectAsInt() / 2, width.getObjectAsInt(), height.getObjectAsInt());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaled, Operations.getImageFormat(inputStream), out);
        return Var.valueOf(out.toByteArray());
    }

    @CronapiMetaData(name="{{rotateImage}}", nameTags={"byte array", "comprimir", "reduzir", "compress", "shrink", "redimensionar"}, description="{{rotateImageDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var rotateImage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rotateImageParam1}}") Var input, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{rotateImageParam2}}") Var rotation) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(input.getObjectAsByteArray()));
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        double rads = Math.toRadians(rotation.getObjectAsInt().intValue());
        double sin = Math.abs(Math.sin(rads));
        double cos = Math.abs(Math.cos(rads));
        int w = (int)Math.floor((double)bufferedImage.getWidth() * cos + (double)bufferedImage.getHeight() * sin);
        int h = (int)Math.floor((double)bufferedImage.getHeight() * cos + (double)bufferedImage.getWidth() * sin);
        BufferedImage rotatedImage = new BufferedImage(w, h, bufferedImage.getType());
        AffineTransform at = new AffineTransform();
        at.translate((float)w / 2.0f, (float)h / 2.0f);
        at.rotate(rads, 0.0, 0.0);
        at.translate((float)(-bufferedImage.getWidth()) / 2.0f, (float)(-bufferedImage.getHeight()) / 2.0f);
        AffineTransformOp rotateOp = new AffineTransformOp(at, 2);
        rotateOp.filter(bufferedImage, rotatedImage);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)rotatedImage, Operations.getImageFormat(inputStream), out);
        return Var.valueOf(out.toByteArray());
    }

    @CronapiMetaData(name="{{compressImage}}", nameTags={"byte array", "comprimir", "reduzir", "compress", "shrink", "redimensionar"}, description="{{compressImageDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static Var compressImage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{compressImageParam1}}") Var input, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{compressImageParam2}}") Var quality) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(input.getObjectAsByteArray()));
        BufferedImage originalImage = ImageIO.read(inputStream);
        String extension = Operations.getImageFormat(inputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage bufferedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(extension);
        ImageWriter writer = writers.next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        writer.setOutput(ios);
        param.setCompressionMode(2);
        param.setCompressionQuality((float)quality.getObjectAsInt().intValue() / 100.0f);
        writer.write(null, new IIOImage(bufferedImage, null, null), param);
        ios.close();
        writer.dispose();
        return Var.valueOf(out.toByteArray());
    }

    @CronapiMetaData(name="{{resizeImage}}", nameTags={"byte array", "resize", "file", "imagem", "redimensionar"}, description="{{resizeImageDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var resizeImage(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{resizeImageParam1}}") Var input, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{resizeImageParam2}}") Var width, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{resizeImageParam3}}") Var height) throws Exception {
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(input.getObjectAsByteArray()));
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        String extension = Operations.getImageFormat(inputStream);
        BufferedImage bufferedImageResult = Operations.toBufferedImage(bufferedImage.getScaledInstance(width.getObjectAsInt(), height.getObjectAsInt(), 1));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImageResult, extension.replace("image/", ""), out);
        return Var.valueOf(out.toByteArray());
    }

    private static String getImageFormat(InputStream is) throws IOException {
        String imgFormat = "jpg";
        try (ImageInputStream iis = ImageIO.createImageInputStream(is);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                imgFormat = reader.getFormatName();
                reader.setInput(iis);
            }
        }
        return imgFormat;
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bi;
    }

    static {
        try {
            String classesFolder;
            URL urlClasses = Class.forName("SpringBootMain").getProtectionDomain().getCodeSource().getLocation();
            CLASSES_FOLDER = classesFolder = new File(urlClasses.getFile()).getAbsolutePath();
        }
        catch (Exception urlClasses) {
            // empty catch block
        }
        if (System.getProperty("cronos.bin") != null && !System.getProperty("cronos.bin").isEmpty()) {
            APP_FOLDER = new File(System.getProperty("cronos.bin")).getParentFile().toString();
        } else {
            try {
                URL location = Operations.class.getProtectionDomain().getCodeSource().getLocation();
                String file = new File(location.getFile()).getAbsolutePath();
                APP_FOLDER = file.contains("WEB-INF") ? file.substring(0, file.indexOf("WEB-INF") - 1) : new File("").getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

