/*
 * Decompiled with CFR 0.152.
 */
package cronapi.osjava.sj.jndi;

import cronapi.osjava.sj.jndi.ContextBindings;
import cronapi.osjava.sj.jndi.ContextNames;
import cronapi.osjava.sj.jndi.SimpleNameParser;
import cronapi.osjava.sj.jndi.StaticHashtable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public abstract class AbstractContext
implements Cloneable,
Context {
    private static final Hashtable TABLE = new Hashtable();
    private static final Hashtable SUB_CONTEXTS = new Hashtable();
    private Hashtable table = new Hashtable();
    private Hashtable subContexts = new Hashtable();
    private Hashtable env = new Hashtable();
    private NameParser nameParser;
    private Name nameInNamespace = null;
    private boolean nameLock = false;
    private boolean closing;

    protected AbstractContext() {
        this((Hashtable)null);
    }

    protected AbstractContext(Hashtable env) {
        this(env, true, null);
    }

    protected AbstractContext(Hashtable env, boolean systemOverride) {
        this(env, systemOverride, null);
    }

    protected AbstractContext(Hashtable env, NameParser parser) {
        this(env, true, parser);
    }

    protected AbstractContext(boolean systemOverride) {
        this(null, systemOverride, null);
    }

    protected AbstractContext(boolean systemOverride, NameParser parser) {
        this(null, systemOverride, parser);
    }

    protected AbstractContext(NameParser parser) {
        this(null, true, parser);
    }

    protected AbstractContext(Hashtable env, boolean systemOverride, NameParser parser) {
        String shared = null;
        if (env != null) {
            this.env = (Hashtable)env.clone();
            shared = (String)this.env.get("org.osjava.sj.jndi.shared");
        }
        if (systemOverride && System.getProperty("org.osjava.sj.jndi.shared") != null) {
            shared = System.getProperty("org.osjava.sj.jndi.shared");
        }
        if ("true".equals(shared)) {
            this.table = new StaticHashtable(TABLE);
            this.subContexts = new StaticHashtable(SUB_CONTEXTS);
        }
        if (parser == null) {
            try {
                this.nameParser = new SimpleNameParser(this);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        try {
            this.nameInNamespace = this.nameParser.parse("");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    protected AbstractContext(AbstractContext that) {
        this(that.env);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        String stringName = name.toString();
        if (name.size() == 0) {
            AbstractContext ret = null;
            try {
                ret = (AbstractContext)this.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            if (ret != null) {
                return ret;
            }
        }
        if (System.getProperty(stringName) != null) {
            return System.getProperty(stringName);
        }
        if (this.table.containsKey(name.toString())) {
            return this.table.get(name.toString());
        }
        Name objName = name.getPrefix(1);
        if (name.size() > 1) {
            if (this.subContexts.containsKey(objName)) {
                return ((Context)this.subContexts.get(objName)).lookup(name.getSuffix(1));
            }
            throw new NamingException("Invalid subcontext '" + objName.toString() + "' in context '" + this.getNameInNamespace() + "'");
        }
        if (this.table.containsKey(name)) {
            return this.table.get(objName);
        }
        if (this.subContexts.containsKey(name)) {
            return this.subContexts.get(name);
        }
        if (this.env.containsKey(name)) {
            return this.env.get(name.toString());
        }
        return null;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.nameParser.parse(name));
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        Name prefix;
        if (name.size() > 1 && this.subContexts.containsKey(prefix = name.getPrefix(1))) {
            ((Context)this.subContexts.get(prefix)).bind(name.getSuffix(1), object);
            return;
        }
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot bind to an empty name");
        }
        if (this.table.containsKey(name) || this.subContexts.containsKey(name) || this.env.containsKey(name.toString())) {
            throw new NameAlreadyBoundException("Name " + name.toString() + " already bound.  Use rebind() to override");
        }
        if (object instanceof Context) {
            this.subContexts.put(name, object);
        } else {
            this.table.put(name.toString(), object);
        }
    }

    @Override
    public void bind(String name, Object object) throws NamingException {
        this.bind(this.nameParser.parse(name), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        Object targetContext = this.lookup(name.getPrefix(name.size() - 1));
        if (targetContext == null || !(targetContext instanceof Context)) {
            throw new NamingException("Cannot bind object.  Target context does not exist.");
        }
        this.unbind(name);
        this.bind(name, object);
    }

    @Override
    public void rebind(String name, Object object) throws NamingException {
        this.rebind(this.nameParser.parse(name), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind to empty name");
        }
        if (name.size() == 1) {
            if (this.table.containsKey(name)) {
                this.table.remove(name);
            }
            return;
        }
        Object targetContext = this.lookup(name.getPrefix(name.size() - 1));
        if (targetContext == null || !(targetContext instanceof Context)) {
            throw new NamingException("Cannot unbind object.  Target context does not exist.");
        }
        ((Context)targetContext).unbind(name.getSuffix(name.size() - 1));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.nameParser.parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object old = this.lookup(oldName);
        if (newName.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        if (old == null) {
            throw new NamingException("Name '" + String.valueOf(oldName) + "' not found.");
        }
        if (this.lookup(newName) != null) {
            throw new NameAlreadyBoundException("Name '" + String.valueOf(newName) + "' already bound");
        }
        this.unbind(oldName);
        this.unbind(newName);
        this.bind(newName, old);
        if (old instanceof Thread) {
            ((Thread)old).setName(newName.toString());
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.nameParser.parse(oldName), this.nameParser.parse(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null || name.isEmpty()) {
            HashMap enumStore = new HashMap();
            enumStore.putAll(this.table);
            enumStore.putAll(this.subContexts);
            ContextNames enumerator = new ContextNames(enumStore);
            return enumerator;
        }
        Name subName = name.getPrefix(1);
        if (this.table.containsKey(subName)) {
            throw new NotContextException(String.valueOf(name) + " cannot be listed");
        }
        if (this.subContexts.containsKey(subName)) {
            return ((Context)this.subContexts.get(subName)).list(name.getSuffix(1));
        }
        throw new NamingException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.nameParser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null || name.isEmpty()) {
            HashMap enumStore = new HashMap();
            enumStore.putAll(this.table);
            enumStore.putAll(this.subContexts);
            return new ContextBindings(enumStore);
        }
        Name subName = name.getPrefix(1);
        if (this.table.containsKey(subName)) {
            throw new NotContextException(String.valueOf(name) + " cannot be listed");
        }
        if (this.subContexts.containsKey(subName)) {
            return ((Context)this.subContexts.get(subName)).listBindings(name.getSuffix(1));
        }
        throw new NamingException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.nameParser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() > 1) {
            if (this.subContexts.containsKey(name.getPrefix(1))) {
                Context subContext = (Context)this.subContexts.get(name.getPrefix(1));
                subContext.destroySubcontext(name.getSuffix(1));
                return;
            }
            throw new NameNotFoundException();
        }
        if (this.table.containsKey(name)) {
            throw new NotContextException();
        }
        if (!this.subContexts.containsKey(name)) {
            throw new NameNotFoundException();
        }
        Context subContext = (Context)this.subContexts.get(name);
        NamingEnumeration<NameClassPair> names = subContext.list("");
        if (names.hasMore()) {
            throw new ContextNotEmptyException();
        }
        ((Context)this.subContexts.get(name)).close();
        this.subContexts.remove(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.nameParser.parse(name));
    }

    @Override
    public abstract Context createSubcontext(Name var1) throws NamingException;

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.nameParser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(this.nameParser.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null || name.isEmpty() || name.size() == 1 && name.toString().equals(this.getNameInNamespace())) {
            return this.nameParser;
        }
        Name subName = name.getPrefix(1);
        if (this.subContexts.containsKey(subName)) {
            return ((Context)this.subContexts.get(subName)).getNameParser(name.getSuffix(1));
        }
        throw new NotContextException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this.nameParser.parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null || prefix == null) {
            throw new NamingException("Arguments must not be null");
        }
        Name retName = (Name)prefix.clone();
        retName.addAll(name);
        return retName;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name retName = this.composeName(this.nameParser.parse(name), this.nameParser.parse(prefix));
        return retName.toString();
    }

    @Override
    public Object addToEnvironment(String name, Object object) throws NamingException {
        if (this.env == null) {
            return null;
        }
        return this.env.put(name, object);
    }

    @Override
    public Object removeFromEnvironment(String name) throws NamingException {
        if (this.env == null) {
            return null;
        }
        return this.env.remove(name);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.env == null) {
            return new Hashtable();
        }
        return (Hashtable)this.env.clone();
    }

    @Override
    public void close() throws NamingException {
        if (this.closing) {
            return;
        }
        Iterator<Object> it = this.subContexts.keySet().iterator();
        while (it.hasNext()) {
            this.destroySubcontext((Name)it.next());
        }
        while (this.table.size() > 0 || this.subContexts.size() > 0) {
            it = this.table.keySet().iterator();
            LinkedList<Name> toRemove = new LinkedList<Name>();
            while (it.hasNext()) {
                Name name = (Name)it.next();
                Object entry = this.table.get(name);
                if (entry instanceof Thread) {
                    Thread thread = (Thread)entry;
                    if (!thread.isAlive()) continue;
                    toRemove.add(name);
                    continue;
                }
                toRemove.add(name);
            }
            it = toRemove.iterator();
            while (it.hasNext()) {
                this.table.remove(it.next());
            }
            toRemove.clear();
            for (Name name : this.subContexts.keySet()) {
                AbstractContext context = (AbstractContext)this.subContexts.get(name);
                if (!context.isEmpty()) continue;
                toRemove.add(name);
            }
            it = toRemove.iterator();
            while (it.hasNext()) {
                this.subContexts.remove(it.next());
            }
        }
        this.env = null;
        this.table = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace.toString();
    }

    public boolean isEmpty() {
        return this.table.size() > 0 || this.subContexts.size() > 0;
    }

    public void setNameInNamespace(Name name) throws NamingException {
        if (this.nameLock && (this.nameInNamespace != null || !this.nameInNamespace.isEmpty())) {
            throw new NamingException("Name already set.");
        }
        this.nameInNamespace = name;
        this.nameLock = true;
    }

    protected void setNameInNamespace(String name) throws NamingException {
        this.setNameInNamespace(this.nameParser.parse(name));
    }

    protected Hashtable getSubContexts() {
        return (Hashtable)this.subContexts.clone();
    }

    public static boolean isSharedAndLoaded() {
        return TABLE.size() != 0 || SUB_CONTEXTS.size() != 0;
    }
}

