/*
 * Decompiled with CFR 0.152.
 */
package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResponseDefinition {
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private LinkedHashMap<String, LinkedHashMap> content = new LinkedHashMap();
    private final String type;

    @JsonIgnore
    public ResponseDefinition(String type) {
        this.type = type;
        this.content.put(type, new LinkedHashMap());
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        schema.put("properties", new LinkedHashMap());
        this.content.get(this.type).put("schema", schema);
    }

    public void setEntityArrayProperty(String entity) {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        LinkedHashMap properties = new LinkedHashMap();
        schema.put("properties", properties);
        LinkedHashMap<String, Object> d = new LinkedHashMap<String, Object>();
        properties.put("d", d);
        d.put("title", "Collection of " + entity);
        d.put("type", "object");
        LinkedHashMap<String, Map<String, String>> dProperties = new LinkedHashMap<String, Map<String, String>>();
        d.put("properties", dProperties);
        dProperties.put("__count", Map.of("type", "string"));
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        dProperties.put("results", results);
        results.put("type", "array");
        results.put("items", Map.of("$ref", "#/components/schemas/" + entity));
        this.content.get(this.type).put("schema", schema);
    }

    public void setEntitySingleProperty(String entity) {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        schema.put("title", entity);
        LinkedHashMap<String, Map<String, CallSite>> properties = new LinkedHashMap<String, Map<String, CallSite>>();
        schema.put("properties", properties);
        LinkedHashMap d = new LinkedHashMap();
        properties.put("d", Map.of("$ref", "#/components/schemas/" + entity));
        this.content.get(this.type).put("schema", schema);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HashMap getContent() {
        return this.content;
    }

    public void setContent(LinkedHashMap content) {
        this.content = content;
    }

    @JsonIgnore
    public void addProperty(String name, LinkedHashMap definition) {
        LinkedHashMap schema = (LinkedHashMap)this.content.get(this.type).get("schema");
        LinkedHashMap properties = (LinkedHashMap)schema.get("properties");
        properties.put(name, definition);
        schema.put("properties", properties);
        this.content.get(this.type).put("schema", schema);
    }

    @JsonIgnore
    public void addExample(LinkedHashMap definition) {
        this.content.get(this.type).put("example", definition);
    }

    @JsonIgnore
    public void addToMetadataReference(String entityLink) {
        LinkedHashMap<String, CallSite> schema = new LinkedHashMap<String, CallSite>();
        schema.put("$ref", (CallSite)((Object)("#/components/schemas/" + entityLink)));
        this.content.get(this.type).put("schema", schema);
    }
}

