/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.core.model.AppConfiguration;
import cronapp.framework.i18n.Messages;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Security;
import org.springframework.web.cors.CorsUtils;

public class CustomCorsFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        AppConfiguration appConfig = AppConfiguration.getInstance();
        String cors = appConfig.getCors();
        if (!cors.equals("<sameorigin>")) {
            response.setHeader("Access-Control-Allow-Origin", cors);
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Expose-Headers", "Set-Cookie, X-Csrf-Token");
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        response.setHeader("Access-Control-Allow-Methods", appConfig.getCorsMethods());
        response.setHeader("Access-Control-Allow-Headers", appConfig.getCorsHeaders());
        try {
            Messages.set(req.getLocale());
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
                response.setStatus(200);
            } else {
                chain.doFilter(req, res);
            }
        }
        finally {
            Messages.remove();
        }
    }

    public void destroy() {
    }

    static {
        Security.setProperty("keystore.type", "jks");
    }
}

