/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.core.model.AppConfiguration;
import cronapp.framework.core.model.SocialNetwork;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Order
@Configuration
public class LegacyPropertyHandler
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String ENTITY_ID = "entityId";
    private static final String ACCESS_TOKEN_URI = "accessTokenUri";
    private int oauthRegistrationIndex = 0;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.upgradeEnvironment(applicationContext.getEnvironment());
    }

    private void upgradeEnvironment(ConfigurableEnvironment environment) {
        HashMap<String, String> upgradedProperties = new HashMap<String, String>();
        upgradedProperties.putAll(this.upgradeCommonProperties(environment));
        upgradedProperties.putAll(this.upgradeSamlProperties(environment));
        upgradedProperties.putAll(this.upgradeOAuthProperties(environment));
        if (AppConfiguration.getInstance().getAuth().getSocialLogin().booleanValue()) {
            upgradedProperties.putAll(this.upgradeGithubOAuthProperties());
            upgradedProperties.putAll(this.upgradeGoogleOAuthProperties());
            upgradedProperties.putAll(this.upgradeFacebookOAuthProperties());
            upgradedProperties.putAll(this.upgradeLinkedinOAuthProperties());
        }
        if (!upgradedProperties.isEmpty()) {
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(this.getClass().getName(), upgradedProperties));
        }
    }

    private Map<String, String> getMappedProperties(ConfigurableEnvironment environment, Map<String, String> propertyMappings) {
        return propertyMappings.entrySet().stream().map(entry -> {
            String value = environment.getProperty((String)entry.getKey());
            return value != null ? Map.entry((String)entry.getValue(), value) : null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> upgradeCommonProperties(ConfigurableEnvironment environment) {
        HashMap<String, String> result = new HashMap<String, String>();
        Boolean authenticationEnabled = (Boolean)environment.getProperty("cronapp.security.authentication", Boolean.class);
        String authType = AppConfiguration.getInstance().getAuth().getType();
        if (authenticationEnabled == null) {
            authenticationEnabled = authType != null && authType.equalsIgnoreCase("Token");
        }
        if (StringUtils.equals((CharSequence)authType, (CharSequence)"Nenhuma")) {
            authenticationEnabled = false;
        }
        result.put("cronapp.security.enabled", authenticationEnabled.toString());
        if (authenticationEnabled.booleanValue()) {
            result.put("cronapp.security.forms.enabled", "true");
            result.put("cronapp.security.token.enabled", "true");
        }
        return result;
    }

    private Map<String, String> upgradeSamlProperties(ConfigurableEnvironment environment) {
        Map<String, String> propertyMappings = Map.of("security.oauth2.saml.metadataUrl", "cronapp.security.saml.registrations[0].metadataUrl", "security.oauth2.saml.privateKey", "cronapp.security.saml.registrations[0].privateKeyAlias", "security.oauth2.saml.privateKeyPass", "cronapp.security.saml.registrations[0].privateKeyPass", "security.oauth2.saml.storeFile", "cronapp.security.saml.registrations[0].keystoreFile", "security.oauth2.saml.storePass", "cronapp.security.saml.registrations[0].keystorePass", "security.oauth2.saml.entityId", "cronapp.security.saml.registrations[0].entityId");
        Map<String, String> result = this.getMappedProperties(environment, propertyMappings);
        if (!result.isEmpty() && !environment.getProperty("security.oauth2.saml.entityId", ENTITY_ID).equals(ENTITY_ID)) {
            result.put("cronapp.security.saml.registrations[0].name", "default");
            result.put("cronapp.security.saml.enabled", "true");
        }
        return result;
    }

    private Map<String, String> upgradeOAuthProperties(ConfigurableEnvironment environment) {
        String propertyPrefix = "cronapp.security.oauth.registrations[" + this.oauthRegistrationIndex + "]";
        Map<String, CallSite> propertyMappings = Map.of("security.oauth2.client.clientId", propertyPrefix + ".clientId", "security.oauth2.client.clientSecret", propertyPrefix + ".clientSecret", "security.oauth2.client.userAuthorizationUri", propertyPrefix + ".authorizationUri", "security.oauth2.client.accessTokenUri", propertyPrefix + ".tokenUri", "security.oauth2.resource.userInfoUri", propertyPrefix + ".userInfoUri", "security.oauth2.client.scope", propertyPrefix + ".scope");
        String accessTokenUri = environment.getProperty("security.oauth2.client.accessTokenUri");
        if (accessTokenUri != null && !accessTokenUri.equals(ACCESS_TOKEN_URI)) {
            Map<String, String> result = this.getMappedProperties(environment, propertyMappings);
            result.put("cronapp.security.oauth.enabled", "true");
            result.put(propertyPrefix + ".name", "default");
            result.put(propertyPrefix + ".nameAttributeKey", "preferred_username");
            result.put(propertyPrefix + ".jwkSetUri", this.discoverJwkSetUri(accessTokenUri));
            ++this.oauthRegistrationIndex;
            return result;
        }
        return Map.of();
    }

    private String discoverJwkSetUri(String accessTokenUri) {
        if (accessTokenUri.contains("login.microsoftonline.com")) {
            return accessTokenUri.replace("/oauth2/v2.0/token", "/discovery/v2.0/keys");
        }
        return accessTokenUri.replace("/token", "/certs");
    }

    private SocialNetwork getSocialNetworkConfiguration(String name) {
        AppConfiguration appConfiguration = AppConfiguration.getInstance();
        if (appConfiguration.getAuth() == null || appConfiguration.getAuth().getSocialNetworks() == null) {
            return null;
        }
        return AppConfiguration.getInstance().getAuth().getSocialNetworks().stream().filter(network -> network.getName().equals(name)).filter(SocialNetwork::getActive).findFirst().orElse(null);
    }

    private Map<String, String> upgradeGoogleOAuthProperties() {
        SocialNetwork configuration = this.getSocialNetworkConfiguration("google");
        if (configuration != null) {
            String propertyPrefix = "cronapp.security.oauth.registrations[" + this.oauthRegistrationIndex + "]";
            ++this.oauthRegistrationIndex;
            return Map.of(propertyPrefix + ".name", "google", propertyPrefix + ".clientId", configuration.getAppId(), propertyPrefix + ".clientSecret", configuration.getAppSecret(), propertyPrefix + ".authorizationUri", "https://accounts.google.com/o/oauth2/v2/auth", propertyPrefix + ".tokenUri", "https://oauth2.googleapis.com/token", propertyPrefix + ".userInfoUri", "https://openidconnect.googleapis.com/v1/userinfo", propertyPrefix + ".jwkSetUri", "https://www.googleapis.com/oauth2/v3/certs", propertyPrefix + ".scope", "openid profile email", "cronapp.security.oauth.enabled", "true");
        }
        return Map.of();
    }

    private Map<String, String> upgradeGithubOAuthProperties() {
        SocialNetwork configuration = this.getSocialNetworkConfiguration("github");
        if (configuration != null) {
            String propertyPrefix = "cronapp.security.oauth.registrations[" + this.oauthRegistrationIndex + "]";
            ++this.oauthRegistrationIndex;
            return Map.of(propertyPrefix + ".name", "github", propertyPrefix + ".clientId", configuration.getAppId(), propertyPrefix + ".clientSecret", configuration.getAppSecret(), propertyPrefix + ".authorizationUri", "https://github.com/login/oauth/authorize", propertyPrefix + ".tokenUri", "https://github.com/login/oauth/access_token", propertyPrefix + ".userInfoUri", "https://api.github.com/user", propertyPrefix + ".jwkSetUri", "https://github.com/login/oauth/.well-known/jwks", propertyPrefix + ".nameAttributeKey", "id", propertyPrefix + ".scope", "read:user", "cronapp.security.oauth.enabled", "true");
        }
        return Map.of();
    }

    private Map<String, String> upgradeFacebookOAuthProperties() {
        SocialNetwork configuration = this.getSocialNetworkConfiguration("facebook");
        if (configuration != null) {
            String propertyPrefix = "cronapp.security.oauth.registrations[" + this.oauthRegistrationIndex + "]";
            ++this.oauthRegistrationIndex;
            return Map.of(propertyPrefix + ".name", "facebook", propertyPrefix + ".clientId", configuration.getAppId(), propertyPrefix + ".clientSecret", configuration.getAppSecret(), propertyPrefix + ".authorizationUri", "https://www.facebook.com/v2.8/dialog/oauth", propertyPrefix + ".tokenUri", "https://graph.facebook.com/v2.8/oauth/access_token", propertyPrefix + ".userInfoUri", "https://graph.facebook.com/me?fields=id,name,email", propertyPrefix + ".jwkSetUri", "https://www.facebook.com/.well-known/oauth/openid/jwks", propertyPrefix + ".nameAttributeKey", "sub", propertyPrefix + ".scope", "openid public_profile email", "cronapp.security.oauth.enabled", "true");
        }
        return Map.of();
    }

    private Map<String, String> upgradeLinkedinOAuthProperties() {
        SocialNetwork configuration = this.getSocialNetworkConfiguration("linkedin");
        if (configuration != null) {
            String propertyPrefix = "cronapp.security.oauth.registrations[" + this.oauthRegistrationIndex + "]";
            ++this.oauthRegistrationIndex;
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(propertyPrefix + ".name", "linkedin");
            result.put(propertyPrefix + ".clientId", configuration.getAppId());
            result.put(propertyPrefix + ".clientSecret", configuration.getAppSecret());
            result.put(propertyPrefix + ".authorizationUri", "https://www.linkedin.com/oauth/v2/authorization");
            result.put(propertyPrefix + ".tokenUri", "https://www.linkedin.com/oauth/v2/accessToken");
            result.put(propertyPrefix + ".userInfoUri", "https://api.linkedin.com/v2/userinfo");
            result.put(propertyPrefix + ".jwkSetUri", "https://www.linkedin.com/oauth/openid/jwks");
            result.put(propertyPrefix + ".nameAttributeKey", "sub");
            result.put(propertyPrefix + ".scope", "openid profile email");
            result.put(propertyPrefix + ".clientAuthenticationMethod", "client_secret_post");
            result.put(propertyPrefix + ".removeNonce", "true");
            result.put("cronapp.security.oauth.enabled", "true");
            return result;
        }
        return Map.of();
    }
}

