/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.persistence;

import cronapp.framework.persistence.PasswordConstraintValidator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.BAD_REQUEST)
public class PasswordConstraintException
extends RuntimeException {
    public PasswordConstraintException() {
    }

    public PasswordConstraintException(String message) {
        super(message);
    }

    public PasswordConstraintException(String message, Throwable cause) {
        super(message, cause);
    }

    public PasswordConstraintException(Throwable cause) {
        super(cause);
    }

    public static PasswordConstraintException unwrap(Exception exception) {
        String message;
        ConstraintViolationException constraintViolationException = null;
        for (Throwable currentThrowable = exception; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            if (!(currentThrowable instanceof ConstraintViolationException)) continue;
            constraintViolationException = (ConstraintViolationException)currentThrowable;
            break;
        }
        if (constraintViolationException != null && StringUtils.isNotBlank((CharSequence)(message = constraintViolationException.getConstraintViolations().stream().filter(constraintViolation -> constraintViolation.getConstraintDescriptor().getConstraintValidatorClasses().contains(PasswordConstraintValidator.class)).map(ConstraintViolation::getMessage).collect(Collectors.joining("\n"))))) {
            return new PasswordConstraintException(message, exception);
        }
        return null;
    }
}

