/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.AppConfig;
import cronapi.TokenUtils;
import cronapi.Var;
import cronapi.util.Operations;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.User;
import cronapp.framework.api.response.DefaultResponse;
import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.i18n.Messages;
import cronapp.framework.persistence.PasswordConstraintException;
import cronapp.framework.security.AuthenticationMethod;
import cronapp.framework.security.AuthenticationProviders;
import cronapp.framework.security.AuthenticationResponse;
import io.jsonwebtoken.Claims;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ForbiddenException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SecurityController {
    @Generated
    private static final Log log = LogFactory.getLog(SecurityController.class);
    private static final String SCOPE_UPDATE_CURRENT_USER_PASSWORD = "update:current_user:password";
    @Autowired
    private AuthenticationProviders authenticationProviders;

    @RequestMapping(path={"token"}, method={RequestMethod.GET})
    public String token() {
        return "";
    }

    @RequestMapping(path={"auth/refresh"}, method={RequestMethod.GET})
    public ResponseEntity<AuthenticationResponse> refresh(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        return this.me(authentication, request);
    }

    @RequestMapping(path={"authproviders"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<AuthenticationMethod>> authProviders() {
        return ResponseEntity.ok(this.authenticationProviders.getMethods());
    }

    @RequestMapping(path={"me"}, method={RequestMethod.GET})
    public ResponseEntity<AuthenticationResponse> me(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        try {
            String authToken = request.getHeader("X-AUTH-TOKEN");
            long expires = 0L;
            if (StringUtils.isNotBlank((CharSequence)authToken)) {
                expires = TokenUtils.getExpirationDateFromToken((String)authToken).getTime();
            }
            ApiManager apiManager = ApiManager.byUser(authentication.getName());
            Collection authorities = authentication.getAuthorities();
            User user = apiManager.getUser();
            User userWithoutPass = user.resetPassword();
            StringJoiner roles = new StringJoiner(",");
            boolean root = false;
            for (GrantedAuthority role : authorities) {
                roles.add(role.getAuthority());
                if (!role.getAuthority().equalsIgnoreCase("Administrators")) continue;
                root = true;
            }
            AuthenticationResponse responseBody = AuthenticationResponse.builder().user(userWithoutPass).token(authToken).expires(expires).roles(roles.toString()).root(root).build();
            return ResponseEntity.ok((Object)responseBody);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
        }
    }

    @PostMapping(value={"auth/signup"})
    public ResponseEntity<DefaultResponse> signUp(@RequestBody Var fields) {
        DefaultResponse defaultResponse = new DefaultResponse();
        Boolean avaliableSignup = AppConfig.getIfRegistrationAvailable();
        if (!avaliableSignup.booleanValue()) {
            return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.FORBIDDEN.value(), Messages.getString("UserRegisterNotAvaliable")), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        Map mapUser = fields.getObjectAsMap();
        if (mapUser.get("name") == null) {
            mapUser.put("name", mapUser.get("username"));
        }
        mapUser.put("normalizedUserName", mapUser.get("username"));
        mapUser.put("normalizedEmail", mapUser.get("email"));
        try {
            User userNoPassword = ApiManager.byUser(mapUser.get("username").toString()).getUser();
            if (userNoPassword != null) {
                return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.BAD_REQUEST.value(), Messages.getString("UserAlreadyExists")), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            ApiManager.createUser(fields);
        }
        catch (Exception err) {
            PasswordConstraintException passwordConstraintException = PasswordConstraintException.unwrap(err);
            if (passwordConstraintException != null) {
                throw passwordConstraintException;
            }
            return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.FORBIDDEN.value(), Messages.getString("AuthError", err.getMessage())), (HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.CREATED.value(), Messages.getString("UserRegisteredSuccessfully")), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"auth/reset-password"})
    public ResponseEntity<String> resetPassword(@RequestParam(value="email") String email) {
        try {
            User user = ApiManager.byUser(email).getUser();
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put("sub", user.getUsername());
            claims.put("scope", SCOPE_UPDATE_CURRENT_USER_PASSWORD);
            String token = TokenUtils.generateToken(claims, (Date)TokenUtils.generateExpirationDate(), null);
            Operations.callBlockly((Var)Var.valueOf((Object)"UserManager:sendResetPasswordEmail"), (Var[])new Var[]{Var.valueOf((Object)user.getEmail()), Var.valueOf((Object)user.getName()), Var.valueOf((Object)token)});
        }
        catch (Exception e) {
            log.error((Object)Messages.getString("AuthError", e.getMessage()), (Throwable)e);
        }
        return new ResponseEntity((Object)"{}", (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"auth/confirm-reset-password"})
    public void confirmResetPassword(@RequestParam(value="password") String password, @RequestParam(value="otp", required=false) String otp, @RequestHeader(value="X-AUTH-TOKEN") String authToken, HttpServletRequest request) {
        if (authToken == null || authToken.isBlank()) {
            authToken = TokenUtils.getTokenFromCookie((Cookie[])request.getCookies());
        }
        if (TokenUtils.isTokenExpired((String)authToken)) {
            throw new ForbiddenException(Messages.getString("ResetPasswordTokenExpired"));
        }
        String username = TokenUtils.getUsernameFromToken((String)authToken);
        List scopes = TokenUtils.getScopeFromToken((String)authToken);
        Claims claims = TokenUtils.getClaimsFromToken((String)authToken);
        if (username == null || !scopes.contains(SCOPE_UPDATE_CURRENT_USER_PASSWORD)) {
            throw new ForbiddenException(Messages.getString("UserOrPassordInvalids"));
        }
        CronappSettingsService settingsService = (CronappSettingsService)CronappConfiguration.getBean(CronappSettingsService.class);
        if (otp != null) {
            String encryptedOneTimePassword = String.valueOf(claims.get((Object)"otp"));
            String decryptedOneTimePassword = Encryptors.text((CharSequence)settingsService.getEncryptionKey(), (CharSequence)settingsService.getEncryptionSalt()).decrypt(encryptedOneTimePassword);
            if (encryptedOneTimePassword != null && !decryptedOneTimePassword.equals(otp)) {
                throw new ForbiddenException(Messages.getString("InvalidOTP"));
            }
        }
        if (EventsManager.hasEvent("onResetPassword")) {
            EventsManager.executeEventOnTransaction("onResetPassword", Var.valueOf((Object)username), Var.valueOf((Object)password));
            return;
        }
        ApiManager manager = ApiManager.byUser(username);
        try {
            manager.updatePassword(password);
        }
        catch (Exception e) {
            PasswordConstraintException passwordConstraintException = PasswordConstraintException.unwrap(e);
            if (passwordConstraintException != null) {
                throw passwordConstraintException;
            }
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
        }
    }
}

