/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.api.ApiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class GrantedAuthorityRepository {
    public List<SimpleGrantedAuthority> findAll(String username) {
        Collection<String> userRoles = ApiManager.byUser(username).getRoles();
        Stream<String> roleSecurables = this.findRoleSecurables(userRoles);
        Stream<String> publicSecurables = this.findPublicSecurables();
        Stream<String> authenticatedSecurables = this.findAuthenticatedSecurables();
        Stream<String> userSecurables = this.findUserSecurables(username);
        ArrayList<SimpleGrantedAuthority> list = new ArrayList<SimpleGrantedAuthority>();
        list.addAll(Stream.of(publicSecurables, authenticatedSecurables, userSecurables, roleSecurables).reduce(Stream::concat).orElse(Stream.empty()).distinct().sorted().map(SimpleGrantedAuthority::new).toList());
        if (list.isEmpty()) {
            for (String role : userRoles) {
                list.add(new SimpleGrantedAuthority(role));
            }
        }
        return list;
    }

    public List<SimpleGrantedAuthority> findAll(Collection<String> roles) {
        Stream<String> roleSecurables = this.findRoleSecurables(roles);
        Stream<String> authenticatedSecurables = this.findAuthenticatedSecurables();
        Stream<String> publicSecurables = this.findPublicSecurables();
        return Stream.of(publicSecurables, authenticatedSecurables, roleSecurables).reduce(Stream::concat).orElse(Stream.empty()).distinct().sorted().map(SimpleGrantedAuthority::new).toList();
    }

    private Stream<String> findRoleSecurables(Collection<String> roles) {
        return roles.stream().flatMap(role -> ApiManager.getRoleSecurables(role).stream()).map(securable -> securable.getStringField("name"));
    }

    private Stream<String> findPublicSecurables() {
        return ApiManager.getPublicSecurables().stream().map(securable -> securable.getStringField("name"));
    }

    private Stream<String> findAuthenticatedSecurables() {
        return ApiManager.getAuthenticatedSecurables().stream().map(securable -> securable.getStringField("name"));
    }

    public Stream<String> findUserSecurables(String userName) {
        return ApiManager.getUserSecurables(userName).stream().map(securable -> securable.getStringField("name"));
    }
}

