/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.ErrorResponse;
import cronapi.QueryManager;
import cronapi.Var;
import cronapi.database.TransactionManager;
import cronapi.util.Operations;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.http.HttpStatus;

public class EventsManager {
    private static JsonObject JSON = EventsManager.loadJSON();

    private static JsonObject loadJSON() {
        JsonObject jsonObject;
        block8: {
            ClassLoader classLoader = EventsManager.class.getClassLoader();
            InputStream stream = classLoader.getResourceAsStream("META-INF/events.json");
            try {
                InputStreamReader reader = new InputStreamReader(stream);
                JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                jsonObject = jsonElement.getAsJsonObject();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return new JsonObject();
                }
            }
            stream.close();
        }
        return jsonObject;
    }

    private static JsonObject getJSON() {
        if (Operations.IS_DEBUG) {
            return EventsManager.loadJSON();
        }
        return JSON;
    }

    public static JsonObject getEvent(String eventName) {
        JsonObject obj = EventsManager.getJSON().getAsJsonObject(eventName);
        return obj;
    }

    private static boolean isNull(JsonElement value) {
        return value == null || value.isJsonNull();
    }

    public static Var executeEvent(String eventName, Var ... params) {
        JsonObject event = EventsManager.getEvent(eventName);
        if (event != null) {
            return EventsManager.executeEvent(event, eventName, new LinkedHashMap<String, Var>(), params);
        }
        return null;
    }

    public static Var executeEventOnTransaction(String eventName, Var ... params) {
        return EventsManager.runIntoTransaction(() -> {
            JsonObject event = EventsManager.getEvent(eventName);
            if (event != null) {
                LinkedHashMap<String, Var> context = new LinkedHashMap<String, Var>();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        Var param = params[i];
                        if (param.getId() == null) continue;
                        params[i] = Var.valueOf((Object)param.getObject());
                        context.put(param.getId(), params[i]);
                    }
                }
                return EventsManager.executeEvent(event, eventName, context, params);
            }
            return null;
        });
    }

    public static Var executeEventOnTransaction(String eventName, Map<String, Var> context, Var ... params) {
        return EventsManager.runIntoTransaction(() -> {
            JsonObject event = EventsManager.getEvent(eventName);
            if (event != null) {
                return EventsManager.executeEvent(event, eventName, context, params);
            }
            return null;
        });
    }

    private static Var runIntoTransaction(Callable<Var> callable) {
        Var var = Var.VAR_NULL;
        try {
            var = callable.call();
            TransactionManager.commit();
        }
        catch (Exception ex) {
            TransactionManager.rollback();
            ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), (Throwable)ex, "GET");
            throw new RuntimeException(errorResponse.getError(), ex);
        }
        return var;
    }

    public static boolean hasEvent(String eventName) {
        return !EventsManager.isNull(EventsManager.getJSON().get(eventName));
    }

    public static Var executeEvent(JsonObject event, String eventName, Map<String, Var> customValues, Var ... params) {
        if (event != null) {
            if (event.get("blocklyParams") != null) {
                JsonArray bloclyParams = event.get("blocklyParams").getAsJsonArray();
                params = new Var[bloclyParams.size()];
                for (int i = 0; i < bloclyParams.size(); ++i) {
                    JsonObject param = bloclyParams.get(i).getAsJsonObject();
                    customValues.put("eventName", Var.valueOf((Object)eventName));
                    params[i] = QueryManager.parseExpressionValue(null, (JsonObject)event, null, (JsonElement)param.get("value"), customValues);
                }
            }
            Var name = Var.valueOf((Object)(event.get("blocklyClass").getAsString() + ":" + event.get("blocklyMethod").getAsString()));
            try {
                return Operations.callBlockly((Var)name, (Var[])params);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

