/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.authentication.external.ExternalAuthenticator;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BasedInLdapAuthenticator
implements ExternalAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(BasedInLdapAuthenticator.class);
    private static final String LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";

    BasedInLdapAuthenticator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean authenticate(String providerUrl, String principal, String credentials) {
        Hashtable<String, String> environment = new Hashtable<String, String>(5);
        if (providerUrl.startsWith("ldaps")) {
            System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
        }
        environment.put("java.naming.factory.initial", LDAP_CONTEXT_FACTORY);
        environment.put("java.naming.provider.url", providerUrl);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.security.principal", principal);
        environment.put("java.naming.security.credentials", credentials);
        if (providerUrl.startsWith("ldaps")) {
            environment.put("java.naming.ldap.factory.socket", "cronapp.framework.authentication.external.AcceptAllSSLSocketFactory");
        }
        InitialDirContext context = null;
        try {
            context = new InitialDirContext(environment);
        }
        catch (NamingException e) {
            log.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return true;
    }

    String generateProviderUrl() {
        String hostname = AppConfig.hostname();
        Object providerUrl = hostname.startsWith("ldap://") || hostname.startsWith("ldaps://") ? hostname : "ldap://" + hostname;
        return providerUrl;
    }
}

