/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.CronappFrameworkException;
import cronapp.framework.api.ApiManager;
import cronapp.framework.security.ApiAuthenticationFailureHandler;
import cronapp.framework.security.ApiAuthenticationSuccessHandler;
import cronapp.framework.security.ApiUserDetailsManager;
import cronapp.framework.security.AuthenticationMethod;
import cronapp.framework.security.AuthenticationProviders;
import cronapp.framework.security.CronappUserDetails;
import cronapp.framework.security.GrantedAuthorityRepository;
import cronapp.framework.security.HttpSecurityCustomizer;
import cronapp.framework.security.SamlProperties;
import cronapp.framework.security.SamlRegistrationProperties;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.Customizer;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="cronapp.security.saml", name={"enabled"}, havingValue="true")
@Component
public class SamlConfiguration {
    private final Converter<OpenSaml4AuthenticationProvider.ResponseToken, Saml2Authentication> defaultConverter = OpenSaml4AuthenticationProvider.createDefaultResponseAuthenticationConverter();
    private final SamlProperties properties;
    private final GrantedAuthorityRepository grantedAuthorityRepository;
    private final AuthenticationProviders authenticationProviders;
    private final ApiAuthenticationFailureHandler authenticationFailureHandler;
    private final ApiAuthenticationSuccessHandler authenticationSuccessHandler;
    private final ApiUserDetailsManager userDetailsManager;

    @Bean
    public HttpSecurityCustomizer samlCustomizer() {
        return http -> http.saml2Login(configurer -> {
            configurer.failureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler);
            configurer.successHandler((AuthenticationSuccessHandler)this.authenticationSuccessHandler);
        }).saml2Metadata(Customizer.withDefaults()).saml2Logout(Customizer.withDefaults());
    }

    @Bean
    private CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setSameSite("None");
        return serializer;
    }

    @Bean
    public OpenSaml4AuthenticationProvider samlAuthenticationProvider() {
        OpenSaml4AuthenticationProvider provider = new OpenSaml4AuthenticationProvider();
        provider.setResponseAuthenticationConverter(this.responseAuthenticationConverter());
        return provider;
    }

    private Converter<OpenSaml4AuthenticationProvider.ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter() {
        return responseToken -> {
            Saml2Authentication defaultAuthentication = (Saml2Authentication)this.defaultConverter.convert(responseToken);
            if (defaultAuthentication == null) {
                return null;
            }
            Object principal = defaultAuthentication.getPrincipal();
            if (!(principal instanceof Saml2AuthenticatedPrincipal)) {
                throw new Saml2AuthenticationException(new Saml2Error("internal_validation_error", "Invalid principal"));
            }
            Saml2AuthenticatedPrincipal authenticatedPrincipal = (Saml2AuthenticatedPrincipal)principal;
            List memberOfAttribute = authenticatedPrincipal.getAttribute("memberOf");
            List<String> groups = memberOfAttribute != null ? memberOfAttribute.stream().map(Object::toString).toList() : List.of();
            List<SimpleGrantedAuthority> authorities = this.grantedAuthorityRepository.findAll(groups);
            Saml2Authentication result = new Saml2Authentication((AuthenticatedPrincipal)authenticatedPrincipal, defaultAuthentication.getSaml2Response(), authorities);
            if (!this.userDetailsManager.userExists(result.getName())) {
                CronappUserDetails userDetails = SamlConfiguration.createCronappUserDetails(result);
                this.userDetailsManager.createUser(userDetails);
            }
            result.setDetails((Object)this.userDetailsManager.loadUserByUsername(result.getName()));
            return result;
        };
    }

    @Bean
    public RelyingPartyRegistrationRepository samlRegistrationRepository() {
        Set registrations = this.properties.getRegistrations().stream().map(this::getSamlRegistration).collect(Collectors.toSet());
        this.properties.getRegistrations().forEach(registration -> this.authenticationProviders.addMethod(new AuthenticationMethod(registration.getName(), "/saml2/authenticate/" + registration.getName(), registration.getIcon(), registration.getDisplayName(), "saml")));
        return new InMemoryRelyingPartyRegistrationRepository(registrations);
    }

    private RelyingPartyRegistration getSamlRegistration(SamlRegistrationProperties properties) {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream is = new ClassPathResource(properties.getKeystoreFile()).getInputStream();){
            keystore.load(is, properties.getKeystorePass().toCharArray());
        }
        Key key = keystore.getKey(properties.getPrivateKeyAlias(), properties.getPrivateKeyPass().toCharArray());
        if (!(key instanceof PrivateKey)) {
            throw new CronappFrameworkException("Key is not a private key");
        }
        PrivateKey privateKey = (PrivateKey)key;
        Certificate cert = keystore.getCertificate(properties.getPrivateKeyAlias());
        if (cert == null) {
            throw new CronappFrameworkException("Certificate not found");
        }
        X509Certificate x509Certificate = (X509Certificate)cert;
        Saml2X509Credential signingCredential = Saml2X509Credential.signing((PrivateKey)privateKey, (X509Certificate)x509Certificate);
        RelyingPartyRegistration.Builder builder = RelyingPartyRegistrations.fromMetadataLocation((String)properties.getMetadataUrl()).registrationId(properties.getName()).signingX509Credentials(c -> c.add(signingCredential)).singleLogoutServiceBinding(Saml2MessageBinding.POST);
        if (properties.getEntityId() != null) {
            builder.entityId(properties.getEntityId());
        }
        return builder.build();
    }

    @Bean
    public Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> samlAuthenticationRequestRepository() {
        return new HttpSessionSaml2AuthenticationRequestRepository();
    }

    public static CronappUserDetails createCronappUserDetails(Saml2Authentication defaultAuthentication) {
        String userName = defaultAuthentication.getName();
        String normalizedUserName = ApiManager.normalize(userName);
        String email = normalizedUserName + "@no-email";
        String normalizedEmail = ApiManager.normalize(email);
        return CronappUserDetails.newBuilder().setName(userName).setUserName(userName).setNormalizedUserName(normalizedUserName).setEmail(email).setNormalizedEmail(normalizedEmail).setEmailConfirmed(true).setSecurityStamp(UUID.randomUUID().toString()).setPhoneNumberConfirmed(true).setTwoFactorEnabled(false).setLockoutEnd(OffsetDateTime.MIN).setLockoutEnabled(false).setAccessFailedCount(0).setAuthorities(new HashSet<GrantedAuthority>(defaultAuthentication.getAuthorities())).setPayload(Map.of()).build();
    }

    @Generated
    public SamlConfiguration(SamlProperties properties, GrantedAuthorityRepository grantedAuthorityRepository, AuthenticationProviders authenticationProviders, ApiAuthenticationFailureHandler authenticationFailureHandler, ApiAuthenticationSuccessHandler authenticationSuccessHandler, ApiUserDetailsManager userDetailsManager) {
        this.properties = properties;
        this.grantedAuthorityRepository = grantedAuthorityRepository;
        this.authenticationProviders = authenticationProviders;
        this.authenticationFailureHandler = authenticationFailureHandler;
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        this.userDetailsManager = userDetailsManager;
    }
}

