/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.CronapiBeanConfigurator;
import cronapp.framework.core.model.AppConfiguration;
import jakarta.annotation.Nonnull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.web.filter.OncePerRequestFilter;

public class CustomHeadersFilter
extends OncePerRequestFilter {
    static final String HEADER_PREFIX = "crn.header.";
    static final String ENV_VAR_HEADER_PREFIX = "CRN_HEADER_";

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.setAppConfigHeaders(response);
        this.setInitParamsHeaders(response);
        this.setEnvHeaders(response);
        this.setSystemPropertiesHeaders(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void setAppConfigHeaders(HttpServletResponse response) {
        AppConfiguration appConfig = AppConfiguration.getInstance();
        if (appConfig.getExtraHeaders() == null) {
            return;
        }
        appConfig.getExtraHeaders().forEach(header -> response.setHeader(header.getName(), header.getValue()));
    }

    private void setInitParamsHeaders(HttpServletResponse response) {
        this.setHeadersFromMap(CronapiBeanConfigurator.INIT_PARAMS, HEADER_PREFIX, response);
    }

    private void setEnvHeaders(HttpServletResponse response) {
        this.setHeadersFromMap(System.getenv(), ENV_VAR_HEADER_PREFIX, response);
    }

    private void setSystemPropertiesHeaders(HttpServletResponse response) {
        this.setHeadersFromMap(System.getProperties(), HEADER_PREFIX, response);
    }

    private void setHeadersFromMap(Map<?, ?> map, String headerPrefix, HttpServletResponse response) {
        if (map == null) {
            return;
        }
        map.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> entry.getKey().toString().startsWith(headerPrefix)).forEach(entry -> response.setHeader(entry.getKey().toString().replace(headerPrefix, ""), entry.getValue() != null ? entry.getValue().toString() : ""));
    }
}

