/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.AppConfig;
import cronapi.TokenUtils;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.User;
import cronapp.framework.security.CronappUserDetails;
import cronapp.framework.security.SecuritySupport;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class ApiAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    @Generated
    private static final Log log = LogFactory.getLog(ApiAuthenticationSuccessHandler.class);

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        if (!SecuritySupport.X_REQUESTED_WITH.matches(request)) {
            super.onAuthenticationSuccess(request, response, authentication);
        }
        try {
            User user;
            String userName = authentication.getName();
            ApiManager apiManager = ApiManager.byUserAndPassword(userName, null, SecuritySupport.getProvider(authentication), AppConfig.autoSignUp(), null);
            try {
                user = authentication.getDetails() instanceof CronappUserDetails ? apiManager.getUser((CronappUserDetails)authentication.getDetails()) : apiManager.getUser();
            }
            catch (Exception e) {
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
            if (SecuritySupport.isMobileDevice(request) && SecuritySupport.isSso(authentication)) {
                String token = TokenUtils.generateToken((Authentication)authentication, (String)SecuritySupport.getProvider(authentication));
                response.sendRedirect(request.getContextPath() + "/token?_ctk=" + token);
            }
            ApiManager.unlockUser(user);
        }
        catch (Exception e) {
            log.error((Object)LogMessage.format((String)"Error unlocking user after authentication success: %s", (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Generated
    public ApiAuthenticationSuccessHandler() {
    }
}

