/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.security.CronappUserDetails;
import cronapp.framework.security.GrantedAuthorityRepository;
import java.util.List;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Component;

@Component
public class ApiUserDetailsManager
implements UserDetailsManager {
    @Generated
    private static final Log log = LogFactory.getLog(ApiUserDetailsManager.class);
    private final GrantedAuthorityRepository grantedAuthorityRepository;
    private static final ThreadLocal<String> currentPassword = new ThreadLocal();

    public void setCurrentPassword(String password) {
        currentPassword.set(password);
    }

    public String getCurrentPassword() {
        return currentPassword.get();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (EventsManager.hasEvent("onAuthenticate")) {
            Var userResult = EventsManager.executeEventOnTransaction("onAuthenticate", Var.valueOf((String)"username", (Object)username), Var.valueOf((String)"password", (Object)this.getCurrentPassword()));
            if (userResult == null || userResult.isEmptyOrNull().booleanValue()) {
                throw new UsernameNotFoundException("Error loading user " + username);
            }
            if (userResult.getType() == Var.Type.BOOLEAN && !userResult.getObjectAsBoolean().booleanValue()) {
                throw new UsernameNotFoundException("Error loading user " + username);
            }
            List<SimpleGrantedAuthority> authorities = this.grantedAuthorityRepository.findAll(username);
            return new User(username, this.getCurrentPassword(), true, true, true, true, authorities);
        }
        cronapp.framework.api.User apiManagerUser = this.loadApiUser(username);
        String password = apiManagerUser.getPassword();
        boolean enabled = true;
        boolean accountNonExpired = true;
        boolean credentialsNonExpired = true;
        boolean accountNonLocked = !ApiManager.isUserLocked(apiManagerUser);
        List<SimpleGrantedAuthority> authorities = this.grantedAuthorityRepository.findAll(username);
        return new User(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }

    private cronapp.framework.api.User loadApiUser(String username) throws UsernameNotFoundException {
        ApiManager apiManager = ApiManager.byUser(username);
        try {
            cronapp.framework.api.User apiManagerUser = apiManager.getUser();
            if (apiManagerUser == null) {
                log.debug((Object)("ApiManager returned no results for user '" + username + "'"));
                throw new UsernameNotFoundException("Username " + username + " not found");
            }
            return apiManagerUser;
        }
        catch (Exception e) {
            throw new UsernameNotFoundException("Error loading user " + username, (Throwable)e);
        }
    }

    public void createUser(UserDetails user) {
        if (this.userExists(user.getUsername())) {
            throw new IllegalArgumentException("User already exists: " + user.getUsername());
        }
        if (!(user instanceof CronappUserDetails)) {
            throw new IllegalArgumentException("Only CronappUserDetails is supported");
        }
        CronappUserDetails cronappUser = (CronappUserDetails)user;
        ApiManager apiManager = ApiManager.byUser(user.getUsername());
        apiManager.createUser(cronappUser);
    }

    public void updateUser(UserDetails user) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteUser(String username) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean userExists(String username) {
        ApiManager apiManager = ApiManager.byUser(username);
        return apiManager.getUser() != null;
    }

    @Generated
    public ApiUserDetailsManager(GrantedAuthorityRepository grantedAuthorityRepository) {
        this.grantedAuthorityRepository = grantedAuthorityRepository;
    }
}

