/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.api.ApiManager;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DatabaseAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext context) {
        OrRequestMatcher matcher;
        Collection authorities = authentication.get().getAuthorities();
        List matchers = authorities.stream().flatMap(authority -> ApiManager.getSecurableViews(authority.getAuthority()).stream()).map(securable -> securable.getStringField("pattern")).flatMap(pattern -> Stream.of(pattern.split(","))).distinct().map(AntPathRequestMatcher::new).collect(Collectors.toList());
        boolean isAdmin = authorities.stream().anyMatch(authority -> "Administrators".equalsIgnoreCase(authority.getAuthority()));
        if (isAdmin) {
            return new AuthorizationDecision(true);
        }
        if (!matchers.isEmpty() && (matcher = new OrRequestMatcher(matchers)).matches(context.getRequest())) {
            return new AuthorizationDecision(true);
        }
        return null;
    }
}

