/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import java.util.function.Supplier;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
public class InfrastructureAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    private final RequestMatcher anonymousRequestMatchers = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/login"), new AntPathRequestMatcher("/mobileapp/**"), new AntPathRequestMatcher("/authproviders"), new AntPathRequestMatcher("/favicon.ico"), new AntPathRequestMatcher("/error")});
    private final RequestMatcher authenticatedRequestMatchers = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/me"), new AntPathRequestMatcher("/logout")});

    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext context) {
        boolean isAuthenticaded;
        if (this.anonymousRequestMatchers.matches(context.getRequest())) {
            return new AuthorizationDecision(true);
        }
        Authentication autenticationToken = authentication.get();
        boolean isAnonymous = autenticationToken instanceof AnonymousAuthenticationToken;
        boolean bl = isAuthenticaded = autenticationToken.isAuthenticated() && !isAnonymous;
        if (isAuthenticaded && this.authenticatedRequestMatchers.matches(context.getRequest())) {
            return new AuthorizationDecision(true);
        }
        return null;
    }
}

