/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.api.ApiManager;
import cronapp.framework.security.ApiAuthenticationFailureHandler;
import cronapp.framework.security.ApiAuthenticationSuccessHandler;
import cronapp.framework.security.ApiUserDetailsManager;
import cronapp.framework.security.CronappUserDetails;
import cronapp.framework.security.GrantedAuthorityRepository;
import cronapp.framework.security.HttpSecurityCustomizer;
import cronapp.framework.security.OAuthAuthorizationRequestResolver;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.Customizer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(prefix="cronapp.security.oauth", name={"enabled"}, havingValue="true")
@Component
public class OAuthConfiguration {
    private final GrantedAuthorityRepository authorityRepository;
    private final ApiAuthenticationFailureHandler authenticationFailureHandler;
    private final ApiAuthenticationSuccessHandler authenticationSuccessHandler;
    private final ApiUserDetailsManager userDetailsManager;
    private final OAuthAuthorizationRequestResolver authorizationRequestResolver;

    @Bean
    public HttpSecurityCustomizer oauthCustomizer() {
        return http -> http.oauth2Login(configurer -> {
            configurer.failureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler);
            configurer.successHandler((AuthenticationSuccessHandler)this.authenticationSuccessHandler);
            configurer.userInfoEndpoint(Customizer.withDefaults());
            configurer.withObjectPostProcessor(this::postProcess);
            configurer.authorizationEndpoint(endpoint -> endpoint.authorizationRequestResolver((OAuth2AuthorizationRequestResolver)this.authorizationRequestResolver));
        }).oidcLogout(configurer -> configurer.backChannel(Customizer.withDefaults()));
    }

    @Bean
    public OidcUserService oidcUserService() {
        OidcUserService userService = new OidcUserService();
        DefaultOAuth2UserService defaultUserService = new DefaultOAuth2UserService();
        defaultUserService.setAttributesConverter(source -> {
            HashMap requestAttributes = new HashMap();
            if (source instanceof OidcUserRequest) {
                OidcUserRequest oidcUserRequest = (OidcUserRequest)source;
                requestAttributes.putAll(oidcUserRequest.getIdToken().getClaims());
            }
            return attributes -> {
                attributes.putAll(requestAttributes);
                return requestAttributes;
            };
        });
        userService.setOauth2UserService((OAuth2UserService)defaultUserService);
        return userService;
    }

    private <O> O postProcess(O object) {
        if (object instanceof OAuth2LoginAuthenticationFilter) {
            OAuth2LoginAuthenticationFilter filter = (OAuth2LoginAuthenticationFilter)object;
            filter.setAuthenticationResultConverter(this::convertAuthentication);
        }
        return object;
    }

    private OAuth2AuthenticationToken convertAuthentication(OAuth2LoginAuthenticationToken token) {
        List<SimpleGrantedAuthority> authorities;
        Object object = token.getPrincipal().getAttribute("roles");
        if (object instanceof Collection) {
            Collection roles = (Collection)object;
            authorities = this.authorityRepository.findAll(roles);
        } else {
            authorities = this.authorityRepository.findAll(List.of());
        }
        OAuth2AuthenticationToken result = new OAuth2AuthenticationToken(token.getPrincipal(), authorities, token.getClientRegistration().getRegistrationId());
        if (!this.userDetailsManager.userExists(token.getName())) {
            CronappUserDetails userDetails = OAuthConfiguration.createCronappUserDetails(result);
            this.userDetailsManager.createUser(userDetails);
        }
        result.setDetails((Object)this.userDetailsManager.loadUserByUsername(token.getName()));
        return result;
    }

    public static CronappUserDetails createCronappUserDetails(OAuth2AuthenticationToken userAuthentication) {
        OAuth2User principal = userAuthentication.getPrincipal();
        String name = (String)principal.getAttribute("name");
        String userName = userAuthentication.getName();
        String normalizedUserName = ApiManager.normalize(userName);
        Object email = (String)principal.getAttribute("email");
        String normalizedEmail = ApiManager.normalize((String)email);
        String phone = (String)principal.getAttribute("phone");
        if (StringUtils.isEmpty((CharSequence)phone)) {
            phone = "N/A";
        }
        if (StringUtils.isEmpty((CharSequence)email)) {
            email = normalizedUserName;
        }
        if (!((String)email).contains("@")) {
            email = (String)email + "@no-email";
        }
        if (StringUtils.isEmpty((CharSequence)normalizedEmail)) {
            normalizedEmail = ApiManager.normalize((String)email);
        }
        return CronappUserDetails.newBuilder().setName((String)StringUtils.defaultIfEmpty((CharSequence)name, (CharSequence)userName)).setUserName(userName).setNormalizedUserName(normalizedUserName).setEmail((String)email).setNormalizedEmail(normalizedEmail).setEmailConfirmed(true).setSecurityStamp(UUID.randomUUID().toString()).setPhoneNumber(phone).setPhoneNumberConfirmed(true).setTwoFactorEnabled(false).setLockoutEnd(OffsetDateTime.MIN).setLockoutEnabled(false).setAccessFailedCount(0).setAuthorities(new HashSet<GrantedAuthority>(userAuthentication.getAuthorities())).build();
    }

    @Generated
    public OAuthConfiguration(GrantedAuthorityRepository authorityRepository, ApiAuthenticationFailureHandler authenticationFailureHandler, ApiAuthenticationSuccessHandler authenticationSuccessHandler, ApiUserDetailsManager userDetailsManager, OAuthAuthorizationRequestResolver authorizationRequestResolver) {
        this.authorityRepository = authorityRepository;
        this.authenticationFailureHandler = authenticationFailureHandler;
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        this.userDetailsManager = userDetailsManager;
        this.authorizationRequestResolver = authorizationRequestResolver;
    }
}

