/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.security.ApiAuthenticationFailureHandler;
import cronapp.framework.security.HttpSecurityCustomizer;
import cronapp.framework.security.JwtAuthenticationSuccessHandler;
import cronapp.framework.security.JwtConfigurer;
import cronapp.framework.security.SecuritySupport;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security.token", name={"enabled"}, havingValue="true")
public class JwtConfiguration {
    @Generated
    private static final Log log = LogFactory.getLog(JwtConfiguration.class);
    private final JwtAuthenticationSuccessHandler authenticationSuccessHandler;
    private final ApiAuthenticationFailureHandler authenticationFailureHandler;
    public static final RequestMatcher AUTH_MATCHER = new AntPathRequestMatcher("/auth");

    @Bean
    public HttpSecurityCustomizer jwtCustomizer() {
        return http -> {
            http.csrf(configurer -> configurer.ignoringRequestMatchers(new RequestMatcher[]{AUTH_MATCHER, SecuritySupport.X_AUTH_TOKEN}));
            http.with(new JwtConfigurer(), configurer -> ((JwtConfigurer)configurer.successHandler(this.authenticationSuccessHandler)).failureHandler(this.authenticationFailureHandler));
        };
    }

    @Generated
    public JwtConfiguration(JwtAuthenticationSuccessHandler authenticationSuccessHandler, ApiAuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    @Component
    public static class JwtAuthorizationManager
    implements AuthorizationManager<RequestAuthorizationContext> {
        private final RequestMatcher requestMatchers = new OrRequestMatcher(new RequestMatcher[]{AUTH_MATCHER});

        public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext object) {
            if (this.requestMatchers.matches(object.getRequest())) {
                return new AuthorizationDecision(true);
            }
            return null;
        }
    }
}

